/*
 * Decompiled with CFR 0.152.
 */
package org.mortbay.cometd.continuation;

import dojox.cometd.Client;
import dojox.cometd.Message;
import dojox.cometd.SecurityPolicy;
import java.security.SecureRandom;
import java.util.HashMap;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import javax.servlet.ServletContext;
import org.apache.commons.logging.Log;
import org.exoplatform.services.log.ExoLogger;
import org.mortbay.cometd.ChannelImpl;
import org.mortbay.cometd.ClientImpl;
import org.mortbay.cometd.continuation.ContinuationBayeux;
import org.mortbay.cometd.continuation.EXoContinuationClient;

public class EXoContinuationBayeux
extends ContinuationBayeux {
    private static Map<String, String> userToken = new HashMap<String, String>();
    transient Random random;
    private long timeout;
    private static Log log = ExoLogger.getLogger((String)"ws.EXoContinuationBayeux");

    public EXoContinuationBayeux() {
        this.setSecurityPolicy(new EXoSecurityPolicy());
    }

    public ClientImpl newRemoteClient() {
        EXoContinuationClient client = new EXoContinuationClient(this);
        return client;
    }

    public void setTimeout(long timeout) {
        this.timeout = timeout;
    }

    public long getTimeout() {
        return this.timeout;
    }

    long getRandom(long variation) {
        long l = this.random.nextLong() ^ variation;
        return l < 0L ? -l : l;
    }

    public String getUserToken(String eXoId) {
        if (userToken.containsKey(eXoId)) {
            return userToken.get(eXoId);
        }
        String token = Long.toString(this.getRandom((long)System.identityHashCode((Object)this) ^ System.currentTimeMillis()), 36);
        userToken.put(eXoId, token);
        return token;
    }

    protected void initialize(ServletContext context) {
        super.initialize(context);
        try {
            this.random = SecureRandom.getInstance("SHA1PRNG");
        }
        catch (Exception e) {
            context.log("Could not get secure random for ID generation", (Throwable)e);
            this.random = new Random();
        }
        this.random.setSeed(this.random.nextLong() ^ (long)((Object)((Object)this)).hashCode() ^ (long)(context.hashCode() << 32) ^ Runtime.getRuntime().freeMemory());
        if (log.isDebugEnabled()) {
            log.debug((Object)"Initialized");
        }
    }

    public EXoContinuationClient getClientByEXoId(String eXoID) {
        Set ids = this.getClientIDs();
        for (String id : ids) {
            EXoContinuationClient exoClient;
            Client client = this.getClient(id);
            if (!(client instanceof EXoContinuationClient) || (exoClient = (EXoContinuationClient)client).getEXoId() == null || !exoClient.getEXoId().equals(eXoID)) continue;
            return exoClient;
        }
        return null;
    }

    public void sendBroadcastMessage(String channel, Object data, String msgId) {
        ClientImpl fromClient = (ClientImpl)this.newClient("EXoContinuationBayeux");
        ChannelImpl ch = this.getChannel(channel);
        if (ch != null) {
            ch.publish((Client)fromClient, data, msgId);
            if (log.isDebugEnabled()) {
                log.debug((Object)("Send broadcast message " + data.toString() + " on channel " + channel));
            }
        } else if (log.isDebugEnabled()) {
            log.debug((Object)("Message " + data.toString() + " not send. Channel " + channel + " not exist!"));
        }
    }

    public void sendMessage(String eXoId, String channel, Object data, String id) {
        EXoContinuationClient toClient = this.getClientByEXoId(eXoId);
        ClientImpl fromClient = (ClientImpl)this.newClient("EXoContinuationBayeux");
        if (toClient != null) {
            toClient.deliver((Client)fromClient, channel, data, id);
            if (log.isDebugEnabled()) {
                log.debug((Object)("Send message " + data.toString() + " on channel " + channel + " to client " + eXoId));
            }
        } else if (log.isDebugEnabled()) {
            log.debug((Object)("Message " + data.toString() + " not send on channel " + channel + " client " + eXoId + " not exist!"));
        }
    }

    public static class EXoSecurityPolicy
    implements SecurityPolicy {
        private static Log log = ExoLogger.getLogger((String)"ws.EXoContinuationBayeux.EXoSecurityPolicy");

        public boolean canHandshake(Message message) {
            return this.checkUser(message);
        }

        public boolean canCreate(Client client, String channel, Message message) {
            Boolean b = client != null && !channel.startsWith("/meta/");
            return b;
        }

        public boolean canSubscribe(Client client, String channel, Message message) {
            Boolean b = client != null && !channel.startsWith("/meta/");
            if (!this.checkUser(message)) {
                return false;
            }
            if (((EXoContinuationClient)client).getEXoId() == null) {
                ((EXoContinuationClient)client).setEXoId((String)message.get((Object)"exoId"));
            }
            return client != null && !channel.startsWith("/meta/");
        }

        public boolean canPublish(Client client, String channel, Message message) {
            Boolean b = client != null && !channel.startsWith("/meta/");
            return b;
        }

        private boolean checkUser(Message message) {
            String userId = (String)message.get((Object)"exoId");
            String eXoToken = (String)message.get((Object)"exoToken");
            return userId != null && userToken.containsKey(userId) && ((String)userToken.get(userId)).equals(eXoToken);
        }
    }
}

