/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.ws.frameworks.cometd.transport;

import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.logging.Log;
import org.exoplatform.common.http.client.HTTPConnection;
import org.exoplatform.common.http.client.HTTPResponse;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.ws.frameworks.cometd.loadbalancer.LoadBalancer;
import org.exoplatform.ws.frameworks.cometd.transport.ContinuationServiceDelegate;
import org.exoplatform.ws.frameworks.cometd.transport.DelegateMessage;
import org.exoplatform.ws.frameworks.json.impl.JsonGeneratorImpl;
import org.exoplatform.ws.frameworks.json.value.JsonValue;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ContinuationServiceRemoteDelegate
implements ContinuationServiceDelegate {
    private final Log log = ExoLogger.getLogger((String)"ws.ContinuationServiceRemoteDelegate");
    private final LoadBalancer loadBalancer;

    public ContinuationServiceRemoteDelegate(LoadBalancer loadBalancer) {
        this.loadBalancer = loadBalancer;
    }

    private String getBaseCometdURL(String exoID) {
        return this.loadBalancer.connection(exoID);
    }

    @Override
    public Boolean isSubscribed(String exoID, String channel) {
        try {
            String baseURICometdServer = this.getBaseCometdURL(exoID);
            URL url = new URL(baseURICometdServer + "/rest/issubscribed/" + exoID + "/" + channel + "/");
            HTTPConnection connection = new HTTPConnection(url);
            HTTPResponse response = connection.Get(url.getFile());
            String bol = new String(response.getData());
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)("Check user " + exoID + " subscription to cahnnel " + channel));
            }
            return new Boolean(bol);
        }
        catch (Exception e) {
            this.log.error((Object)"Check user subscription error ", (Throwable)e);
            return null;
        }
    }

    @Override
    public void sendMessage(String exoID, String channel, String message, String msgId) {
        try {
            String baseURICometdServer = this.getBaseCometdURL(exoID);
            URL url = new URL(baseURICometdServer + "/rest/sendprivatemessage/");
            HTTPConnection connection = new HTTPConnection(url);
            DelegateMessage transportData = new DelegateMessage(channel, exoID, message, msgId);
            JsonGeneratorImpl generatorImpl = new JsonGeneratorImpl();
            JsonValue json = generatorImpl.createJsonObject((Object)transportData);
            HTTPResponse response = connection.Post(url.getFile(), json.toString());
            if (response.getStatusCode() == 200) {
                if (this.log.isDebugEnabled()) {
                    this.log.debug((Object)("Send private message : " + message + " to client " + exoID + " by cahnnel " + channel + " success"));
                }
            } else if (this.log.isDebugEnabled()) {
                this.log.debug((Object)("Send private message : " + message + " to client " + exoID + " by cahnnel " + channel + " fail!"));
            }
        }
        catch (Exception e) {
            this.log.error((Object)"Send message error ", (Throwable)e);
        }
    }

    @Override
    public void sendBroadcastMessage(String channel, String message, String msgId) {
        try {
            List<String> us = this.getCometdURLsByChannel(channel);
            if (us != null) {
                for (String u : us) {
                    URL url = new URL(u + "/rest/sendbroadcastmessage/");
                    DelegateMessage transportData = new DelegateMessage(channel, message, msgId);
                    JsonGeneratorImpl generatorImpl = new JsonGeneratorImpl();
                    JsonValue json = generatorImpl.createJsonObject((Object)transportData);
                    HTTPConnection connection = new HTTPConnection(url);
                    HTTPResponse response = connection.Post(url.getFile(), json.toString());
                    if (response.getStatusCode() == 200) {
                        if (!this.log.isDebugEnabled()) continue;
                        this.log.debug((Object)("Send public message : " + message + " to channel " + channel + " success"));
                        continue;
                    }
                    if (!this.log.isDebugEnabled()) continue;
                    this.log.debug((Object)("Send public message : " + message + " to channel " + channel + " fail!"));
                }
            }
        }
        catch (Exception e) {
            this.log.error((Object)"Send message error ", (Throwable)e);
        }
    }

    private List<String> getCometdURLsByChannel(String channel) {
        try {
            List<String> curls = this.loadBalancer.getAliveNodesURL();
            ArrayList<String> urls = new ArrayList<String>();
            for (String curl : curls) {
                String u = new String(curl + "/rest/haschannel?channel=" + channel);
                URL url = new URL(u);
                HTTPConnection connection = new HTTPConnection(url);
                boolean b = Boolean.parseBoolean(new String(connection.Get(url.getFile()).getData()));
                if (!b) continue;
                urls.add(curl);
            }
            return urls;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }
}

