/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.ws.frameworks.cometd.loadbalancer;

import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Response;
import org.apache.commons.logging.Log;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.rest.resource.ResourceContainer;
import org.exoplatform.ws.frameworks.cometd.loadbalancer.LoadBalancer;

@Path(value="/balancer/")
public class RESTLoadBalancerService
implements ResourceContainer {
    private final Log log = ExoLogger.getLogger((String)"ws.RESTLoadBalancerService");
    private LoadBalancer balancer;

    public RESTLoadBalancerService(LoadBalancer balancer) {
        this.balancer = balancer;
    }

    @GET
    @Path(value="/cometdurl/{exoid}/")
    @Produces(value={"text/plain"})
    public Response getCometdURL(@PathParam(value="exoid") String exoid) {
        String url = this.balancer.connection(exoid);
        if (!url.equals("") && url.length() != 0) {
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)("Client with exoid " + exoid + " get URL " + url + " for cometd connection"));
            }
            return Response.ok((Object)url).build();
        }
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("All nodes are owerflow client with exoid " + exoid + " can't connect to cometd!"));
        }
        return Response.status((Response.Status)Response.Status.FORBIDDEN).entity((Object)"Owerflow!").type("text/plain").build();
    }

    @GET
    @Path(value="/releasecometd/{exoid}/")
    public Response release(@PathParam(value="exoid") String exoid) {
        if (this.balancer.release(exoid)) {
            return Response.ok().build();
        }
        return Response.serverError().build();
    }
}

