/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.ws.frameworks.json.impl;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class JsonUtils {
    private static final Map<String, Types> KNOWN_TYPES = new HashMap<String, Types>();

    private JsonUtils() {
    }

    public static String getJsonString(String string) {
        char[] charArray;
        if (string == null || string.length() == 0) {
            return "\"\"";
        }
        StringBuffer sb = new StringBuffer();
        sb.append("\"");
        block9: for (char c : charArray = string.toCharArray()) {
            switch (c) {
                case '\n': {
                    sb.append("\\n");
                    continue block9;
                }
                case '\r': {
                    sb.append("\\r");
                    continue block9;
                }
                case '\t': {
                    sb.append("\\t");
                    continue block9;
                }
                case '\b': {
                    sb.append("\\b");
                    continue block9;
                }
                case '\f': {
                    sb.append("\\f");
                    continue block9;
                }
                case '\\': {
                    sb.append("\\\\");
                    continue block9;
                }
                case '\"': {
                    sb.append("\\\"");
                    continue block9;
                }
                default: {
                    if (c < '\u0010') {
                        sb.append("\\u000" + Integer.toHexString(c));
                        continue block9;
                    }
                    if (c < ' ' && c > '\t' || c >= '\u0080' && c < '\u00a0') {
                        sb.append("\\u00" + Integer.toHexString(c));
                        continue block9;
                    }
                    if (c >= '\u2000' && c < '\u2100') {
                        sb.append("\\u" + Integer.toHexString(c));
                        continue block9;
                    }
                    sb.append(c);
                }
            }
        }
        sb.append("\"");
        return sb.toString();
    }

    public static boolean isKnownType(Object o) {
        if (o == null) {
            return true;
        }
        return JsonUtils.isKnownType(o.getClass());
    }

    public static boolean isKnownType(Class<?> clazz) {
        return KNOWN_TYPES.get(clazz.getName()) != null;
    }

    public static Types getType(Object o) {
        if (o == null) {
            return Types.NULL;
        }
        if (KNOWN_TYPES.get(o.getClass().getName()) != null) {
            return KNOWN_TYPES.get(o.getClass().getName());
        }
        if (o instanceof Object[]) {
            return Types.ARRAY_OBJECT;
        }
        if (o instanceof Collection) {
            return Types.COLLECTION;
        }
        if (o instanceof Map) {
            return Types.MAP;
        }
        return null;
    }

    public static Types getType(Class<?> clazz) {
        if (KNOWN_TYPES.get(clazz.getName()) != null) {
            return KNOWN_TYPES.get(clazz.getName());
        }
        if (clazz.isArray()) {
            return Types.ARRAY_OBJECT;
        }
        if (Collection.class.isAssignableFrom(clazz)) {
            return Types.COLLECTION;
        }
        if (Map.class.isAssignableFrom(clazz)) {
            return Types.MAP;
        }
        return null;
    }

    static {
        KNOWN_TYPES.put(Boolean.class.getName(), Types.BOOLEAN);
        KNOWN_TYPES.put(Byte.class.getName(), Types.BYTE);
        KNOWN_TYPES.put(Short.class.getName(), Types.SHORT);
        KNOWN_TYPES.put(Integer.class.getName(), Types.INT);
        KNOWN_TYPES.put(Long.class.getName(), Types.LONG);
        KNOWN_TYPES.put(Float.class.getName(), Types.FLOAT);
        KNOWN_TYPES.put(Double.class.getName(), Types.DOUBLE);
        KNOWN_TYPES.put(Character.class.getName(), Types.CHAR);
        KNOWN_TYPES.put(String.class.getName(), Types.STRING);
        KNOWN_TYPES.put("boolean", Types.BOOLEAN);
        KNOWN_TYPES.put("byte", Types.BYTE);
        KNOWN_TYPES.put("short", Types.SHORT);
        KNOWN_TYPES.put("int", Types.INT);
        KNOWN_TYPES.put("long", Types.LONG);
        KNOWN_TYPES.put("float", Types.FLOAT);
        KNOWN_TYPES.put("double", Types.DOUBLE);
        KNOWN_TYPES.put("char", Types.CHAR);
        KNOWN_TYPES.put("null", Types.NULL);
        KNOWN_TYPES.put(new boolean[0].getClass().getName(), Types.ARRAY_BOOLEAN);
        KNOWN_TYPES.put(new byte[0].getClass().getName(), Types.ARRAY_BYTE);
        KNOWN_TYPES.put(new short[0].getClass().getName(), Types.ARRAY_SHORT);
        KNOWN_TYPES.put(new int[0].getClass().getName(), Types.ARRAY_INT);
        KNOWN_TYPES.put(new long[0].getClass().getName(), Types.ARRAY_LONG);
        KNOWN_TYPES.put(new double[0].getClass().getName(), Types.ARRAY_DOUBLE);
        KNOWN_TYPES.put(new float[0].getClass().getName(), Types.ARRAY_FLOAT);
        KNOWN_TYPES.put(new char[0].getClass().getName(), Types.ARRAY_CHAR);
        KNOWN_TYPES.put(new String[0].getClass().getName(), Types.ARRAY_STRING);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum JsonToken {
        object,
        array,
        key,
        value;

    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Types {
        BYTE,
        SHORT,
        INT,
        LONG,
        FLOAT,
        DOUBLE,
        BOOLEAN,
        CHAR,
        STRING,
        NULL,
        ARRAY_BYTE,
        ARRAY_SHORT,
        ARRAY_INT,
        ARRAY_LONG,
        ARRAY_FLOAT,
        ARRAY_DOUBLE,
        ARRAY_BOOLEAN,
        ARRAY_CHAR,
        ARRAY_STRING,
        ARRAY_OBJECT,
        COLLECTION,
        MAP;

    }
}

