/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.rest.ext.service;

import java.io.ByteArrayOutputStream;
import java.util.ArrayList;
import java.util.List;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Response;
import javax.xml.stream.XMLOutputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import org.exoplatform.services.rest.ObjectFactory;
import org.exoplatform.services.rest.impl.ResourceBinder;
import org.exoplatform.services.rest.resource.AbstractResourceDescriptor;

@Path(value="/")
public class RestServicesList {
    private final ResourceBinder binder;

    public RestServicesList(ResourceBinder resources) {
        this.binder = resources;
    }

    @GET
    @Produces(value={"text/html"})
    public byte[] listHTML() {
        XMLOutputFactory factory = XMLOutputFactory.newInstance();
        factory.setProperty("javax.xml.stream.isRepairingNamespaces", Boolean.TRUE);
        ByteArrayOutputStream output = new ByteArrayOutputStream();
        try {
            XMLStreamWriter xsw = factory.createXMLStreamWriter(output, "UTF-8");
            xsw.writeStartDocument("UTF-8", "1.0");
            xsw.writeDTD("<!DOCTYPE html PUBLIC \"-//W3C//DTD XHTML 1.0 Strict//EN\" \"http://www.w3.org/TR/xhtml1/DTD/xhtml1-strict.dtd\">");
            xsw.writeCharacters("\n");
            xsw.writeStartElement("html");
            xsw.writeDefaultNamespace("http://www.w3.org/1999/xhtml");
            xsw.writeStartElement("head");
            xsw.writeStartElement("title");
            xsw.writeCharacters("eXo JAXRS Implementation");
            xsw.writeEndElement();
            xsw.writeEndElement();
            xsw.writeStartElement("body");
            xsw.writeStartElement("h3");
            xsw.writeAttribute("style", "text-align:center;");
            xsw.writeCharacters("Root resources");
            xsw.writeEndElement();
            xsw.writeStartElement("table");
            xsw.writeAttribute("width", "90%");
            xsw.writeAttribute("style", "table-layout:fixed;");
            xsw.writeStartElement("tr");
            xsw.writeStartElement("th");
            xsw.writeCharacters("Path");
            xsw.writeEndElement();
            xsw.writeStartElement("th");
            xsw.writeCharacters("Regex");
            xsw.writeEndElement();
            xsw.writeStartElement("th");
            xsw.writeCharacters("FQN");
            xsw.writeEndElement();
            xsw.writeEndElement();
            for (RootResource r : this.rootResources().getRootResources()) {
                xsw.writeStartElement("tr");
                xsw.writeStartElement("td");
                xsw.writeCharacters(r.getPath());
                xsw.writeEndElement();
                xsw.writeStartElement("td");
                xsw.writeCharacters(r.getRegex());
                xsw.writeEndElement();
                xsw.writeStartElement("td");
                xsw.writeCharacters(r.getFqn());
                xsw.writeEndElement();
                xsw.writeEndElement();
            }
            xsw.writeEndElement();
            xsw.writeEndElement();
            xsw.writeEndDocument();
        }
        catch (XMLStreamException xmle) {
            throw new WebApplicationException((Throwable)xmle, Response.status((int)500).entity((Object)("Unable write to output stream. " + xmle.getMessage())).type("text/plain").build());
        }
        return output.toByteArray();
    }

    @GET
    @Produces(value={"application/json"})
    public RootResourcesList listJSON() {
        return this.rootResources();
    }

    protected RootResourcesList rootResources() {
        ArrayList<RootResource> resources = new ArrayList<RootResource>();
        for (ObjectFactory om : this.binder.getResources()) {
            AbstractResourceDescriptor descriptor = (AbstractResourceDescriptor)om.getObjectModel();
            resources.add(new RootResource(descriptor.getObjectClass().getName(), descriptor.getPathValue().getPath(), descriptor.getUriPattern().getRegex()));
        }
        return new RootResourcesList(resources);
    }

    public static class RootResourcesList {
        private List<RootResource> rootResources;

        public RootResourcesList(List<RootResource> rootResources) {
            this.rootResources = rootResources;
        }

        public List<RootResource> getRootResources() {
            return this.rootResources;
        }
    }

    public static class RootResource {
        private String fqn;
        private String path;
        private String regex;

        public RootResource(String fqn, String path, String regex) {
            this.fqn = fqn;
            this.path = path;
            this.regex = regex;
        }

        public String getFqn() {
            return this.fqn;
        }

        public String getPath() {
            return this.path;
        }

        public String getRegex() {
            return this.regex;
        }
    }
}

