/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.security.cas.client;

import java.io.IOException;
import javax.security.auth.login.LoginException;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.logging.Log;
import org.exoplatform.container.ExoContainer;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.security.Authenticator;
import org.exoplatform.services.security.Credential;
import org.exoplatform.services.security.PasswordCredential;
import org.exoplatform.services.security.UsernameCredential;

public abstract class AbstractHTTPUsernamePasswordValidator
extends HttpServlet {
    protected Log log = ExoLogger.getLogger((String)"ws.security.AbstractHTTPUsernamePasswordValidator");

    public final void service(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        String username = request.getParameter("username");
        String password = request.getParameter("password");
        ExoContainer container = this.getContainer();
        Authenticator authenticator = (Authenticator)container.getComponentInstanceOfType(Authenticator.class);
        try {
            if (authenticator == null) {
                throw new LoginException("authenticator not found, check configuration!");
            }
            if (username == null || password == null) {
                throw new LoginException("username or password was not specified!");
            }
            Credential[] credentials = new Credential[]{new UsernameCredential(username), new PasswordCredential(password)};
            authenticator.validateUser(credentials);
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)("authentication success for " + username));
            }
            this.sendSuccessMessage(response, username);
        }
        catch (Exception e) {
            this.log.error((Object)("authentication failed for " + username));
            e.printStackTrace();
            this.sendFailMessage(response, username);
        }
    }

    protected abstract void sendSuccessMessage(HttpServletResponse var1, String var2) throws IOException;

    protected abstract void sendFailMessage(HttpServletResponse var1, String var2) throws IOException;

    protected abstract ExoContainer getContainer();
}

