/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.ws.security.oauth.http;

import java.io.IOException;
import java.io.OutputStream;
import javax.servlet.ServletException;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import net.oauth.OAuth;
import net.oauth.OAuthAccessor;
import net.oauth.OAuthMessage;
import net.oauth.OAuthProblemException;
import net.oauth.server.OAuthServlet;
import org.apache.commons.logging.Log;
import org.exoplatform.container.ExoContainer;
import org.exoplatform.container.ExoContainerContext;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.ws.security.oauth.OAuthProviderService;

public class OAuthAccessTokenServlet
extends HttpServlet {
    private static final long serialVersionUID = 2950381189568117176L;
    private static final Log log = ExoLogger.getLogger((String)"ws.security.OAuthAccessTokenServlet");

    public void service(HttpServletRequest httpRequest, HttpServletResponse httpResponse) throws ServletException, IOException {
        OAuthAccessor accessor;
        OAuthMessage oauthMessage = OAuthServlet.getMessage((HttpServletRequest)httpRequest, null);
        ExoContainer container = ExoContainerContext.getCurrentContainer();
        OAuthProviderService providerService = (OAuthProviderService)container.getComponentInstanceOfType(OAuthProviderService.class);
        try {
            accessor = providerService.getAccessor(oauthMessage);
            if (log.isDebugEnabled()) {
                log.debug((Object)("Accessor: " + accessor));
            }
        }
        catch (OAuthProblemException e) {
            e.printStackTrace();
            httpResponse.sendError(401, "Request token is invalid!");
            return;
        }
        try {
            oauthMessage.validateSignature(accessor);
        }
        catch (Exception e) {
            e.printStackTrace();
            httpResponse.sendError(401, "Signature validation failed!");
            return;
        }
        if (!Boolean.TRUE.equals(accessor.getProperty("authorized")) || accessor.getProperty("userId") == null) {
            httpResponse.sendError(401, "Request token is not authorized!");
            return;
        }
        try {
            providerService.generateAccessToken(accessor);
        }
        catch (OAuthProblemException e) {
            e.printStackTrace();
            httpResponse.sendError(401, "Can't generate access token!");
            return;
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)(accessor.accessToken + "/" + accessor.tokenSecret));
        }
        httpResponse.setContentType("text/plain");
        ServletOutputStream out = httpResponse.getOutputStream();
        OAuth.formEncode((Iterable)OAuth.newList((String[])new String[]{"oauth_token", accessor.accessToken, "oauth_token_secret", accessor.tokenSecret, "userId", (String)accessor.getProperty("userId")}), (OutputStream)out);
        out.flush();
        out.close();
    }
}

