/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.ws.security.oauth.http;

import java.io.IOException;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import net.oauth.OAuth;
import net.oauth.OAuthAccessor;
import net.oauth.OAuthMessage;
import net.oauth.OAuthProblemException;
import net.oauth.server.OAuthServlet;
import org.apache.commons.logging.Log;
import org.exoplatform.container.ExoContainer;
import org.exoplatform.container.ExoContainerContext;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.security.Authenticator;
import org.exoplatform.services.security.Credential;
import org.exoplatform.services.security.PasswordCredential;
import org.exoplatform.services.security.UsernameCredential;
import org.exoplatform.ws.security.oauth.OAuthProviderService;

public class OAuthAuthenticationServlet
extends HttpServlet {
    private static final long serialVersionUID = -876006996763499606L;
    private static final Log log = ExoLogger.getLogger((String)"ws.security.OAuthAuthorizationServlet");
    protected String loginPage;

    public void init(ServletConfig config) throws ServletException {
        this.loginPage = config.getServletContext().getInitParameter("login-page");
        if (this.loginPage == null) {
            throw new ServletException("Login page name not found in web.xml, must be set with parameter name 'login-page'.");
        }
    }

    public void service(HttpServletRequest httpRequest, HttpServletResponse httpResponse) throws ServletException, IOException {
        OAuthMessage oauthMessage = OAuthServlet.getMessage((HttpServletRequest)httpRequest, null);
        ExoContainer container = ExoContainerContext.getCurrentContainer();
        OAuthProviderService providerService = (OAuthProviderService)container.getComponentInstanceOfType(OAuthProviderService.class);
        try {
            OAuthAccessor accessor = providerService.getAccessor(oauthMessage);
            if (Boolean.TRUE.equals(accessor.getProperty("authorized"))) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Already authorized, request token: " + accessor.requestToken + ", secret token: " + accessor.tokenSecret));
                }
                this.sendBack(httpRequest, httpResponse, accessor);
                return;
            }
            String username = httpRequest.getParameter("username");
            String password = httpRequest.getParameter("password");
            if (username == null || username.length() == 0 || password == null || password.length() == 0) {
                httpRequest.getRequestDispatcher(this.loginPage).forward((ServletRequest)httpRequest, (ServletResponse)httpResponse);
                return;
            }
            String userId = null;
            Authenticator authenticator = (Authenticator)container.getComponentInstanceOfType(Authenticator.class);
            Credential[] credentials = new Credential[]{new UsernameCredential(username), new PasswordCredential(password)};
            try {
                userId = authenticator.validateUser(credentials);
            }
            catch (Exception e) {
                e.printStackTrace();
                httpRequest.getRequestDispatcher(this.loginPage + "?usename=" + username).forward((ServletRequest)httpRequest, (ServletResponse)httpResponse);
                return;
            }
            providerService.authorize(accessor, userId);
            if (log.isDebugEnabled()) {
                log.debug((Object)("Authorized, request token: " + accessor.requestToken + ", secret token: " + accessor.tokenSecret + ", userId: " + userId));
            }
            this.sendBack(httpRequest, httpResponse, accessor);
        }
        catch (OAuthProblemException e) {
            throw new ServletException((Throwable)e);
        }
        catch (IOException e) {
            throw new ServletException((Throwable)e);
        }
    }

    private void sendBack(HttpServletRequest httpRequest, HttpServletResponse httpResponse, OAuthAccessor accessor) throws IOException {
        if (log.isDebugEnabled()) {
            log.debug((Object)("Redirect to callback URL: " + accessor.consumer.callbackURL));
        }
        httpResponse.setStatus(302);
        httpResponse.setHeader("Location", OAuth.addParameters((String)accessor.consumer.callbackURL, (String[])new String[]{"oauth_token", accessor.requestToken, "oauth_token_secret", accessor.tokenSecret, "oauth_consumer_key", accessor.consumer.consumerKey, "returnTo", httpRequest.getParameter("returnTo")}));
    }
}

