/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.ws.impl.cxf;

import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.ConnectException;
import java.net.URL;
import javax.xml.ws.Endpoint;
import org.apache.commons.logging.Log;
import org.apache.cxf.bus.CXFBusFactory;
import org.apache.cxf.databinding.DataBinding;
import org.apache.cxf.endpoint.Server;
import org.apache.cxf.endpoint.ServerImpl;
import org.apache.cxf.interceptor.LoggingInInterceptor;
import org.apache.cxf.interceptor.LoggingOutInterceptor;
import org.apache.cxf.jaxb.JAXBDataBinding;
import org.apache.cxf.jaxws.EndpointImpl;
import org.apache.cxf.jaxws.JAXWSMethodInvoker;
import org.apache.cxf.jaxws.JaxWsServerFactoryBean;
import org.apache.cxf.service.Service;
import org.apache.cxf.service.invoker.BeanInvoker;
import org.apache.cxf.service.invoker.Factory;
import org.apache.cxf.service.invoker.Invoker;
import org.apache.cxf.service.invoker.PerRequestFactory;
import org.apache.cxf.service.invoker.PooledFactory;
import org.exoplatform.services.log.ExoLogger;

public class ExoDeployCXFUtils {
    private static Log LOG = ExoLogger.getLogger(ExoDeployCXFUtils.class);

    public static void checkConnectionAndPrint(String address, boolean doprintwsdl) throws ConnectException, Exception {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Check service at the address = " + address));
        }
        URL url = new URL(address + "?wsdl");
        if (doprintwsdl) {
            InputStream inputStream = url.openStream();
            InputStreamReader isr = new InputStreamReader(inputStream);
            BufferedReader in = new BufferedReader(isr);
            if (LOG.isDebugEnabled()) {
                int c;
                System.out.println(">>> CXFUtils.checkConnection() = \n");
                System.out.println(">>> ========================================== ");
                while ((c = ((Reader)in).read()) != -1) {
                    System.out.print((char)c);
                }
                ((Reader)in).close();
                System.out.println("\n>>> ========================================== ");
            }
            inputStream.close();
        }
    }

    public static Server complexDeployService(String address, Object object) {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Starting Service: object = " + object + " at the address = " + address));
        }
        JaxWsServerFactoryBean serverFactory = new JaxWsServerFactoryBean();
        serverFactory.getServiceFactory().setDataBinding((DataBinding)new JAXBDataBinding());
        serverFactory.setServiceClass(object.getClass());
        serverFactory.setAddress(address);
        serverFactory.setBus(CXFBusFactory.getDefaultBus());
        Server server = serverFactory.create();
        if (LOG.isDebugEnabled()) {
            serverFactory.getServiceFactory().getService().getInInterceptors().add(new LoggingInInterceptor());
            serverFactory.getServiceFactory().getService().getOutInterceptors().add(new LoggingOutInterceptor());
        }
        Service service = server.getEndpoint().getService();
        service.setInvoker((Invoker)new BeanInvoker(object));
        server.start();
        return server;
    }

    public static Server complexDeployServiceMultiInstance(String address, Object object, Integer poolSize) {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Starting Service: object = " + object + " at the address = " + address + " with pool size is '" + poolSize + "'"));
        }
        PerRequestFactory factory = new PerRequestFactory(object.getClass());
        JaxWsServerFactoryBean serverFactory = new JaxWsServerFactoryBean();
        serverFactory.getServiceFactory().setDataBinding((DataBinding)new JAXBDataBinding());
        serverFactory.setServiceClass(object.getClass());
        serverFactory.setAddress(address);
        factory = new PooledFactory((Factory)factory, poolSize != null ? poolSize : 4);
        JAXWSMethodInvoker invoker = new JAXWSMethodInvoker((Factory)factory);
        serverFactory.setInvoker((Invoker)invoker);
        Server server = serverFactory.create();
        if (LOG.isDebugEnabled()) {
            serverFactory.getServiceFactory().getService().getInInterceptors().add(new LoggingInInterceptor());
            serverFactory.getServiceFactory().getService().getOutInterceptors().add(new LoggingOutInterceptor());
        }
        Service service = server.getEndpoint().getService();
        service.setInvoker((Invoker)new BeanInvoker(object));
        server.start();
        return server;
    }

    public static Endpoint simpleDeployService(String address, Object object) {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Starting Service: object = " + object + " at the address = " + address));
        }
        Endpoint endpoint = Endpoint.publish((String)address, (Object)object);
        if (LOG.isDebugEnabled()) {
            EndpointImpl endpointImpl = (EndpointImpl)endpoint;
            ServerImpl server = endpointImpl.getServer();
            server.getEndpoint().getInInterceptors().add(new LoggingInInterceptor());
            server.getEndpoint().getOutInterceptors().add(new LoggingOutInterceptor());
        }
        if (endpoint.isPublished()) {
            LOG.info((Object)("The webservice '" + address + "' has been published SUCCESSFUL!"));
        }
        return endpoint;
    }
}

