/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.test.mock;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.PrintWriter;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.TimeZone;
import javax.servlet.ServletOutputStream;
import javax.servlet.WriteListener;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletResponse;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.services.test.mock.CaseInsensitiveMultivaluedMap;

public class MockHttpServletResponse
implements HttpServletResponse {
    private static final Log LOG = ExoLogger.getLogger((String)"exo.ws.testframework.MockHttpServletResponse");
    private PrintWriter writer;
    private ByteArrayOutputStream stream;
    private ByteArrayServletOutputStream output;
    private byte[] buffer = new byte[1024];
    private int bufferCount = 0;
    private List<Cookie> cookies = new ArrayList<Cookie>();
    private HashMap<String, List<String>> headers = new CaseInsensitiveMultivaluedMap<String>();
    private int status = 200;
    private String message = "";
    private Locale locale = Locale.getDefault();
    private String contentType = null;
    protected long contentLength = -1L;
    protected String charset = null;

    public MockHttpServletResponse() {
        this.stream = new ByteArrayOutputStream();
        this.writer = new PrintWriter(this.stream);
        this.output = new ByteArrayServletOutputStream(this.stream);
    }

    public String getOutputContent() {
        return new String(this.stream.toByteArray());
    }

    public void flushBuffer() throws IOException {
        if (this.bufferCount > 0) {
            try {
                this.output.write(this.buffer, 0, this.bufferCount);
            }
            finally {
                this.bufferCount = 0;
            }
        }
    }

    public int getBufferSize() {
        return this.buffer.length;
    }

    public ServletOutputStream getOutputStream() throws IOException {
        return this.output;
    }

    public PrintWriter getWriter() throws IOException {
        return this.writer;
    }

    public boolean isCommitted() {
        return false;
    }

    public void reset() {
        this.bufferCount = 0;
    }

    public void resetBuffer() {
        this.bufferCount = 0;
    }

    public void addCookie(Cookie cookie) {
        this.cookies.add(cookie);
    }

    public void addDateHeader(String name, long value) {
        SimpleDateFormat format = new SimpleDateFormat("EEE, dd MMM yyyy HH:mm:ss zzz", Locale.US);
        format.setTimeZone(TimeZone.getTimeZone("GMT"));
        this.addHeader(name, format.format(new Date(value)));
    }

    public void addHeader(String name, String value) {
        for (String key : this.headers.keySet()) {
            if (!key.equals(name)) continue;
            List<String> values = this.headers.get(key);
            if (values == null) {
                values = new ArrayList<String>();
                this.headers.put(name, values);
            }
            values.add(value);
        }
    }

    public void addIntHeader(String name, int value) {
        this.addHeader(name, "" + value);
    }

    public boolean containsHeader(String name) {
        return this.headers.get(name) != null;
    }

    public String encodeRedirectURL(String url) {
        return url;
    }

    public String encodeRedirectUrl(String url) {
        return url;
    }

    public String encodeURL(String url) {
        return url;
    }

    public String encodeUrl(String url) {
        return url;
    }

    public void sendError(int status) throws IOException {
        this.sendError(status, "");
    }

    public void sendError(int status, String message) throws IOException {
        block2: {
            this.status = status;
            this.message = message;
            this.resetBuffer();
            try {
                this.flushBuffer();
            }
            catch (IOException e) {
                if (!LOG.isTraceEnabled()) break block2;
                LOG.trace((Object)("An exception occurred: " + e.getMessage()));
            }
        }
    }

    public void sendRedirect(String location) throws IOException {
        this.resetBuffer();
        this.setStatus(302);
        this.setHeader("Location", location);
    }

    public void setDateHeader(String name, long value) {
        SimpleDateFormat format = new SimpleDateFormat("EEE, dd MMM yyyy HH:mm:ss zzz", Locale.US);
        format.setTimeZone(TimeZone.getTimeZone("GMT"));
        this.setHeader(name, format.format(new Date(value)));
    }

    public void setHeader(String name, String value) {
        ArrayList<String> values = new ArrayList<String>();
        values.add(value);
        this.headers.put(name, values);
        String match = name.toLowerCase();
        if (match.equals("content-length")) {
            int contentLength = -1;
            contentLength = Integer.parseInt(value);
            if (contentLength >= 0) {
                this.setContentLength(contentLength);
            }
        } else if (match.equals("content-type")) {
            this.setContentType(value);
        }
    }

    public void setIntHeader(String name, int value) {
        this.setHeader(name, "" + value);
    }

    public void setStatus(int status) {
        this.status = status;
    }

    public void setStatus(int status, String message) {
        this.status = status;
        this.message = message;
    }

    public String getCharacterEncoding() {
        if (this.charset == null) {
            return "UTF-8";
        }
        return this.charset;
    }

    public String getContentType() {
        return this.contentType;
    }

    public Locale getLocale() {
        return this.locale;
    }

    public void setBufferSize(int size) {
        if (this.buffer.length >= size) {
            return;
        }
        this.buffer = new byte[size];
    }

    public void setCharacterEncoding(String charset) {
        this.charset = charset;
    }

    public void setContentLength(int length) {
        this.contentLength = length;
    }

    public void setContentType(String type) {
        this.contentType = type;
    }

    public void setLocale(Locale locale) {
        this.locale = locale;
    }

    public int getStatus() {
        return this.status;
    }

    public String getHeader(String name) {
        List<String> _headers = this.headers.get(name);
        return _headers == null || _headers.isEmpty() ? null : _headers.get(0);
    }

    public Collection<String> getHeaders(String name) {
        List<String> _headers = this.headers.get(name);
        return _headers == null ? Collections.EMPTY_LIST : Collections.unmodifiableList(_headers);
    }

    public Collection<String> getHeaderNames() {
        return Collections.unmodifiableSet(this.headers.keySet());
    }

    public void setContentLengthLong(long len) {
        this.contentLength = len;
    }

    private static class ByteArrayServletOutputStream
    extends ServletOutputStream {
        ByteArrayOutputStream baos;

        public ByteArrayServletOutputStream(ByteArrayOutputStream baos) {
            this.baos = baos;
        }

        public void write(int i) throws IOException {
            this.baos.write(i);
        }

        public boolean isReady() {
            return true;
        }

        public void setWriteListener(WriteListener writeListener) {
        }
    }
}

