/*
 * Decompiled with CFR 0.152.
 */
package org.fedorahosted.cobbler;

import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.fedorahosted.cobbler.CobblerConnection;
import org.fedorahosted.cobbler.CobblerObject;
import org.fedorahosted.cobbler.ObjectType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Finder {
    private static final Finder INSTANCE = new Finder();

    private Finder() {
    }

    public static Finder getInstance() {
        return INSTANCE;
    }

    public List<? extends CobblerObject> findItems(CobblerConnection client, ObjectType type, String critera, String value) {
        if (value == null) {
            return null;
        }
        HashMap<String, String> criteria = new HashMap<String, String>();
        criteria.put(critera, value);
        List objects = (List)client.invokeMethod("find_" + type.getName(), criteria);
        return this.maps2Objects(client, type, objects);
    }

    private List<? extends CobblerObject> maps2Objects(CobblerConnection client, ObjectType type, List<Map<String, Object>> maps) {
        LinkedList<CobblerObject> ret = new LinkedList<CobblerObject>();
        for (Map<String, Object> obj : maps) {
            Map blendedDataMap = null;
            if (type == ObjectType.PROFILE) {
                blendedDataMap = (Map)client.invokeMethod("get_blended_data", obj.get("name"));
            } else if (type == ObjectType.SYSTEM) {
                blendedDataMap = (Map)client.invokeMethod("get_blended_data", "", obj.get("name"));
            }
            ret.add(CobblerObject.load(type, client, obj, blendedDataMap));
        }
        return ret;
    }

    public CobblerObject findItemById(CobblerConnection client, ObjectType type, String id) {
        if (id == null) {
            return null;
        }
        List<? extends CobblerObject> items = this.findItems(client, type, "uid", id);
        if (items.isEmpty()) {
            return null;
        }
        return items.get(0);
    }

    public CobblerObject findItemByName(CobblerConnection client, ObjectType type, String name) {
        if (name == null) {
            return null;
        }
        List<? extends CobblerObject> items = this.findItems(client, type, "name", name);
        if (items.isEmpty()) {
            return null;
        }
        return items.get(0);
    }

    public List<? extends CobblerObject> listItems(CobblerConnection client, ObjectType type) {
        List objects = (List)client.invokeNoTokenMethod("get_" + type.getName() + "s", new Object[0]);
        return this.maps2Objects(client, type, objects);
    }
}

