/*
 * Decompiled with CFR 0.152.
 */
package org.ff4j.audit;

import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.RejectedExecutionHandler;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import org.ff4j.audit.Event;
import org.ff4j.audit.EventType;
import org.ff4j.audit.EventWorker;
import org.ff4j.audit.repository.EventRepository;
import org.ff4j.audit.repository.InMemoryEventRepository;

public class EventPublisher {
    public static final int DEFAULT_QUEUE_CAPACITY = 100;
    public static final int DEFAULT_POOL_SIZE = 4;
    public static long timeout = 2000L;
    private ExecutorService executor;
    private EventRepository repository;
    private final long submitTimeout;
    private final boolean shutdownExecutor;

    public EventPublisher() {
        this(100, 4, new InMemoryEventRepository());
    }

    public EventPublisher(EventRepository er) {
        this(100, 4, er);
    }

    public EventPublisher(int queueCapacity, int poolSize, EventRepository er) {
        this(queueCapacity, poolSize, er, timeout);
    }

    public EventPublisher(int queueCapacity, int poolSize, EventRepository er, long submitTimeout) {
        ArrayBlockingQueue<Runnable> queue = new ArrayBlockingQueue<Runnable>(queueCapacity);
        RejectedExecutionHandler rej = new RejectedExecutionHandler(){

            @Override
            public void rejectedExecution(Runnable r, ThreadPoolExecutor executor) {
                try {
                    Thread.sleep(1000L);
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
                executor.execute(r);
            }
        };
        class CustomThreadFactory
        implements ThreadFactory {
            final AtomicInteger poolNumber = new AtomicInteger(1);
            final ThreadGroup group;
            final AtomicInteger threadNumber = new AtomicInteger(1);
            final String namePrefix;

            CustomThreadFactory() {
                SecurityManager s = System.getSecurityManager();
                this.group = s != null ? s.getThreadGroup() : Thread.currentThread().getThreadGroup();
                this.namePrefix = "ff4j-monitoring-pool-" + this.poolNumber.getAndIncrement() + "-thread-";
            }

            @Override
            public Thread newThread(Runnable r) {
                Thread t = new Thread(this.group, r, this.namePrefix + this.threadNumber.getAndIncrement(), 0L);
                if (t.isDaemon()) {
                    t.setDaemon(false);
                }
                if (t.getPriority() != 5) {
                    t.setPriority(5);
                }
                return t;
            }
        }
        this.executor = new ThreadPoolExecutor(poolSize, poolSize, 0L, TimeUnit.MILLISECONDS, queue, new CustomThreadFactory(), rej);
        this.repository = er;
        this.submitTimeout = submitTimeout;
        this.shutdownExecutor = true;
    }

    public EventPublisher(EventRepository er, ExecutorService executorService) {
        this(er, executorService, timeout);
    }

    public EventPublisher(EventRepository er, ExecutorService executorService, long submitTimeout) {
        this.repository = er;
        this.executor = executorService;
        this.submitTimeout = submitTimeout;
        this.shutdownExecutor = false;
    }

    public void publish(Event e) {
        Future<Boolean> check = this.executor.submit(new EventWorker(e, this.repository));
        try {
            if (this.submitTimeout != 0L) {
                check.get(this.submitTimeout, TimeUnit.MILLISECONDS);
            }
        }
        catch (Exception e1) {
            e1.printStackTrace();
            System.err.println("Cannot push event into monitoring");
        }
    }

    public void publish(String featureName, EventType type) {
        this.publish(new Event(featureName, type));
    }

    public void publish(String featureName, boolean flipped) {
        Event evt = new Event(featureName, EventType.FEATURE_CHECK_ON);
        if (!flipped) {
            evt.setType(EventType.FEATURE_CHECK_OFF);
        }
        this.publish(evt);
    }

    public void stop() {
        if (!this.shutdownExecutor) {
            return;
        }
        this.executor.shutdownNow();
    }

    public void setRepository(EventRepository repository) {
        this.repository = repository;
    }

    public EventRepository getRepository() {
        return this.repository;
    }
}

