/*
 * Decompiled with CFR 0.152.
 */
package org.ff4j.audit.repository;

import java.util.Calendar;
import java.util.Date;
import org.ff4j.audit.graph.BarChart;
import org.ff4j.audit.graph.PieChart;
import org.ff4j.audit.graph.PieSector;
import org.ff4j.audit.repository.EventRepository;

public abstract class AbstractEventRepository
implements EventRepository {
    @Override
    public BarChart getHitsBarChart(long startTime, long endTime, int nbslot) {
        return this.getHitsBarChart(this.getFeatureNames(), startTime, endTime, nbslot);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        sb.append("\"type\":\"" + this.getClass().getCanonicalName() + "\"");
        Calendar c = Calendar.getInstance();
        c.set(11, 0);
        c.set(12, 0);
        c.set(13, 0);
        Calendar c2 = Calendar.getInstance();
        c2.setTime(new Date(System.currentTimeMillis() + 86400000L));
        c2.set(11, 0);
        c2.set(12, 0);
        c2.set(13, 0);
        PieChart pie = this.getHitsPieChart(c.getTimeInMillis(), c2.getTimeInMillis());
        sb.append(",\"todayHitsPie\": " + pie.toJson());
        BarChart barChart = this.getHitsBarChart(c.getTimeInMillis(), c2.getTimeInMillis(), 24);
        sb.append(",\"todayHitsBarChart\": " + barChart.toJson());
        int total = 0;
        for (PieSector sector : pie.getSectors()) {
            total = (int)((double)total + sector.getValue());
        }
        sb.append(",\"todayHitTotal\":" + total);
        sb.append("}");
        return sb.toString();
    }
}

