/*
 * Decompiled with CFR 0.152.
 */
package org.ff4j.audit.repository;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.sql.DataSource;
import org.ff4j.audit.Event;
import org.ff4j.audit.EventType;
import org.ff4j.audit.graph.BarChart;
import org.ff4j.audit.graph.BarSeries;
import org.ff4j.audit.graph.PieChart;
import org.ff4j.audit.graph.PieSector;
import org.ff4j.audit.repository.AbstractEventRepository;
import org.ff4j.exception.AuditAccessException;
import org.ff4j.exception.FeatureAccessException;
import org.ff4j.store.JdbcStoreConstants;
import org.ff4j.utils.JdbcUtils;
import org.ff4j.utils.Util;

public class JdbcEventRepository
extends AbstractEventRepository
implements JdbcStoreConstants {
    private DataSource dataSource;

    public JdbcEventRepository(DataSource jdbcDS) {
        this.dataSource = jdbcDS;
    }

    @Override
    public int getTotalEventCount() {
        ResultSet rs;
        PreparedStatement stmt;
        Connection sqlConn;
        block4: {
            int n;
            sqlConn = null;
            stmt = null;
            rs = null;
            try {
                sqlConn = this.dataSource.getConnection();
                stmt = sqlConn.prepareStatement("SELECT COUNT(*) FROM FF4J_AUDIT");
                rs = stmt.executeQuery();
                if (!rs.next()) break block4;
                n = rs.getInt(1);
            }
            catch (Exception exc) {
                try {
                    throw new AuditAccessException("Cannot read audit information from database ", exc);
                }
                catch (Throwable throwable) {
                    JdbcUtils.closeResultSet(rs);
                    JdbcUtils.closeStatement(stmt);
                    JdbcUtils.closeConnection(sqlConn);
                    throw throwable;
                }
            }
            JdbcUtils.closeResultSet(rs);
            JdbcUtils.closeStatement(stmt);
            JdbcUtils.closeConnection(sqlConn);
            return n;
        }
        JdbcUtils.closeResultSet(rs);
        JdbcUtils.closeStatement(stmt);
        JdbcUtils.closeConnection(sqlConn);
        return 0;
    }

    @Override
    public boolean saveEvent(Event evt) {
        Util.assertNotNull(evt);
        Util.assertHasLength(evt.getFeatureName());
        Connection sqlConn = null;
        PreparedStatement stmt = null;
        try {
            sqlConn = this.dataSource.getConnection();
            sqlConn.setAutoCommit(false);
            stmt = sqlConn.prepareStatement("INSERT INTO FF4J_AUDIT(EVT_TIME,EVT_TYPE,FEAT_UID) VALUES (?,?, ?)");
            stmt.setTimestamp(1, new Timestamp(evt.getTimestamp()));
            stmt.setString(2, evt.getType().toString());
            stmt.setString(3, evt.getFeatureName());
            stmt.executeUpdate();
            sqlConn.commit();
        }
        catch (Exception exc) {
            try {
                throw new RuntimeException("Cannot insert event into DB", exc);
            }
            catch (Throwable throwable) {
                JdbcUtils.closeStatement(stmt);
                JdbcUtils.closeConnection(sqlConn);
                throw throwable;
            }
        }
        JdbcUtils.closeStatement(stmt);
        JdbcUtils.closeConnection(sqlConn);
        return true;
    }

    @Override
    public Set<String> getFeatureNames() {
        HashSet<String> hashSet;
        HashSet<String> listOfFeatureNames = new HashSet<String>();
        Connection sqlConn = null;
        PreparedStatement ps = null;
        ResultSet rs = null;
        try {
            sqlConn = this.dataSource.getConnection();
            ps = sqlConn.prepareStatement("SELECT DISTINCT FEAT_UID FROM FF4J_AUDIT");
            rs = ps.executeQuery();
            while (rs.next()) {
                listOfFeatureNames.add(rs.getString("FEAT_UID"));
            }
            hashSet = listOfFeatureNames;
        }
        catch (SQLException sqlEX) {
            try {
                throw new FeatureAccessException("Cannot check feature existence, error related to database", sqlEX);
            }
            catch (Throwable throwable) {
                JdbcUtils.closeResultSet(rs);
                JdbcUtils.closeStatement(ps);
                JdbcUtils.closeConnection(sqlConn);
                throw throwable;
            }
        }
        JdbcUtils.closeResultSet(rs);
        JdbcUtils.closeStatement(ps);
        JdbcUtils.closeConnection(sqlConn);
        return hashSet;
    }

    @Override
    public PieChart getHitsPieChart(long startTime, long endTime) {
        PieChart pieGraph = new PieChart("Total Hit Counts");
        Set<String> features = this.getFeatureNames();
        List<String> colors = Util.getColorsGradient(features.size());
        Connection sqlConn = null;
        PreparedStatement ps = null;
        ResultSet rs = null;
        try {
            sqlConn = this.dataSource.getConnection();
            int idx = 0;
            for (String featName : features) {
                int counter = 0;
                ps = sqlConn.prepareStatement(SQL_AUDIT_COUNTFEATURE);
                ps.setString(1, featName);
                ps.setTimestamp(2, new Timestamp(startTime));
                ps.setTimestamp(3, new Timestamp(endTime));
                rs = ps.executeQuery();
                if (rs.next()) {
                    counter = rs.getInt(1);
                }
                pieGraph.getSectors().add(new PieSector(featName, counter, colors.get(idx)));
            }
        }
        catch (SQLException sqlEX) {
            throw new AuditAccessException("Cannot build PieChart from repository, ", sqlEX);
        }
        finally {
            JdbcUtils.closeResultSet(rs);
            JdbcUtils.closeStatement(ps);
            JdbcUtils.closeConnection(sqlConn);
        }
        return pieGraph;
    }

    @Override
    public BarChart getHitsBarChart(Set<String> featNameSet, long startTime, long endTime, int nbslot) {
        long slotWitdh = (endTime - startTime) / (long)nbslot;
        SimpleDateFormat sdf = new SimpleDateFormat("HH:mm");
        ArrayList<String> labels = new ArrayList<String>();
        for (int i = 0; i < nbslot; ++i) {
            labels.add(sdf.format(new Date(startTime + slotWitdh * (long)i)));
        }
        BarChart barChart = new BarChart("HitCounts Distribution", labels, new ArrayList<String>(featNameSet));
        Connection sqlConn = null;
        PreparedStatement ps = null;
        ResultSet rs = null;
        try {
            sqlConn = this.dataSource.getConnection();
            for (String featName : this.getFeatureNames()) {
                ps = sqlConn.prepareStatement(SQL_AUDIT_FEATURE_EVENTOK);
                ps.setString(1, featName);
                ps.setTimestamp(2, new Timestamp(startTime));
                ps.setTimestamp(3, new Timestamp(endTime));
                rs = ps.executeQuery();
                BarSeries currentSeries = barChart.getSeries().get(featName);
                while (rs.next()) {
                    long timestamp = rs.getTimestamp("EVT_TIME").getTime();
                    currentSeries.incrCount((int)((timestamp - startTime) / slotWitdh));
                }
            }
        }
        catch (SQLException sqlEX) {
            throw new AuditAccessException("Cannot build PieChart from repository, ", sqlEX);
        }
        finally {
            JdbcUtils.closeResultSet(rs);
            JdbcUtils.closeStatement(ps);
            JdbcUtils.closeConnection(sqlConn);
        }
        return barChart;
    }

    @Override
    public PieChart getFeatureHitsPie(String featureId, long startTime, long endTime) {
        PieChart pieChart;
        List<String> colors = Util.getColorsGradient(4);
        PieChart pieGraph = new PieChart("Hits Count for " + featureId);
        Connection sqlConn = null;
        PreparedStatement ps = null;
        ResultSet rs = null;
        try {
            sqlConn = this.dataSource.getConnection();
            ps = sqlConn.prepareStatement("SELECT * FROM FF4J_AUDIT WHERE (FEAT_UID LIKE ?) AND   (EVT_TIME> ?)  AND   (EVT_TIME< ?)");
            ps.setString(1, featureId);
            ps.setTimestamp(2, new Timestamp(startTime));
            ps.setTimestamp(3, new Timestamp(endTime));
            rs = ps.executeQuery();
            int nbEnable = 0;
            int nbDisable = 0;
            int nbFlip = 0;
            int notFlip = 0;
            while (rs.next()) {
                switch (EventType.valueOf(rs.getString("EVT_TYPE"))) {
                    case FEATURE_CHECK_ON: {
                        ++nbFlip;
                        break;
                    }
                    case FEATURE_CHECK_OFF: {
                        ++notFlip;
                        break;
                    }
                    case ENABLE_FEATURE: {
                        ++nbEnable;
                        break;
                    }
                    case DISABLE_FEATURE: {
                        ++nbDisable;
                    }
                }
            }
            if (nbEnable > 0) {
                pieGraph.getSectors().add(new PieSector(EventType.ENABLE_FEATURE.toString(), nbEnable, colors.get(0)));
            }
            if (nbDisable > 0) {
                pieGraph.getSectors().add(new PieSector(EventType.DISABLE_FEATURE.toString(), nbDisable, colors.get(1)));
            }
            if (nbFlip > 0) {
                pieGraph.getSectors().add(new PieSector(EventType.FEATURE_CHECK_ON.toString(), nbFlip, colors.get(2)));
            }
            if (notFlip > 0) {
                pieGraph.getSectors().add(new PieSector(EventType.FEATURE_CHECK_OFF.toString(), notFlip, colors.get(3)));
            }
            pieChart = pieGraph;
        }
        catch (SQLException sqlEX) {
            try {
                throw new AuditAccessException("Cannot build PieChart from repository, ", sqlEX);
            }
            catch (Throwable throwable) {
                JdbcUtils.closeResultSet(rs);
                JdbcUtils.closeStatement(ps);
                JdbcUtils.closeConnection(sqlConn);
                throw throwable;
            }
        }
        JdbcUtils.closeResultSet(rs);
        JdbcUtils.closeStatement(ps);
        JdbcUtils.closeConnection(sqlConn);
        return pieChart;
    }

    public DataSource getDataSource() {
        return this.dataSource;
    }

    public void setDataSource(DataSource dataSource) {
        this.dataSource = dataSource;
    }
}

