/*
 * Decompiled with CFR 0.152.
 */
package org.ff4j.property.store;

import java.io.InputStream;
import java.util.Map;
import java.util.Set;
import org.ff4j.conf.XmlConfiguration;
import org.ff4j.conf.XmlParser;
import org.ff4j.property.AbstractProperty;
import org.ff4j.property.store.PropertyStore;

public abstract class AbstractPropertyStore
implements PropertyStore {
    public Map<String, AbstractProperty<?>> importPropertiesFromXmlFile(String xmlConfFile) {
        if (xmlConfFile == null || xmlConfFile.isEmpty()) {
            throw new IllegalArgumentException("Configuration filename cannot be null nor empty");
        }
        InputStream xmlIS = this.getClass().getClassLoader().getResourceAsStream(xmlConfFile);
        if (xmlIS == null) {
            throw new IllegalArgumentException("File " + xmlConfFile + " could not be read, please check path and rights");
        }
        XmlConfiguration conf = new XmlParser().parseConfigurationFile(xmlIS);
        Map<String, AbstractProperty<?>> properties = conf.getProperties();
        for (String featureName : properties.keySet()) {
            if (this.exist(featureName)) {
                this.delete(featureName);
            }
            this.create(properties.get(featureName));
        }
        return properties;
    }

    public String toJson() {
        StringBuilder sb = new StringBuilder("{");
        sb.append("\"type\":\"" + this.getClass().getCanonicalName() + "\"");
        Set<String> myProperties = this.readAllProperties().keySet();
        sb.append(",\"numberOfProperties\":" + myProperties.size());
        sb.append(",\"properties\":[");
        boolean first = true;
        for (String myProperty : myProperties) {
            if (!first) {
                sb.append(",");
            }
            first = false;
            sb.append("\"" + myProperty + "\"");
        }
        sb.append("]}");
        return sb.toString();
    }
}

