/*
 * Decompiled with CFR 0.152.
 */
package org.ff4j.strategy;

import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.ff4j.core.FeatureStore;
import org.ff4j.core.FlippingExecutionContext;
import org.ff4j.strategy.AbstractFlipStrategy;
import org.ff4j.utils.Util;

public class OfficeHourStrategy
extends AbstractFlipStrategy {
    private static final DateFormat SDF_HOUR = new SimpleDateFormat("HH:mm");
    private static final DateFormat SDF_DATE = new SimpleDateFormat("yyyy-MM-dd");
    private static final String MONDAY = "monday";
    private static final String TUESDAY = "tuesday";
    private static final String WEDNESDAY = "wednesday";
    private static final String THURSDAY = "thursday";
    private static final String FRIDAY = "friday";
    private static final String SATURDAY = "saturday";
    private static final String SUNDAY = "sunday";
    private static final String PUBLICHOLIDAY = "publicHolidays";
    private static final String SPECIAL_OPENINGS = "specialOpenings";
    public static final String OVERRIDE_DATE = "overridedDate";
    private Map<Integer, List<HourInterval>> weekTimeTable = new HashMap<Integer, List<HourInterval>>();
    private Map<String, List<HourInterval>> specialTimeTable = new HashMap<String, List<HourInterval>>();
    private List<String> publicHolidays = new ArrayList<String>();

    @Override
    public void init(String featureName, Map<String, String> initParam) {
        String[] days;
        super.init(featureName, initParam);
        this.weekTimeTable.put(2, this.parseIntervalsExpression(initParam.get(MONDAY)));
        this.weekTimeTable.put(3, this.parseIntervalsExpression(initParam.get(TUESDAY)));
        this.weekTimeTable.put(4, this.parseIntervalsExpression(initParam.get(WEDNESDAY)));
        this.weekTimeTable.put(5, this.parseIntervalsExpression(initParam.get(THURSDAY)));
        this.weekTimeTable.put(6, this.parseIntervalsExpression(initParam.get(FRIDAY)));
        this.weekTimeTable.put(7, this.parseIntervalsExpression(initParam.get(SATURDAY)));
        this.weekTimeTable.put(1, this.parseIntervalsExpression(initParam.get(SUNDAY)));
        if (initParam.containsKey(PUBLICHOLIDAY) && (days = initParam.get(PUBLICHOLIDAY).split(",")) != null) {
            for (String day : days) {
                try {
                    Calendar c = Calendar.getInstance();
                    c.setTime(SDF_DATE.parse(day.trim()));
                    c.set(14, 0);
                    c.set(13, 0);
                    c.set(12, 0);
                    c.set(11, 0);
                    this.publicHolidays.add(SDF_DATE.format(c.getTime()));
                }
                catch (ParseException e) {
                    throw new IllegalArgumentException("Invalid Syntax for <" + day + "> expected 'yyyy-MM-dd'", e);
                }
            }
        }
        if (initParam.containsKey(SPECIAL_OPENINGS) && (days = initParam.get(SPECIAL_OPENINGS).split(";")) != null) {
            for (String day : days) {
                String[] partDay = day.split("@");
                if (partDay.length != 2) {
                    throw new IllegalArgumentException("Invalid Syntax");
                }
                String dateExpression = partDay[1].trim();
                try {
                    SDF_DATE.parse(dateExpression);
                    String inter = partDay[0].trim();
                    String extractIntervals = inter.substring(1, inter.length() - 1);
                    this.specialTimeTable.put(dateExpression, this.parseIntervalsExpression(extractIntervals));
                }
                catch (ParseException e) {
                    throw new IllegalArgumentException("Invalid Syntax for '" + dateExpression + "' expected 'yyyy-MM-dd'", e);
                }
            }
        }
    }

    private List<HourInterval> parseIntervalsExpression(String expression) {
        String[] chunks;
        ArrayList<HourInterval> lhi = new ArrayList<HourInterval>();
        if (expression != null && !"".equals(expression) && (chunks = expression.split(",")) != null) {
            for (String chunk : chunks) {
                lhi.add(new HourInterval(chunk));
            }
        }
        return lhi;
    }

    private boolean matches(Calendar cal, List<HourInterval> listOfHI) {
        if (listOfHI == null) {
            return false;
        }
        boolean found = false;
        for (int idx = 0; !found && idx < listOfHI.size(); ++idx) {
            found = listOfHI.get(idx).matches(cal);
        }
        return found;
    }

    @Override
    public boolean evaluate(String featureName, FeatureStore store, FlippingExecutionContext executionContext) {
        String currentDate;
        Calendar now = Calendar.getInstance();
        if (executionContext != null && executionContext.containsKey(OVERRIDE_DATE)) {
            now = (Calendar)executionContext.getValue(OVERRIDE_DATE, false);
        }
        if (this.specialTimeTable.containsKey(currentDate = SDF_DATE.format(now.getTime()))) {
            return this.matches(now, this.specialTimeTable.get(currentDate));
        }
        if (this.publicHolidays.contains(currentDate)) {
            return false;
        }
        return this.matches(now, this.weekTimeTable.get(now.get(7)));
    }

    public static final class HourInterval {
        private Calendar from = Calendar.getInstance();
        private Calendar to = Calendar.getInstance();

        protected HourInterval() {
        }

        protected HourInterval(String expression) {
            Util.assertHasLength(expression);
            String[] bounds = expression.split("-");
            if (bounds.length != 2) {
                throw new IllegalArgumentException("Invalid syntax, expected HH:mm-HH:MM " + expression);
            }
            this.init(bounds[0], bounds[1]);
        }

        protected HourInterval(String f, String t) {
            this.init(f, t);
        }

        protected void init(String f, String t) {
            try {
                this.from.setTime(SDF_HOUR.parse(f));
                this.to.setTime(SDF_HOUR.parse(t));
                if (!this.from.before(this.to)) {
                    Calendar cal = this.to;
                    this.to = this.from;
                    this.from = cal;
                }
            }
            catch (ParseException e) {
                throw new IllegalArgumentException("Cannot parse incoming expressions <" + f + ">, <" + t + ">", e);
            }
        }

        public HourInterval(Date froms, Date tos) {
            if (froms.before(tos)) {
                this.from.setTime(froms);
                this.to.setTime(tos);
            } else {
                this.from.setTime(tos);
                this.to.setTime(froms);
            }
        }

        public HourInterval(Calendar froms, Calendar tos) {
            this(froms.getTime(), tos.getTime());
        }

        public boolean matches() {
            return this.matches(Calendar.getInstance());
        }

        public boolean matches(Calendar cal) {
            this.from.set(1, cal.get(1));
            this.from.set(6, cal.get(6));
            this.to.set(1, cal.get(1));
            this.to.set(6, cal.get(6));
            return this.from.before(cal) && this.to.after(cal);
        }

        public Calendar getFrom() {
            return this.from;
        }

        public void setFrom(Calendar from) {
            this.from = from;
        }

        public Calendar getTo() {
            return this.to;
        }

        public void setTo(Calendar to) {
            this.to = to;
        }
    }
}

