/*
 * Decompiled with CFR 0.152.
 */
package org.ff4j.strategy;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Map;
import org.ff4j.core.FeatureStore;
import org.ff4j.core.FlippingExecutionContext;
import org.ff4j.strategy.AbstractFlipStrategy;

public class ReleaseDateFlipStrategy
extends AbstractFlipStrategy {
    public static final String DATE_PATTERN = "yyyy-MM-dd-HH:mm";
    public static final SimpleDateFormat SDF = new SimpleDateFormat("yyyy-MM-dd-HH:mm");
    private static final String PARAMNAME_RELEASEDATE = "releaseDate";
    private Date releaseDate = new Date();

    public ReleaseDateFlipStrategy() {
    }

    public ReleaseDateFlipStrategy(String strDate) {
        try {
            this.releaseDate = SDF.parse(strDate);
        }
        catch (ParseException e) {
            throw new IllegalArgumentException("Cannot parse release date, invalid format correct is 'yyyy-MM-dd-HH:mm'", e);
        }
        this.getInitParams().put(PARAMNAME_RELEASEDATE, strDate);
    }

    public ReleaseDateFlipStrategy(Date releaseDate) {
        this.releaseDate = releaseDate;
        this.getInitParams().put(PARAMNAME_RELEASEDATE, SDF.format(releaseDate));
    }

    @Override
    public void init(String featureName, Map<String, String> initParam) {
        super.init(featureName, initParam);
        this.assertRequiredParameter(PARAMNAME_RELEASEDATE);
        try {
            this.releaseDate = SDF.parse(initParam.get(PARAMNAME_RELEASEDATE));
        }
        catch (ParseException e) {
            throw new IllegalArgumentException("Cannot parse release date, invalid format correct is 'yyyy-MM-dd-HH:mm'", e);
        }
    }

    @Override
    public boolean evaluate(String featureName, FeatureStore store, FlippingExecutionContext executionContext) {
        return new Date().after(this.releaseDate);
    }

    public void setReleaseDate(Date releaseDate) {
        this.releaseDate = releaseDate;
    }
}

