/*
 * Decompiled with CFR 0.152.
 */
package org.ff4j.utils;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public abstract class Util {
    private static final String START_COLOR = "00AB8B";
    private static final String END_COLOR = "EEFFEE";

    private Util() {
    }

    public static void assertTrue(boolean expression) {
        if (!expression) {
            throw new IllegalArgumentException("[Assertion failed] - this expression must be true");
        }
    }

    public static void assertNull(Object object) {
        if (object != null) {
            throw new IllegalArgumentException("[Assertion failed] - the object argument must be null");
        }
    }

    public static void assertNotNull(Object object) {
        if (object == null) {
            throw new IllegalArgumentException("[Assertion failed] - this argument is required; it must not be null");
        }
    }

    public static void assertHasLength(String text) {
        if (null == text || text.isEmpty()) {
            throw new IllegalArgumentException("[Assertion failed] - Target STRING must not be null nor empty");
        }
    }

    public static void assertNotEmpty(Collection<?> collec) {
        if (null == collec || collec.isEmpty()) {
            throw new IllegalArgumentException("[Assertion failed] - Target COLLECTION must not be null nor empty");
        }
    }

    public static void assertParamNotNull(String param, String paramName) {
        if (param == null || param.isEmpty()) {
            throw new IllegalArgumentException("Missing Parameter '" + paramName + "' must not be null nor empty");
        }
    }

    public static <T> Set<T> set(T ... els) {
        return new HashSet<T>(Arrays.asList(els));
    }

    private static List<String> getColorGradient(String codeFrom, String codeTo, int nbDivision) {
        ArrayList<String> colors = new ArrayList<String>();
        if (nbDivision > 0) {
            int rStart = Integer.parseInt(codeFrom.substring(0, 2), 16);
            int rDelta = (Integer.parseInt(codeTo.substring(0, 2), 16) - rStart) / nbDivision;
            int gStart = Integer.parseInt(codeFrom.substring(2, 4), 16);
            int gDelta = (Integer.parseInt(codeTo.substring(2, 4), 16) - gStart) / nbDivision;
            int bStart = Integer.parseInt(codeFrom.substring(4, 6), 16);
            int bDelta = (Integer.parseInt(codeTo.substring(4, 6), 16) - bStart) / nbDivision;
            for (int idx = 0; idx < nbDivision; ++idx) {
                String red = Integer.toHexString(rStart + rDelta * idx);
                String green = Integer.toHexString(gStart + gDelta * idx);
                String blue = Integer.toHexString(bStart + bDelta * idx);
                colors.add(red + green + blue);
            }
        }
        return colors;
    }

    public static List<String> getColorsGradient(int nbsectors) {
        return Util.getColorGradient(START_COLOR, END_COLOR, nbsectors);
    }
}

