/*
 * Decompiled with CFR 0.152.
 */
package org.finra.msd.launcher;

import java.io.IOException;
import org.finra.msd.containers.AppleTable;
import org.finra.msd.containers.CmdLine;
import org.finra.msd.containers.SourceVars;
import org.finra.msd.sparkcompare.SparkCompare;
import org.finra.msd.sparkfactory.SparkFactory;
import scala.Option;

public class Launcher {
    public static void main(String[] args) throws IOException {
        CmdLine values = new CmdLine(args);
        SourceVars sv1 = new SourceVars(values.getSource1());
        SourceVars sv2 = new SourceVars(values.getSource2());
        SparkFactory.initializeSparkContext();
        AppleTable leftAppleTable = Launcher.generateAppleTable(sv1, values.getData1(), "table1");
        AppleTable rightAppleTable = Launcher.generateAppleTable(sv2, values.getData2(), "table2");
        SparkCompare.compareAppleTablesSaveResults(leftAppleTable, rightAppleTable, values.getOutputDirectory(), true, values.getDelimiter());
        SparkFactory.stopSparkContext();
    }

    public static AppleTable generateAppleTable(SourceVars sv, String dataSetName, String tempViewName) {
        switch (sv.getConnection().toLowerCase()) {
            case "jdbc": {
                return SparkFactory.parallelizeJDBCSource(sv.getVar("driver"), sv.getVar("url"), sv.getVar("user"), sv.getVar("password"), sv.getQuery(dataSetName), tempViewName, (Option<String>)Option.apply((Object)sv.getVar("delimiter")));
            }
            case "hive": {
                return SparkFactory.parallelizeHiveSource(sv.getQuery(dataSetName), tempViewName);
            }
            case "file": {
                return SparkFactory.parallelizeTextSource(sv.getQuery(dataSetName), tempViewName);
            }
        }
        return null;
    }
}

