/*
 * Decompiled with CFR 0.152.
 */
package org.finra.msd.visualization;

import java.io.Serializable;
import org.apache.spark.sql.Column;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.functions$;
import org.finra.msd.controllers.TemplateController$;
import org.finra.msd.customExceptions.ColumnNullException;
import org.finra.msd.customExceptions.ColumnNullException$;
import org.finra.msd.customExceptions.DataFrameNullException;
import org.finra.msd.customExceptions.DataFrameNullException$;
import org.finra.msd.customExceptions.InValidKeyException;
import org.finra.msd.customExceptions.InValidKeyException$;
import org.finra.msd.customExceptions.JoinKeysNullException;
import org.finra.msd.customExceptions.JoinKeysNullException$;
import org.finra.msd.customExceptions.SparkSessionNullException;
import org.finra.msd.customExceptions.SparkSessionNullException$;
import org.finra.msd.enums.VisualResultType;
import org.finra.msd.sparkfactory.SparkFactory$;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.Option;
import scala.Option$;
import scala.Predef;
import scala.Predef$;
import scala.StringContext;
import scala.Tuple3;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableOnce;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Map;
import scala.collection.mutable.ArrayOps;
import scala.reflect.ClassTag$;
import scala.runtime.BooleanRef;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.Nothing$;

public final class Visualizer$ {
    public static Visualizer$ MODULE$;
    private final SparkSession ss;

    static {
        new Visualizer$();
    }

    public SparkSession ss() {
        return this.ss;
    }

    public String generateVisualizerTemplate(Dataset<Row> left, Dataset<Row> right, Seq<String> compositeKeyStrs, Integer maxRecords) {
        String visualizerTemplate = "really?";
        Integer maxRecordsCopy = Predef$.MODULE$.int2Integer(1000);
        try {
            Predef$.MODULE$.require(left != null, (Function0 & Serializable & scala.Serializable)() -> {
                throw new DataFrameNullException("Left dataframe is null", DataFrameNullException$.MODULE$.$lessinit$greater$default$2());
            });
            Predef$.MODULE$.require(right != null, (Function0 & Serializable & scala.Serializable)() -> {
                throw new DataFrameNullException("Right dataframe is null", DataFrameNullException$.MODULE$.$lessinit$greater$default$2());
            });
            Predef$.MODULE$.require(compositeKeyStrs != null && !compositeKeyStrs.isEmpty(), (Function0 & Serializable & scala.Serializable)() -> {
                throw new JoinKeysNullException("Please specify primary/composite key", JoinKeysNullException$.MODULE$.$lessinit$greater$default$2());
            });
            Predef$.MODULE$.require(this.isValidKey(compositeKeyStrs), (Function0 & Serializable & scala.Serializable)() -> {
                throw new InValidKeyException("One or more keys is empty or null", InValidKeyException$.MODULE$.$lessinit$greater$default$2());
            });
            if (Predef$.MODULE$.Integer2int(maxRecords) > 0) {
                maxRecordsCopy = maxRecords;
            }
            if (left.count() == 0L && right.count() == 0L) {
                visualizerTemplate = "No mismatches are found";
            } else {
                String string;
                Tuple3<Seq<String>, Seq<Seq<String>>, VisualResultType> headersRows = this.generateHeadersRows(left, right, compositeKeyStrs, maxRecordsCopy);
                Seq headers = (Seq)headersRows._1();
                Seq rows = (Seq)headersRows._2();
                VisualResultType visualResultType = (VisualResultType)((Object)headersRows._3());
                StringBuilder stringBuilder = new StringBuilder(1375).append("\n          <!DOCTYPE html>\n            <head>\n              <meta charset=\"utf-8\">\n              <style>\n                body {\n                  font: 15px Lato, sans-serif;\n                  font-weight: lighter;\n                  transform: scale(1) !important;\n                }\n\n                table, tr, th, td {\n                  margin: 0 auto;\n                  max-width: 95%;\n                  border:1px solid black;\n                  padding: 5px;\n                  text-align: center;\n                }\n\n                th, td {\n                  min-width: 60px;\n                }\n\n                table {\n                  margin-top: 30px;\n                  border-collapse: collapse;\n                }\n\n                th {\n                  background: #65BDF0;\n                }\n\n                tr:nth-child(even) {\n                  background: #D0E4F5;\n                }\n\n                tr:nth-child(odd) {\n                  background: #F2F3F3;\n                }\n\n                .spanBlue {\n                  color: blue;\n                }\n\n                .spanRed {\n                  color: red;\n                }\n              </style>\n            </head>\n            <body>\n              <table>\n                <tr>\n                  ").append(((TraversableOnce)headers.map((Function1 & Serializable & scala.Serializable)header -> new StringBuilder(9).append("<th>").append((String)header).append("</th>").toString(), Seq$.MODULE$.canBuildFrom())).mkString()).append("\n                </tr>\n                ");
                VisualResultType visualResultType2 = visualResultType;
                VisualResultType visualResultType3 = VisualResultType.LEFT;
                if (!(visualResultType2 != null ? !((Object)((Object)visualResultType2)).equals((Object)visualResultType3) : visualResultType3 != null)) {
                    string = ((TraversableOnce)rows.map((Function1 & Serializable & scala.Serializable)row -> new StringBuilder(9).append("<tr>").append(((TraversableOnce)row.map((Function1 & Serializable & scala.Serializable)cell -> new StringBuilder(39).append("<td>").append("<span class='spanBlue'>").append((String)cell).append("</span>").append("</td>").toString(), Seq$.MODULE$.canBuildFrom())).mkString()).append("</tr>").toString(), Seq$.MODULE$.canBuildFrom())).mkString();
                } else {
                    VisualResultType visualResultType4 = visualResultType;
                    VisualResultType visualResultType5 = VisualResultType.RIGHT;
                    string = !(visualResultType4 != null ? !((Object)((Object)visualResultType4)).equals((Object)visualResultType5) : visualResultType5 != null) ? ((TraversableOnce)rows.map((Function1 & Serializable & scala.Serializable)row -> new StringBuilder(9).append("<tr>").append(((TraversableOnce)row.map((Function1 & Serializable & scala.Serializable)cell -> new StringBuilder(38).append("<td>").append("<span class='spanRed'>").append((String)cell).append("</span>").append("</td>").toString(), Seq$.MODULE$.canBuildFrom())).mkString()).append("</tr>").toString(), Seq$.MODULE$.canBuildFrom())).mkString() : ((TraversableOnce)rows.map((Function1 & Serializable & scala.Serializable)row -> new StringBuilder(9).append("<tr>").append(((TraversableOnce)row.map((Function1 & Serializable & scala.Serializable)cell -> {
                        if (cell.contains("<==>")) {
                            String[] leftRightVals = cell.split("<==>");
                            return new StringBuilder(73).append("<td>").append("<span class='spanBlue'>").append((Object)(cell.startsWith("<==>") ? "(empty)" : leftRightVals[0])).append("</span></br>").append("<span class='spanRed'>").append((Object)(cell.endsWith("<==>") ? "(empty)" : leftRightVals[1])).append("</span>").append("</td>").toString();
                        }
                        return new StringBuilder(9).append("<td>").append((String)cell).append("</td>").toString();
                    }, Seq$.MODULE$.canBuildFrom())).mkString()).append("</tr>").toString(), Seq$.MODULE$.canBuildFrom())).mkString();
                }
                visualizerTemplate = stringBuilder.append((Object)string).append("\n              </table>\n            </body>\n          </html>\n        ").toString();
            }
        }
        catch (DataFrameNullException ex) {
            visualizerTemplate = new StringBuilder(15).append("Error message: ").append(ex.getMessage()).toString();
        }
        catch (JoinKeysNullException ex) {
            visualizerTemplate = new StringBuilder(15).append("Error message: ").append(ex.getMessage()).toString();
        }
        catch (SparkSessionNullException ex) {
            visualizerTemplate = new StringBuilder(15).append("Error message: ").append(ex.getMessage()).toString();
        }
        catch (ColumnNullException ex) {
            visualizerTemplate = new StringBuilder(15).append("Error message: ").append(ex.getMessage()).toString();
        }
        catch (InValidKeyException ex) {
            visualizerTemplate = new StringBuilder(15).append("Error message: ").append(ex.getMessage()).toString();
        }
        if (visualizerTemplate.startsWith("Error message") || visualizerTemplate.startsWith("No mismatches")) {
            return new StringBuilder(9).append("<h3>").append(visualizerTemplate).append("</h3>").toString();
        }
        return visualizerTemplate;
    }

    public Integer generateVisualizerTemplate$default$4() {
        return Predef$.MODULE$.int2Integer(1000);
    }

    public Tuple3<Seq<String>, Seq<Seq<String>>, VisualResultType> generateHeadersRows(Dataset<Row> left, Dataset<Row> right, Seq<String> compositeKeyStrs, Integer maxRecords) {
        Dataset upperCaseLeft = left.toDF((Seq)Predef$.MODULE$.wrapRefArray((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])left.columns())).map((Function1 & Serializable & scala.Serializable)x$1 -> x$1.toUpperCase(), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class)))));
        Dataset upperCaseRight = right.toDF((Seq)Predef$.MODULE$.wrapRefArray((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])right.columns())).map((Function1 & Serializable & scala.Serializable)x$2 -> x$2.toUpperCase(), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class)))));
        VisualResultType visualResultType = null;
        Dataset tempDf = upperCaseLeft;
        if (upperCaseLeft.count() == 0L) {
            visualResultType = VisualResultType.RIGHT;
            tempDf = upperCaseRight;
        } else if (upperCaseRight.count() == 0L) {
            visualResultType = VisualResultType.LEFT;
            tempDf = upperCaseLeft;
        } else {
            visualResultType = VisualResultType.BOTH;
        }
        Seq caseTransformedKeys = (Seq)compositeKeyStrs.map((Function1 & Serializable & scala.Serializable)k -> k.toUpperCase(), Seq$.MODULE$.canBuildFrom());
        List compositeKeysCol = ((TraversableOnce)caseTransformedKeys.map((Function1 & Serializable & scala.Serializable)c -> functions$.MODULE$.col(c), Seq$.MODULE$.canBuildFrom())).toList();
        List nonKeyCols = new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])tempDf.columns())).filter((Function1 & Serializable & scala.Serializable)c -> BoxesRunTime.boxToBoolean((boolean)Visualizer$.$anonfun$generateHeadersRows$5(caseTransformedKeys, c))))).toList();
        Dataset joinedDf = null;
        Row[] data = null;
        VisualResultType visualResultType2 = visualResultType;
        VisualResultType visualResultType3 = VisualResultType.BOTH;
        if (!(visualResultType2 != null ? !((Object)((Object)visualResultType2)).equals((Object)visualResultType3) : visualResultType3 != null)) {
            try {
                List list = compositeKeysCol;
                joinedDf = upperCaseLeft.as("l").join(upperCaseRight.as("r"), caseTransformedKeys, "full_outer").select((Seq)((List)nonKeyCols.map((Function1 & Serializable & scala.Serializable)columnName -> MODULE$.mapHelper((String)columnName), List$.MODULE$.canBuildFrom())).$colon$colon$colon(list));
            }
            catch (SparkSessionNullException ex) {
                throw new SparkSessionNullException(ex.getMessage(), SparkSessionNullException$.MODULE$.$lessinit$greater$default$2());
            }
            catch (Exception ex) {
                throw new ColumnNullException(ex.getMessage(), ColumnNullException$.MODULE$.$lessinit$greater$default$2());
            }
        }
        if (joinedDf == null) {
            joinedDf = tempDf;
        }
        data = (Row[])joinedDf.take(Predef$.MODULE$.Integer2int(maxRecords));
        Seq headers = (Seq)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])joinedDf.schema().fieldNames())).toSeq().map((Function1 & Serializable & scala.Serializable)header -> header.toUpperCase(), Seq$.MODULE$.canBuildFrom());
        Seq rows = (Seq)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])data)).map((Function1 & Serializable & scala.Serializable)row -> (Seq)row.toSeq().map((Function1 & Serializable & scala.Serializable)cell -> {
            Object object = cell;
            if (object == null) {
                return "[null]";
            }
            return cell.toString();
        }, Seq$.MODULE$.canBuildFrom()), Array$.MODULE$.fallbackCanBuildFrom(Predef.DummyImplicit$.MODULE$.dummyImplicit()));
        return new Tuple3((Object)headers, (Object)rows, (Object)visualResultType);
    }

    public Column mapHelper(String columnName) {
        SparkSession x = SparkFactory$.MODULE$.sparkSession();
        Predef$.MODULE$.require(x != null, (Function0 & Serializable & scala.Serializable)() -> {
            throw new SparkSessionNullException("Spark Session is null", SparkSessionNullException$.MODULE$.$lessinit$greater$default$2());
        });
        return functions$.MODULE$.when(x.implicits().StringToColumn(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"l.", ""}))).$((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{columnName})).isNull().$amp$amp((Object)x.implicits().StringToColumn(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"r.", ""}))).$((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{columnName})).isNull()), (Object)functions$.MODULE$.lit((Object)"[null]")).when(x.implicits().StringToColumn(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"l.", ""}))).$((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{columnName})).isNull(), (Object)functions$.MODULE$.concat((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Column[]{functions$.MODULE$.lit((Object)"[null]<==>"), x.implicits().StringToColumn(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"r.", ""}))).$((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{columnName}))}))).when(x.implicits().StringToColumn(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"r.", ""}))).$((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{columnName})).isNull(), (Object)functions$.MODULE$.concat((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Column[]{x.implicits().StringToColumn(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"l.", ""}))).$((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{columnName})), functions$.MODULE$.lit((Object)"<==>[null]")}))).when(x.implicits().StringToColumn(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"l.", ""}))).$((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{columnName})).$eq$eq$eq((Object)x.implicits().StringToColumn(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"r.", ""}))).$((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{columnName}))), (Object)functions$.MODULE$.concat((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Column[]{functions$.MODULE$.lit((Object)""), x.implicits().StringToColumn(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"l.", ""}))).$((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{columnName}))}))).otherwise((Object)functions$.MODULE$.concat((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Column[]{x.implicits().StringToColumn(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"l.", ""}))).$((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{columnName})), functions$.MODULE$.lit((Object)"<==>"), x.implicits().StringToColumn(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"r.", ""}))).$((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{columnName}))}))).as(columnName);
    }

    public boolean isValidKey(Seq<String> composite_key_strs) {
        BooleanRef flag = BooleanRef.create((boolean)true);
        composite_key_strs.foreach((Function1 & Serializable & scala.Serializable)key -> {
            Visualizer$.$anonfun$isValidKey$1(flag, key);
            return BoxedUnit.UNIT;
        });
        return flag.elem;
    }

    public String renderHorizontalTable(Dataset<Row> df, int limit) {
        Seq rows = new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])df.take(limit))).toSeq();
        Seq header = new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])df.schema().fieldNames())).toSeq();
        String htmlTableWithNoHeader = ((TraversableOnce)rows.map((Function1 & Serializable & scala.Serializable)row -> new StringBuilder(9).append("<tr>").append(MODULE$.convertRowToHtml((Row)row, (Seq<String>)header)).append("</tr>").append(System.lineSeparator()).toString(), Seq$.MODULE$.canBuildFrom())).mkString();
        String headerHtml = new StringBuilder(9).append("<tr>").append(((TraversableOnce)header.map((Function1 & Serializable & scala.Serializable)h -> new StringBuilder(9).append("<th>").append((String)h).append("</th>").toString(), Seq$.MODULE$.canBuildFrom())).mkString()).append("</tr>").append(System.lineSeparator()).toString();
        String htmlTable = new StringBuilder(15).append("<table>").append(headerHtml).append(htmlTableWithNoHeader).append("</table>").toString();
        String html = TemplateController$.MODULE$.horizontalTableTemplate().replace("#tableContent", htmlTable);
        return html;
    }

    private String convertRowToHtml(Row row, Seq<String> header) {
        Map valuesMap = row.getValuesMap(header);
        return ((TraversableOnce)header.map((Function1 & Serializable & scala.Serializable)h -> MODULE$.getValueFromRowAsCell((Map<String, Nothing$>)valuesMap, (String)h), Seq$.MODULE$.canBuildFrom())).mkString();
    }

    private String getValueFromRowAsCell(Map<String, Nothing$> valuesMap, String columnName) {
        Option otherColumnValue;
        Option valueOther;
        Option otherColumnName;
        String value;
        Option valueOption = valuesMap.get((Object)columnName);
        String string = value = valueOption.get() == null ? "null" : valueOption.get().toString();
        Option option = columnName.startsWith("l_") ? Option$.MODULE$.apply((Object)columnName.replace("l_", "r_")) : (otherColumnName = columnName.startsWith("r_") ? Option$.MODULE$.apply((Object)columnName.replace("r_", "l_")) : Option$.MODULE$.empty());
        Option option2 = otherColumnName.isEmpty() ? Option$.MODULE$.empty() : (valueOther = (otherColumnValue = valuesMap.get(otherColumnName.get())).get() == null ? Option$.MODULE$.apply((Object)"null") : Option$.MODULE$.apply((Object)otherColumnValue.get().toString()));
        String htmlDiffClass = valueOther.isEmpty() ? "same" : (value.equals(valueOther.get()) ? "same" : "different");
        return new StringBuilder(18).append("<td class='").append(htmlDiffClass).append("'>").append(value).append("</td>").toString();
    }

    public static final /* synthetic */ boolean $anonfun$generateHeadersRows$5(Seq caseTransformedKeys$1, String c) {
        return !caseTransformedKeys$1.contains((Object)c);
    }

    public static final /* synthetic */ void $anonfun$isValidKey$1(BooleanRef flag$1, String key) {
        if (key == null || key.isEmpty()) {
            flag$1.elem = false;
            return;
        }
    }

    private Visualizer$() {
        MODULE$ = this;
        this.ss = SparkFactory$.MODULE$.sparkSession();
    }
}

