/*
 * Decompiled with CFR 0.152.
 */
package org.firebirdsql.jdbc.escape;

import org.firebirdsql.jdbc.escape.FBSQLParseException;
import org.firebirdsql.jdbc.escape.IntervalMapping;
import org.firebirdsql.jdbc.escape.SQLFunction;

final class TimestampAddFunction
implements SQLFunction {
    TimestampAddFunction() {
    }

    @Override
    public String apply(String ... parameters) throws FBSQLParseException {
        if (parameters.length != 3) {
            throw new FBSQLParseException("Expected 3 parameters for TIMESTAMPADD, received " + parameters.length);
        }
        String jdbcIntervalName = parameters[0].trim().toUpperCase();
        if ("SQL_TSI_QUARTER".equals(jdbcIntervalName)) {
            return "DATEADD(MONTH,3*(" + parameters[1] + ")," + parameters[2] + ")";
        }
        if ("SQL_TSI_FRAC_SECOND".equals(jdbcIntervalName)) {
            return "DATEADD(MILLISECOND,1.0e-6*(" + parameters[1] + ")," + parameters[2] + ")";
        }
        String fbIntervalName = IntervalMapping.getFirebirdInterval(jdbcIntervalName);
        return "DATEADD(" + fbIntervalName + "," + parameters[1] + "," + parameters[2] + ")";
    }
}

