/*
 * Decompiled with CFR 0.152.
 */
package org.firebirdsql.jdbc.metadata;

import java.util.Collections;
import java.util.EnumSet;
import java.util.Set;
import org.firebirdsql.jdbc.field.JdbcTypeConverter;
import org.firebirdsql.util.FirebirdSupportInfo;

public class TypeMetadata {
    private final int type;
    private final int subType;
    private final Integer precision;
    private final Integer scale;
    private final Integer jdbcType;
    private final Integer fieldLength;
    private final Integer characterLength;
    private final Set<TypeBehaviour> typeBehaviours;

    private TypeMetadata(int type, Integer subType, Integer precision, Integer scale, Integer characterSetId, Integer fieldLength, Integer characterLength, Set<TypeBehaviour> typeBehaviours) {
        this.type = type;
        this.subType = TypeMetadata.coalesce(subType, 0);
        this.precision = precision;
        this.scale = scale;
        this.jdbcType = TypeMetadata.getDataType(type, this.subType, TypeMetadata.coalesce(scale, 0), TypeMetadata.coalesce(characterSetId, 0));
        this.fieldLength = fieldLength;
        this.characterLength = TypeMetadata.isDefault(characterLength) && !TypeMetadata.isDefault(fieldLength) && TypeMetadata.isCharacterType(type) ? fieldLength : characterLength;
        this.typeBehaviours = typeBehaviours.isEmpty() ? Collections.emptySet() : Collections.unmodifiableSet(EnumSet.copyOf(typeBehaviours));
    }

    public int getJdbcType() {
        return this.jdbcType;
    }

    public String getSqlTypeName() {
        return TypeMetadata.getDataTypeName(this.type, this.subType, TypeMetadata.coalesce(this.scale, 0));
    }

    public Integer getColumnSize() {
        switch (this.jdbcType) {
            case 6: {
                return this.isFloatBinaryPrecision() ? 24 : 7;
            }
            case 8: {
                return this.isFloatBinaryPrecision() ? 53 : 15;
            }
            case -3: 
            case -2: 
            case 1: 
            case 12: {
                return this.characterLength;
            }
            case -5: {
                return 19;
            }
            case 4: {
                return 10;
            }
            case 5: {
                return 5;
            }
            case 16: {
                return 1;
            }
            case 2: 
            case 3: {
                switch (this.type) {
                    case 11: 
                    case 16: 
                    case 27: {
                        return TypeMetadata.coalesce(this.precision, 18);
                    }
                    case 8: {
                        return TypeMetadata.coalesce(this.precision, 9);
                    }
                    case 7: {
                        return TypeMetadata.coalesce(this.precision, 4);
                    }
                    case 26: {
                        return TypeMetadata.coalesce(this.precision, 38);
                    }
                }
                throw new IllegalStateException(String.format("Incorrect derivation of NUMERIC/DECIMAL precision for jdbcType %d, type %d, subType %d, scale %d", this.jdbcType, this.type, this.subType, this.scale));
            }
            case 91: {
                return 10;
            }
            case 92: {
                return 13;
            }
            case 93: {
                return 24;
            }
            case 2013: {
                return 19;
            }
            case 2014: {
                return 30;
            }
            case -6001: {
                switch (this.type) {
                    case 24: {
                        return 16;
                    }
                    case 25: {
                        return 34;
                    }
                }
                throw new IllegalStateException(String.format("Incorrect derivation of DECFLOAT precision for jdbcType %d, type %d, subType %d, scale %d", this.jdbcType, this.type, this.subType, this.scale));
            }
        }
        return TypeMetadata.coalesce(this.precision, 0) != 0 ? this.precision : null;
    }

    public Integer getLength() {
        return this.fieldLength;
    }

    public Integer getScale() {
        switch (this.jdbcType) {
            case -5: 
            case 4: 
            case 5: {
                return 0;
            }
            case 2: 
            case 3: {
                return -1 * TypeMetadata.coalesce(this.scale, 0);
            }
        }
        return TypeMetadata.coalesce(this.scale, 0) != 0 ? this.scale : null;
    }

    public int getRadix() {
        switch (this.jdbcType) {
            case 6: 
            case 8: {
                return this.isFloatBinaryPrecision() ? 2 : 10;
            }
            case 16: {
                return 2;
            }
        }
        return 10;
    }

    public Integer getCharOctetLength() {
        if (TypeMetadata.isCharacterType(this.type)) {
            return this.getLength();
        }
        return null;
    }

    public static Builder builder(FirebirdSupportInfo supportInfo) {
        return new Builder(supportInfo);
    }

    public static int getDataType(int sqlType, int sqlSubType, int sqlScale, int characterSetId) {
        if (sqlType == 261 && sqlSubType > 1) {
            return 1111;
        }
        int jdbcType = JdbcTypeConverter.fromMetaDataToJdbcType(sqlType, sqlSubType, sqlScale);
        if (characterSetId == 1) {
            if (jdbcType == 1) {
                return -2;
            }
            if (jdbcType == 12) {
                return -3;
            }
        }
        return jdbcType;
    }

    public static String getDataTypeName(int sqlType, int sqlSubType, int sqlScale) {
        switch (sqlType) {
            case 7: 
            case 8: 
            case 11: 
            case 16: 
            case 26: 
            case 27: {
                if (sqlSubType == 1 || sqlSubType == 0 && sqlScale < 0) {
                    return "NUMERIC";
                }
                if (sqlSubType == 2) {
                    return "DECIMAL";
                }
                switch (sqlType) {
                    case 7: {
                        return "SMALLINT";
                    }
                    case 8: {
                        return "INTEGER";
                    }
                    case 16: {
                        return "BIGINT";
                    }
                    case 11: 
                    case 27: {
                        return "DOUBLE PRECISION";
                    }
                    case 26: {
                        return "INT128";
                    }
                }
                throw new IllegalStateException(String.format("Incorrect derivation of type name in getDataTypeName(%d, %d, %d)", sqlType, sqlSubType, sqlScale));
            }
            case 10: {
                return "FLOAT";
            }
            case 14: {
                return "CHAR";
            }
            case 37: 
            case 40: {
                return "VARCHAR";
            }
            case 35: {
                return "TIMESTAMP";
            }
            case 13: {
                return "TIME";
            }
            case 12: {
                return "DATE";
            }
            case 28: 
            case 30: {
                return "TIME WITH TIME ZONE";
            }
            case 29: 
            case 31: {
                return "TIMESTAMP WITH TIME ZONE";
            }
            case 261: {
                if (sqlSubType == 0) {
                    return "BLOB SUB_TYPE BINARY";
                }
                if (sqlSubType == 1) {
                    return "BLOB SUB_TYPE TEXT";
                }
                return "BLOB SUB_TYPE " + sqlSubType;
            }
            case 9: {
                return "ARRAY";
            }
            case 23: {
                return "BOOLEAN";
            }
            case 24: 
            case 25: {
                return "DECFLOAT";
            }
        }
        return "NULL";
    }

    private boolean isFloatBinaryPrecision() {
        return this.typeBehaviours.contains((Object)TypeBehaviour.FLOAT_BINARY_PRECISION);
    }

    private static int coalesce(Integer value, int replacement) {
        return value != null ? value : replacement;
    }

    private static boolean isDefault(Integer value) {
        return value == null;
    }

    private static boolean isCharacterType(int sqlType) {
        return sqlType == 14 || sqlType == 37 || sqlType == 40;
    }

    public static class Builder {
        private int type;
        private Integer subType;
        private Integer precision;
        private Integer scale;
        private Integer characterSetId;
        private Integer fieldLength;
        private Integer characterLength;
        private final Set<TypeBehaviour> typeBehaviours = EnumSet.noneOf(TypeBehaviour.class);

        public Builder(FirebirdSupportInfo supportInfo) {
            this.typeBehaviours.add(supportInfo.supportsFloatBinaryPrecision() ? TypeBehaviour.FLOAT_BINARY_PRECISION : TypeBehaviour.FLOAT_DECIMAL_PRECISION);
        }

        public TypeMetadata build() {
            if (this.type == 0) {
                throw new IllegalStateException("type must be set");
            }
            return new TypeMetadata(this.type, this.subType, this.precision, this.scale, this.characterSetId, this.fieldLength, this.characterLength, this.typeBehaviours);
        }

        public Builder withType(int type) {
            this.type = type;
            return this;
        }

        public Builder withSubType(Integer subType) {
            this.subType = subType;
            return this;
        }

        public Builder withPrecision(Integer precision) {
            this.precision = precision;
            return this;
        }

        public Builder withScale(Integer scale) {
            this.scale = scale;
            return this;
        }

        public Builder withCharacterSetId(Integer characterSetId) {
            this.characterSetId = characterSetId;
            return this;
        }

        public Builder withFieldLength(Integer fieldLength) {
            this.fieldLength = fieldLength;
            return this;
        }

        public Builder withCharacterLength(Integer characterLength) {
            this.characterLength = characterLength;
            return this;
        }
    }

    public static enum TypeBehaviour {
        FLOAT_DECIMAL_PRECISION,
        FLOAT_BINARY_PRECISION;

    }
}

