/*
 * Firebird Open Source JDBC Driver
 *
 * Distributable under LGPL license.
 * You may obtain a copy of the License at http://www.gnu.org/copyleft/lgpl.html
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * LGPL License for more details.
 *
 * This file was created by members of the firebird development team.
 * All individual contributions remain the Copyright (C) of those
 * individuals.  Contributors to this file are either listed here or
 * can be obtained from a source control history command.
 *
 * All rights reserved.
 */
package org.firebirdsql.jna.fbclient;

import com.sun.jna.Structure;

/**
 * JNA wrapper for ISC_ARRAY_DESC.
 * <p>
 * This file was initially autogenerated by <a href="http://jnaerator.googlecode.com/">JNAerator</a>, a tool written by <a href="http://ochafik.com/">Olivier Chafik</a> that <a href="http://code.google.com/p/jnaerator/wiki/CreditsAndLicense">uses a few opensource projects.</a>.
 * </p>
 * <p>
 * This file was modified manually, <strong>do not automatically regenerate!</strong>
 * </p>
 * @since 3.0
 */
@Structure.FieldOrder({ "array_desc_dtype", "array_desc_scale", "array_desc_length", "array_desc_field_name",
		"array_desc_relation_name", "array_desc_dimensions", "array_desc_flags", "array_desc_bounds" })
public class ISC_ARRAY_DESC extends Structure {
	/// C type : ISC_UCHAR
	public byte array_desc_dtype;
	/// C type : ISC_SCHAR
	public byte array_desc_scale;
	public short array_desc_length;
	/// C type : ISC_SCHAR[32]
	public byte[] array_desc_field_name = new byte[32];
	/// C type : ISC_SCHAR[32]
	public byte[] array_desc_relation_name = new byte[32];
	public short array_desc_dimensions;
	public short array_desc_flags;
	/// C type : ISC_ARRAY_BOUND[16]
	public ISC_ARRAY_BOUND[] array_desc_bounds = new ISC_ARRAY_BOUND[16];
	public ISC_ARRAY_DESC() {
		super();
	}

	/**
	 * @param array_desc_dtype C type : ISC_UCHAR<br>
	 * @param array_desc_scale C type : ISC_SCHAR<br>
	 * @param array_desc_field_name C type : ISC_SCHAR[32]<br>
	 * @param array_desc_relation_name C type : ISC_SCHAR[32]<br>
	 * @param array_desc_bounds C type : ISC_ARRAY_BOUND[16]
	 */
	public ISC_ARRAY_DESC(byte array_desc_dtype, byte array_desc_scale, short array_desc_length, byte array_desc_field_name[], byte array_desc_relation_name[], short array_desc_dimensions, short array_desc_flags, ISC_ARRAY_BOUND array_desc_bounds[]) {
		super();
		this.array_desc_dtype = array_desc_dtype;
		this.array_desc_scale = array_desc_scale;
		this.array_desc_length = array_desc_length;
		if (array_desc_field_name.length != this.array_desc_field_name.length) 
			throw new IllegalArgumentException("Wrong array size !");
		this.array_desc_field_name = array_desc_field_name;
		if (array_desc_relation_name.length != this.array_desc_relation_name.length) 
			throw new IllegalArgumentException("Wrong array size !");
		this.array_desc_relation_name = array_desc_relation_name;
		this.array_desc_dimensions = array_desc_dimensions;
		this.array_desc_flags = array_desc_flags;
		if (array_desc_bounds.length != this.array_desc_bounds.length) 
			throw new IllegalArgumentException("Wrong array size !");
		this.array_desc_bounds = array_desc_bounds;
	}
	public static class ByReference extends ISC_ARRAY_DESC implements Structure.ByReference {
	}
	public static class ByValue extends ISC_ARRAY_DESC implements Structure.ByValue {
	}
}
