/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.cmmn.engine.impl.agenda.operation;

import org.flowable.cmmn.engine.CmmnEngineConfiguration;
import org.flowable.cmmn.engine.impl.agenda.operation.AbstractChangePlanItemInstanceStateOperation;
import org.flowable.cmmn.engine.impl.persistence.entity.PlanItemInstanceEntity;
import org.flowable.cmmn.engine.impl.util.CmmnLoggingSessionUtil;
import org.flowable.cmmn.engine.impl.util.CommandContextUtil;
import org.flowable.cmmn.model.PlanItem;
import org.flowable.cmmn.model.Task;
import org.flowable.common.engine.impl.interceptor.CommandContext;
import org.flowable.job.service.JobService;
import org.flowable.job.service.impl.persistence.entity.JobEntity;

public class ActivateAsyncPlanItemInstanceOperation
extends AbstractChangePlanItemInstanceStateOperation {
    protected String entryCriterionId;

    public ActivateAsyncPlanItemInstanceOperation(CommandContext commandContext, PlanItemInstanceEntity planItemInstanceEntity, String entryCriterionId) {
        super(commandContext, planItemInstanceEntity);
        this.entryCriterionId = entryCriterionId;
    }

    @Override
    protected String getLifeCycleTransition() {
        return "async-activate";
    }

    @Override
    protected String getNewState() {
        return "async-active";
    }

    @Override
    protected void internalExecute() {
        this.planItemInstanceEntity.setLastStartedTime(this.getCurrentTime(this.commandContext));
        CommandContextUtil.getCmmnHistoryManager(this.commandContext).recordPlanItemInstanceStarted(this.planItemInstanceEntity);
        this.createAsyncJob((Task)this.planItemInstanceEntity.getPlanItem().getPlanItemDefinition());
    }

    protected void createAsyncJob(Task task) {
        CmmnEngineConfiguration cmmnEngineConfiguration = CommandContextUtil.getCmmnEngineConfiguration(this.commandContext);
        JobService jobService = CommandContextUtil.getCmmnEngineConfiguration(this.commandContext).getJobServiceConfiguration().getJobService();
        JobEntity job = jobService.createJob();
        job.setJobHandlerType("cmmn-async-activate-plan-item-instance");
        job.setScopeId(this.planItemInstanceEntity.getCaseInstanceId());
        job.setSubScopeId(this.planItemInstanceEntity.getId());
        job.setScopeDefinitionId(this.planItemInstanceEntity.getCaseDefinitionId());
        job.setScopeType("cmmn");
        job.setElementId(task.getId());
        job.setElementName(task.getName());
        job.setJobHandlerConfiguration(this.entryCriterionId);
        job.setTenantId(this.planItemInstanceEntity.getTenantId());
        jobService.createAsyncJob(job, task.isExclusive());
        jobService.scheduleAsyncJob(job);
        if (cmmnEngineConfiguration.isLoggingSessionEnabled()) {
            CmmnLoggingSessionUtil.addAsyncActivityLoggingData("Created async job for " + this.planItemInstanceEntity.getPlanItemDefinitionId() + ", with job id " + job.getId(), "serviceTaskAsyncJob", job, this.planItemInstanceEntity.getPlanItemDefinition(), this.planItemInstanceEntity);
        }
    }

    @Override
    public String toString() {
        PlanItem planItem = this.planItemInstanceEntity.getPlanItem();
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("[Async activate PlanItem] ");
        stringBuilder.append(planItem);
        if (this.entryCriterionId != null) {
            stringBuilder.append(" via entry criterion ").append(this.entryCriterionId);
        }
        return stringBuilder.toString();
    }

    @Override
    protected String getOperationName() {
        return "[Async activate plan item]";
    }
}

