/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.cmmn.engine.impl.behavior.impl;

import java.util.Collection;
import java.util.Objects;
import org.apache.commons.lang3.StringUtils;
import org.flowable.cmmn.engine.impl.behavior.impl.TaskActivityBehavior;
import org.flowable.cmmn.engine.impl.persistence.entity.PlanItemInstanceEntity;
import org.flowable.cmmn.engine.impl.util.CommandContextUtil;
import org.flowable.cmmn.engine.impl.util.EventInstanceCmmnUtil;
import org.flowable.cmmn.model.BaseElement;
import org.flowable.cmmn.model.SendEventServiceTask;
import org.flowable.common.engine.api.FlowableException;
import org.flowable.common.engine.impl.interceptor.CommandContext;
import org.flowable.eventregistry.api.EventRegistry;
import org.flowable.eventregistry.api.runtime.EventInstance;
import org.flowable.eventregistry.api.runtime.EventPayloadInstance;
import org.flowable.eventregistry.impl.runtime.EventInstanceImpl;
import org.flowable.eventregistry.model.EventModel;

public class SendEventActivityBehavior
extends TaskActivityBehavior {
    protected SendEventServiceTask serviceTask;

    public SendEventActivityBehavior(SendEventServiceTask serviceTask) {
        super(serviceTask.isBlocking(), serviceTask.getBlockingExpression());
        this.serviceTask = serviceTask;
    }

    @Override
    public void execute(CommandContext commandContext, PlanItemInstanceEntity planItemInstanceEntity) {
        String key = this.getEventKey();
        EventRegistry eventRegistry = CommandContextUtil.getEventRegistry();
        EventModel eventModel = null;
        eventModel = Objects.equals("", planItemInstanceEntity.getTenantId()) ? CommandContextUtil.getEventRepositoryService().getEventModelByKey(key) : CommandContextUtil.getEventRepositoryService().getEventModelByKey(key, planItemInstanceEntity.getTenantId());
        if (eventModel == null) {
            throw new FlowableException("No event model found for event key " + key);
        }
        EventInstanceImpl eventInstance = new EventInstanceImpl();
        eventInstance.setEventModel(eventModel);
        Collection<EventPayloadInstance> eventPayloadInstances = EventInstanceCmmnUtil.createEventPayloadInstances(planItemInstanceEntity, CommandContextUtil.getExpressionManager(commandContext), (BaseElement)this.serviceTask, eventModel);
        eventInstance.setPayloadInstances(eventPayloadInstances);
        eventRegistry.sendEventOutbound((EventInstance)eventInstance);
        CommandContextUtil.getAgenda(commandContext).planCompletePlanItemInstanceOperation(planItemInstanceEntity);
    }

    protected String getEventKey() {
        if (StringUtils.isNotEmpty((CharSequence)this.serviceTask.getEventType())) {
            return this.serviceTask.getEventType();
        }
        throw new FlowableException("No event key configured for " + this.serviceTask.getId());
    }
}

