/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.cmmn.engine.impl.cmd;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import org.apache.commons.lang3.StringUtils;
import org.flowable.cmmn.api.StageResponse;
import org.flowable.cmmn.api.repository.CaseDefinition;
import org.flowable.cmmn.api.runtime.PlanItemDefinitionType;
import org.flowable.cmmn.api.runtime.PlanItemInstance;
import org.flowable.cmmn.api.runtime.PlanItemInstanceQuery;
import org.flowable.cmmn.engine.impl.deployer.CmmnDeploymentManager;
import org.flowable.cmmn.engine.impl.persistence.entity.CaseInstanceEntity;
import org.flowable.cmmn.engine.impl.persistence.entity.PlanItemInstanceEntityManager;
import org.flowable.cmmn.engine.impl.runtime.PlanItemInstanceQueryImpl;
import org.flowable.cmmn.engine.impl.util.CommandContextUtil;
import org.flowable.cmmn.model.CmmnModel;
import org.flowable.cmmn.model.Milestone;
import org.flowable.cmmn.model.PlanItemDefinition;
import org.flowable.cmmn.model.Stage;
import org.flowable.common.engine.api.FlowableException;
import org.flowable.common.engine.api.FlowableObjectNotFoundException;
import org.flowable.common.engine.api.delegate.Expression;
import org.flowable.common.engine.api.variable.VariableContainer;
import org.flowable.common.engine.impl.interceptor.Command;
import org.flowable.common.engine.impl.interceptor.CommandContext;

public class GetStageOverviewCmd
implements Command<List<StageResponse>>,
Serializable {
    private static final long serialVersionUID = 1L;
    protected String caseInstanceId;

    public GetStageOverviewCmd(String caseInstanceId) {
        this.caseInstanceId = caseInstanceId;
    }

    public List<StageResponse> execute(CommandContext commandContext) {
        CaseInstanceEntity caseInstance = (CaseInstanceEntity)CommandContextUtil.getCaseInstanceEntityManager(commandContext).findById(this.caseInstanceId);
        if (caseInstance == null) {
            throw new FlowableObjectNotFoundException("No case instance found for id " + this.caseInstanceId, CaseInstanceEntity.class);
        }
        PlanItemInstanceEntityManager planItemInstanceEntityManager = CommandContextUtil.getPlanItemInstanceEntityManager(commandContext);
        List<PlanItemInstance> planItemInstances = planItemInstanceEntityManager.findByCriteria((PlanItemInstanceQuery)new PlanItemInstanceQueryImpl(commandContext).caseInstanceId(this.caseInstanceId).planItemDefinitionTypes(Arrays.asList(PlanItemDefinitionType.STAGE, PlanItemDefinitionType.MILESTONE)).includeEnded().orderByEndTime().asc());
        planItemInstances.removeIf(planItemInstance -> Objects.equals("wait_repetition", planItemInstance.getState()) || Objects.equals("async-active", planItemInstance.getState()));
        CmmnDeploymentManager deploymentManager = CommandContextUtil.getCmmnEngineConfiguration(commandContext).getDeploymentManager();
        CaseDefinition caseDefinition = deploymentManager.findDeployedCaseDefinitionById(caseInstance.getCaseDefinitionId());
        CmmnModel cmmnModel = deploymentManager.resolveCaseDefinition(caseDefinition).getCmmnModel();
        List stages = cmmnModel.getPrimaryCase().getPlanModel().findPlanItemDefinitionsOfType(Stage.class, true);
        List milestones = cmmnModel.getPrimaryCase().getPlanModel().findPlanItemDefinitionsOfType(Milestone.class, true);
        ArrayList<OverviewElement> overviewElements = new ArrayList<OverviewElement>();
        for (Stage stage : stages) {
            overviewElements.add(new OverviewElement(stage.getId(), stage.getName(), stage.getDisplayOrder(), stage.getIncludeInStageOverview(), (PlanItemDefinition)stage));
        }
        for (Milestone milestone : milestones) {
            overviewElements.add(new OverviewElement(milestone.getId(), milestone.getName(), milestone.getDisplayOrder(), milestone.getIncludeInStageOverview(), (PlanItemDefinition)milestone));
        }
        overviewElements.sort(Comparator.comparing(OverviewElement::getDisplayOrder, Comparator.nullsFirst(Comparator.naturalOrder())).thenComparing(overviewElement -> this.getPlanItemInstanceEndTime(planItemInstances, overviewElement.getPlanItemDefinition()), Comparator.nullsLast(Comparator.naturalOrder())));
        ArrayList<StageResponse> stageResponses = new ArrayList<StageResponse>(stages.size());
        for (OverviewElement overviewElement2 : overviewElements) {
            Optional<PlanItemInstance> planItemInstance2;
            boolean includeInStageOverview = false;
            if ("true".equalsIgnoreCase(overviewElement2.getIncludeInStageOverview())) {
                includeInStageOverview = true;
            } else if (StringUtils.isNotEmpty((CharSequence)overviewElement2.getIncludeInStageOverview()) && !"false".equalsIgnoreCase(overviewElement2.getIncludeInStageOverview())) {
                Expression stageExpression = CommandContextUtil.getExpressionManager(commandContext).createExpression(overviewElement2.getIncludeInStageOverview());
                planItemInstance2 = this.getPlanItemInstance(planItemInstances, overviewElement2.getPlanItemDefinition());
                includeInStageOverview = planItemInstance2.isPresent() ? this.evaluateIncludeInStageOverviewExpression(stageExpression, overviewElement2.getIncludeInStageOverview(), (VariableContainer)planItemInstance2.get()) : this.evaluateIncludeInStageOverviewExpression(stageExpression, overviewElement2.getIncludeInStageOverview(), (VariableContainer)caseInstance);
            }
            if (!includeInStageOverview) continue;
            StageResponse stageResponse = new StageResponse(overviewElement2.getId(), overviewElement2.getName());
            planItemInstance2 = this.getPlanItemInstance(planItemInstances, overviewElement2.getPlanItemDefinition());
            if (planItemInstance2.isPresent()) {
                stageResponse.setEndTime(planItemInstance2.get().getEndedTime());
                stageResponse.setEnded(stageResponse.getEndTime() != null);
                stageResponse.setCurrent("active".equals(planItemInstance2.get().getState()));
            }
            stageResponses.add(stageResponse);
        }
        return stageResponses;
    }

    protected boolean evaluateIncludeInStageOverviewExpression(Expression stageExpression, String includeInStageOverview, VariableContainer variableContainer) {
        Object stageValueObject = stageExpression.getValue(variableContainer);
        if (!(stageValueObject instanceof Boolean)) {
            throw new FlowableException("Include in stage overview expression does not resolve to a boolean value " + includeInStageOverview + ": " + stageValueObject);
        }
        return (Boolean)stageValueObject;
    }

    protected Date getPlanItemInstanceEndTime(List<PlanItemInstance> planItemInstances, PlanItemDefinition planItemDefinition) {
        return this.getPlanItemInstance(planItemInstances, planItemDefinition).map(PlanItemInstance::getEndedTime).orElse(null);
    }

    protected Optional<PlanItemInstance> getPlanItemInstance(List<PlanItemInstance> planItemInstances, PlanItemDefinition planItemDefinition) {
        PlanItemInstance planItemInstance = null;
        for (PlanItemInstance p : planItemInstances) {
            if (!p.getPlanItemDefinitionId().equals(planItemDefinition.getId())) continue;
            if (p.getEndedTime() == null) {
                planItemInstance = p;
                continue;
            }
            if (planItemInstance != null) continue;
            planItemInstance = p;
        }
        return Optional.ofNullable(planItemInstance);
    }

    protected class OverviewElement {
        protected String id;
        protected String name;
        protected Integer displayOrder;
        protected String includeInStageOverview;
        protected PlanItemDefinition planItemDefinition;

        public OverviewElement(String id, String name, Integer displayOrder, String includeInStageOverview, PlanItemDefinition planItemDefinition) {
            this.id = id;
            this.name = name;
            this.displayOrder = displayOrder;
            this.includeInStageOverview = includeInStageOverview;
            this.planItemDefinition = planItemDefinition;
        }

        public String getId() {
            return this.id;
        }

        public void setId(String id) {
            this.id = id;
        }

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }

        public Integer getDisplayOrder() {
            return this.displayOrder;
        }

        public void setDisplayOrder(Integer displayOrder) {
            this.displayOrder = displayOrder;
        }

        public String getIncludeInStageOverview() {
            return this.includeInStageOverview;
        }

        public void setIncludeInStageOverview(String includeInStageOverview) {
            this.includeInStageOverview = includeInStageOverview;
        }

        public PlanItemDefinition getPlanItemDefinition() {
            return this.planItemDefinition;
        }

        public void setPlanItemDefinition(PlanItemDefinition planItemDefinition) {
            this.planItemDefinition = planItemDefinition;
        }
    }
}

