/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.cmmn.engine.impl.interceptor;

import java.util.Set;
import org.flowable.cmmn.engine.impl.agenda.CmmnEngineAgenda;
import org.flowable.cmmn.engine.impl.agenda.operation.CmmnOperation;
import org.flowable.cmmn.engine.impl.util.CommandContextUtil;
import org.flowable.common.engine.impl.context.Context;
import org.flowable.common.engine.impl.interceptor.AbstractCommandInterceptor;
import org.flowable.common.engine.impl.interceptor.Command;
import org.flowable.common.engine.impl.interceptor.CommandConfig;
import org.flowable.common.engine.impl.interceptor.CommandContext;
import org.flowable.common.engine.impl.interceptor.CommandInterceptor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CmmnCommandInvoker
extends AbstractCommandInterceptor {
    private static final Logger logger = LoggerFactory.getLogger(CmmnCommandInvoker.class);

    public <T> T execute(CommandConfig config, final Command<T> command) {
        final CommandContext commandContext = Context.getCommandContext();
        CmmnEngineAgenda agenda = CommandContextUtil.getAgenda(commandContext);
        if (commandContext.isReused() && !agenda.isEmpty()) {
            commandContext.setResult(command.execute(commandContext));
        } else {
            agenda.planOperation(new Runnable(){

                @Override
                public void run() {
                    commandContext.setResult(command.execute(commandContext));
                }
            });
            this.executeOperations(commandContext, true);
            this.evaluateUntilStable(commandContext);
        }
        return (T)commandContext.getResult();
    }

    protected void executeOperations(CommandContext commandContext, boolean isStoreCaseInstanceIdOfNoOperation) {
        CmmnEngineAgenda agenda = CommandContextUtil.getAgenda(commandContext);
        while (!agenda.isEmpty()) {
            String caseInstanceId;
            Runnable runnable = agenda.getNextOperation();
            if (logger.isDebugEnabled()) {
                logger.debug("Executing agenda operation {}", (Object)runnable);
            }
            runnable.run();
            if (!(runnable instanceof CmmnOperation)) continue;
            CmmnOperation operation = (CmmnOperation)runnable;
            if (!isStoreCaseInstanceIdOfNoOperation && operation.isNoop() || (caseInstanceId = operation.getCaseInstanceId()) == null) continue;
            CommandContextUtil.addInvolvedCaseInstanceId(commandContext, caseInstanceId);
        }
    }

    protected void evaluateUntilStable(CommandContext commandContext) {
        Set<String> involvedCaseInstanceIds = CommandContextUtil.getInvolvedCaseInstanceIds(commandContext);
        if (involvedCaseInstanceIds != null) {
            for (String caseInstanceId : involvedCaseInstanceIds) {
                CommandContextUtil.getAgenda(commandContext).planEvaluateCriteriaOperation(caseInstanceId, true);
            }
            involvedCaseInstanceIds.clear();
            this.executeOperations(commandContext, false);
            if (!involvedCaseInstanceIds.isEmpty()) {
                this.evaluateUntilStable(commandContext);
            }
        }
    }

    public void setNext(CommandInterceptor next) {
        throw new UnsupportedOperationException("CommandInvoker must be the last interceptor in the chain");
    }
}

