/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.cmmn.engine.impl.listener;

import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.apache.commons.lang3.StringUtils;
import org.flowable.cmmn.api.delegate.DelegatePlanItemInstance;
import org.flowable.cmmn.api.listener.PlanItemInstanceLifecycleListener;
import org.flowable.cmmn.engine.impl.listener.CmmnListenerNotificationHelper;
import org.flowable.cmmn.engine.impl.util.CommandContextUtil;
import org.flowable.cmmn.model.FlowableListener;
import org.flowable.cmmn.model.PlanItemDefinition;
import org.flowable.common.engine.impl.interceptor.CommandContext;

public class PlanItemLifeCycleListenerUtil {
    public static void callLifecycleListeners(CommandContext commandContext, DelegatePlanItemInstance planItemInstance, String oldState, String newState) {
        Map<String, List<PlanItemInstanceLifecycleListener>> planItemInstanceLifeCycleListeners;
        List flowableListeners;
        if (Objects.equals(oldState, newState)) {
            return;
        }
        PlanItemDefinition planItemDefinition = planItemInstance.getPlanItem().getPlanItemDefinition();
        if (planItemDefinition != null && (flowableListeners = planItemDefinition.getLifecycleListeners()) != null && !flowableListeners.isEmpty()) {
            CmmnListenerNotificationHelper listenerNotificationHelper = CommandContextUtil.getCmmnEngineConfiguration(commandContext).getListenerNotificationHelper();
            for (FlowableListener flowableListener : flowableListeners) {
                if (!PlanItemLifeCycleListenerUtil.stateMatches(flowableListener.getSourceState(), oldState) || !PlanItemLifeCycleListenerUtil.stateMatches(flowableListener.getTargetState(), newState)) continue;
                PlanItemInstanceLifecycleListener lifecycleListener = listenerNotificationHelper.createLifecycleListener(flowableListener);
                PlanItemLifeCycleListenerUtil.executeLifecycleListener(planItemInstance, oldState, newState, lifecycleListener);
            }
        }
        if ((planItemInstanceLifeCycleListeners = CommandContextUtil.getCmmnEngineConfiguration(commandContext).getPlanItemInstanceLifecycleListeners()) != null && !planItemInstanceLifeCycleListeners.isEmpty()) {
            List<PlanItemInstanceLifecycleListener> specificListeners = planItemInstanceLifeCycleListeners.get(planItemInstance.getPlanItemDefinitionType());
            PlanItemLifeCycleListenerUtil.executeListeners(specificListeners, planItemInstance, oldState, newState);
            List<PlanItemInstanceLifecycleListener> genericListeners = planItemInstanceLifeCycleListeners.get(null);
            PlanItemLifeCycleListenerUtil.executeListeners(genericListeners, planItemInstance, oldState, newState);
        }
    }

    public static void executeListeners(List<PlanItemInstanceLifecycleListener> listeners, DelegatePlanItemInstance planItemInstance, String oldState, String newState) {
        if (listeners != null) {
            for (PlanItemInstanceLifecycleListener lifecycleListener : listeners) {
                PlanItemLifeCycleListenerUtil.executeLifecycleListener(planItemInstance, oldState, newState, lifecycleListener);
            }
        }
    }

    public static void executeLifecycleListener(DelegatePlanItemInstance planItemInstance, String oldState, String newState, PlanItemInstanceLifecycleListener lifecycleListener) {
        if (PlanItemLifeCycleListenerUtil.lifecycleListenerMatches(lifecycleListener, oldState, newState)) {
            lifecycleListener.stateChanged(planItemInstance, oldState, newState);
        }
    }

    protected static boolean lifecycleListenerMatches(PlanItemInstanceLifecycleListener lifecycleListener, String oldState, String newState) {
        return PlanItemLifeCycleListenerUtil.stateMatches(lifecycleListener.getSourceState(), oldState) && PlanItemLifeCycleListenerUtil.stateMatches(lifecycleListener.getTargetState(), newState);
    }

    protected static boolean stateMatches(String listenerExpectedState, String actualState) {
        return StringUtils.isEmpty((CharSequence)listenerExpectedState) || Objects.equals(actualState, listenerExpectedState);
    }
}

