/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.engine.impl.history.async;

import com.fasterxml.jackson.databind.node.ObjectNode;
import java.util.Date;
import org.flowable.common.engine.impl.history.HistoryLevel;
import org.flowable.engine.impl.cfg.ProcessEngineConfigurationImpl;
import org.flowable.engine.impl.history.AbstractHistoryManager;
import org.flowable.engine.impl.persistence.entity.ExecutionEntity;
import org.flowable.engine.repository.ProcessDefinition;
import org.flowable.engine.runtime.ActivityInstance;
import org.flowable.entitylink.service.impl.persistence.entity.EntityLinkEntity;
import org.flowable.identitylink.service.impl.persistence.entity.IdentityLinkEntity;
import org.flowable.job.service.impl.history.async.util.AsyncHistoryJsonUtil;
import org.flowable.task.api.history.HistoricTaskLogEntryBuilder;
import org.flowable.task.service.impl.persistence.entity.TaskEntity;
import org.flowable.variable.service.impl.persistence.entity.VariableInstanceEntity;

public abstract class AbstractAsyncHistoryManager
extends AbstractHistoryManager {
    public AbstractAsyncHistoryManager(ProcessEngineConfigurationImpl processEngineConfiguration, HistoryLevel historyLevel, boolean usePrefixId) {
        super(processEngineConfiguration, historyLevel, usePrefixId);
    }

    protected void addCommonProcessInstanceFields(ExecutionEntity processInstance, ObjectNode data) {
        AsyncHistoryJsonUtil.putIfNotNull((ObjectNode)data, (String)"id", (String)processInstance.getId());
        AsyncHistoryJsonUtil.putIfNotNull((ObjectNode)data, (String)"revision", (int)processInstance.getRevision());
        AsyncHistoryJsonUtil.putIfNotNull((ObjectNode)data, (String)"processInstanceId", (String)processInstance.getProcessInstanceId());
        AsyncHistoryJsonUtil.putIfNotNull((ObjectNode)data, (String)"name", (String)processInstance.getName());
        AsyncHistoryJsonUtil.putIfNotNull((ObjectNode)data, (String)"businessKey", (String)processInstance.getBusinessKey());
        AsyncHistoryJsonUtil.putIfNotNull((ObjectNode)data, (String)"deploymentId", (String)processInstance.getDeploymentId());
        AsyncHistoryJsonUtil.putIfNotNull((ObjectNode)data, (String)"startTime", (Date)processInstance.getStartTime());
        AsyncHistoryJsonUtil.putIfNotNull((ObjectNode)data, (String)"startUserId", (String)processInstance.getStartUserId());
        AsyncHistoryJsonUtil.putIfNotNull((ObjectNode)data, (String)"startActivityId", (String)processInstance.getStartActivityId());
        AsyncHistoryJsonUtil.putIfNotNull((ObjectNode)data, (String)"superProcessInstanceId", processInstance.getSuperExecution() != null ? processInstance.getSuperExecution().getProcessInstanceId() : null);
        AsyncHistoryJsonUtil.putIfNotNull((ObjectNode)data, (String)"callbackId", (String)processInstance.getCallbackId());
        AsyncHistoryJsonUtil.putIfNotNull((ObjectNode)data, (String)"callbackType", (String)processInstance.getCallbackType());
        AsyncHistoryJsonUtil.putIfNotNull((ObjectNode)data, (String)"referenceId", (String)processInstance.getReferenceId());
        AsyncHistoryJsonUtil.putIfNotNull((ObjectNode)data, (String)"referenceType", (String)processInstance.getReferenceType());
        AsyncHistoryJsonUtil.putIfNotNull((ObjectNode)data, (String)"tenantId", (String)processInstance.getTenantId());
        this.addProcessDefinitionFields(data, processInstance.getProcessDefinitionId());
    }

    protected void addProcessDefinitionFields(ObjectNode data, String processDefinitionId) {
        if (processDefinitionId != null) {
            ProcessDefinition processDefinition = this.processEngineConfiguration.getDeploymentManager().findDeployedProcessDefinitionById(processDefinitionId);
            this.addProcessDefinitionFields(data, processDefinition);
        }
    }

    protected void addProcessDefinitionFields(ObjectNode data, ProcessDefinition processDefinition) {
        if (processDefinition != null) {
            AsyncHistoryJsonUtil.putIfNotNull((ObjectNode)data, (String)"processDefinitionId", (String)processDefinition.getId());
            AsyncHistoryJsonUtil.putIfNotNull((ObjectNode)data, (String)"processDefinitionKey", (String)processDefinition.getKey());
            AsyncHistoryJsonUtil.putIfNotNull((ObjectNode)data, (String)"processDefinitionName", (String)processDefinition.getName());
            AsyncHistoryJsonUtil.putIfNotNull((ObjectNode)data, (String)"processDefinitionVersion", (int)processDefinition.getVersion());
            AsyncHistoryJsonUtil.putIfNotNull((ObjectNode)data, (String)"processDefinitionCategory", (String)processDefinition.getCategory());
            AsyncHistoryJsonUtil.putIfNotNull((ObjectNode)data, (String)"deploymentId", (String)processDefinition.getDeploymentId());
            AsyncHistoryJsonUtil.putIfNotNull((ObjectNode)data, (String)"processDefinitionDerivedFrom", (String)processDefinition.getDerivedFrom());
            AsyncHistoryJsonUtil.putIfNotNull((ObjectNode)data, (String)"processDefinitionDerivedFromRoot", (String)processDefinition.getDerivedFromRoot());
            AsyncHistoryJsonUtil.putIfNotNull((ObjectNode)data, (String)"processDefinitionDerivedVersion", (int)processDefinition.getDerivedVersion());
        }
    }

    protected void addCommonTaskFields(TaskEntity task, ExecutionEntity execution, ObjectNode data) {
        AsyncHistoryJsonUtil.putIfNotNull((ObjectNode)data, (String)"id", (String)task.getId());
        AsyncHistoryJsonUtil.putIfNotNull((ObjectNode)data, (String)"revision", (int)task.getRevision());
        AsyncHistoryJsonUtil.putIfNotNull((ObjectNode)data, (String)"name", (String)task.getName());
        AsyncHistoryJsonUtil.putIfNotNull((ObjectNode)data, (String)"parentTaskId", (String)task.getParentTaskId());
        AsyncHistoryJsonUtil.putIfNotNull((ObjectNode)data, (String)"description", (String)task.getDescription());
        AsyncHistoryJsonUtil.putIfNotNull((ObjectNode)data, (String)"owner", (String)task.getOwner());
        AsyncHistoryJsonUtil.putIfNotNull((ObjectNode)data, (String)"assignee", (String)task.getAssignee());
        AsyncHistoryJsonUtil.putIfNotNull((ObjectNode)data, (String)"createTime", (Date)task.getCreateTime());
        AsyncHistoryJsonUtil.putIfNotNull((ObjectNode)data, (String)"taskDefinitionKey", (String)task.getTaskDefinitionKey());
        AsyncHistoryJsonUtil.putIfNotNull((ObjectNode)data, (String)"taskDefinitionId", (String)task.getTaskDefinitionId());
        AsyncHistoryJsonUtil.putIfNotNull((ObjectNode)data, (String)"formKey", (String)task.getFormKey());
        AsyncHistoryJsonUtil.putIfNotNull((ObjectNode)data, (String)"priority", (int)task.getPriority());
        AsyncHistoryJsonUtil.putIfNotNull((ObjectNode)data, (String)"dueDate", (Date)task.getDueDate());
        AsyncHistoryJsonUtil.putIfNotNull((ObjectNode)data, (String)"category", (String)task.getCategory());
        AsyncHistoryJsonUtil.putIfNotNull((ObjectNode)data, (String)"claimTime", (Date)task.getClaimTime());
        AsyncHistoryJsonUtil.putIfNotNull((ObjectNode)data, (String)"tenantId", (String)task.getTenantId());
        if (execution != null) {
            AsyncHistoryJsonUtil.putIfNotNull((ObjectNode)data, (String)"processInstanceId", (String)execution.getProcessInstanceId());
            AsyncHistoryJsonUtil.putIfNotNull((ObjectNode)data, (String)"executionId", (String)execution.getId());
            this.addProcessDefinitionFields(data, execution.getProcessDefinitionId());
        } else if (task.getProcessDefinitionId() != null) {
            this.addProcessDefinitionFields(data, task.getProcessDefinitionId());
        }
    }

    protected void addCommonVariableFields(VariableInstanceEntity variable, ObjectNode data) {
        AsyncHistoryJsonUtil.putIfNotNull((ObjectNode)data, (String)"id", (String)variable.getId());
        AsyncHistoryJsonUtil.putIfNotNull((ObjectNode)data, (String)"processInstanceId", (String)variable.getProcessInstanceId());
        AsyncHistoryJsonUtil.putIfNotNull((ObjectNode)data, (String)"executionId", (String)variable.getExecutionId());
        AsyncHistoryJsonUtil.putIfNotNull((ObjectNode)data, (String)"taskId", (String)variable.getTaskId());
        AsyncHistoryJsonUtil.putIfNotNull((ObjectNode)data, (String)"revision", (int)variable.getRevision());
        AsyncHistoryJsonUtil.putIfNotNull((ObjectNode)data, (String)"name", (String)variable.getName());
        AsyncHistoryJsonUtil.putIfNotNull((ObjectNode)data, (String)"scopeId", (String)variable.getScopeId());
        AsyncHistoryJsonUtil.putIfNotNull((ObjectNode)data, (String)"subScopeId", (String)variable.getSubScopeId());
        AsyncHistoryJsonUtil.putIfNotNull((ObjectNode)data, (String)"scopeType", (String)variable.getScopeType());
        AsyncHistoryJsonUtil.putIfNotNull((ObjectNode)data, (String)"variableType", (String)variable.getType().getTypeName());
        AsyncHistoryJsonUtil.putIfNotNull((ObjectNode)data, (String)"variableTextValue", (String)variable.getTextValue());
        AsyncHistoryJsonUtil.putIfNotNull((ObjectNode)data, (String)"variableTextValue2", (String)variable.getTextValue2());
        AsyncHistoryJsonUtil.putIfNotNull((ObjectNode)data, (String)"variableDoubleValue", (Double)variable.getDoubleValue());
        AsyncHistoryJsonUtil.putIfNotNull((ObjectNode)data, (String)"variableLongValue", (Long)variable.getLongValue());
        if (variable.getByteArrayRef() != null) {
            AsyncHistoryJsonUtil.putIfNotNull((ObjectNode)data, (String)"variableBytesValue", (String)AsyncHistoryJsonUtil.convertToBase64((VariableInstanceEntity)variable));
        }
        if (variable.getExecutionId() != null) {
            this.addProcessDefinitionFields(data, variable.getProcessDefinitionId());
        }
    }

    protected void addCommonIdentityLinkFields(IdentityLinkEntity identityLink, ObjectNode data) {
        AsyncHistoryJsonUtil.putIfNotNull((ObjectNode)data, (String)"id", (String)identityLink.getId());
        AsyncHistoryJsonUtil.putIfNotNull((ObjectNode)data, (String)"groupId", (String)identityLink.getGroupId());
        AsyncHistoryJsonUtil.putIfNotNull((ObjectNode)data, (String)"processDefinitionId", (String)identityLink.getProcessDefinitionId());
        AsyncHistoryJsonUtil.putIfNotNull((ObjectNode)data, (String)"processInstanceId", (String)identityLink.getProcessInstanceId());
        AsyncHistoryJsonUtil.putIfNotNull((ObjectNode)data, (String)"taskId", (String)identityLink.getTaskId());
        AsyncHistoryJsonUtil.putIfNotNull((ObjectNode)data, (String)"scopeDefinitionId", (String)identityLink.getScopeDefinitionId());
        AsyncHistoryJsonUtil.putIfNotNull((ObjectNode)data, (String)"scopeId", (String)identityLink.getScopeId());
        AsyncHistoryJsonUtil.putIfNotNull((ObjectNode)data, (String)"subScopeId", (String)identityLink.getSubScopeId());
        AsyncHistoryJsonUtil.putIfNotNull((ObjectNode)data, (String)"scopeType", (String)identityLink.getScopeType());
        AsyncHistoryJsonUtil.putIfNotNull((ObjectNode)data, (String)"identityLinkType", (String)identityLink.getType());
        AsyncHistoryJsonUtil.putIfNotNull((ObjectNode)data, (String)"userId", (String)identityLink.getUserId());
    }

    protected void addCommonEntityLinkFields(EntityLinkEntity entityLink, ObjectNode data) {
        AsyncHistoryJsonUtil.putIfNotNull((ObjectNode)data, (String)"id", (String)entityLink.getId());
        AsyncHistoryJsonUtil.putIfNotNull((ObjectNode)data, (String)"entityLinkType", (String)entityLink.getLinkType());
        AsyncHistoryJsonUtil.putIfNotNull((ObjectNode)data, (String)"createTime", (Date)entityLink.getCreateTime());
        AsyncHistoryJsonUtil.putIfNotNull((ObjectNode)data, (String)"scopeId", (String)entityLink.getScopeId());
        AsyncHistoryJsonUtil.putIfNotNull((ObjectNode)data, (String)"scopeType", (String)entityLink.getScopeType());
        AsyncHistoryJsonUtil.putIfNotNull((ObjectNode)data, (String)"scopeDefinitionId", (String)entityLink.getScopeDefinitionId());
        AsyncHistoryJsonUtil.putIfNotNull((ObjectNode)data, (String)"referenceScopeId", (String)entityLink.getReferenceScopeId());
        AsyncHistoryJsonUtil.putIfNotNull((ObjectNode)data, (String)"referenceScopeType", (String)entityLink.getReferenceScopeType());
        AsyncHistoryJsonUtil.putIfNotNull((ObjectNode)data, (String)"referenceScopeDefinitionId", (String)entityLink.getReferenceScopeDefinitionId());
        AsyncHistoryJsonUtil.putIfNotNull((ObjectNode)data, (String)"hierarchyType", (String)entityLink.getHierarchyType());
    }

    protected void addCommonActivityInstanceFields(ActivityInstance activityInstance, ObjectNode data) {
        AsyncHistoryJsonUtil.putIfNotNull((ObjectNode)data, (String)"runtimeActivityInstanceId", (String)activityInstance.getId());
        AsyncHistoryJsonUtil.putIfNotNull((ObjectNode)data, (String)"processDefinitionId", (String)activityInstance.getProcessDefinitionId());
        AsyncHistoryJsonUtil.putIfNotNull((ObjectNode)data, (String)"processInstanceId", (String)activityInstance.getProcessInstanceId());
        AsyncHistoryJsonUtil.putIfNotNull((ObjectNode)data, (String)"executionId", (String)activityInstance.getExecutionId());
        AsyncHistoryJsonUtil.putIfNotNull((ObjectNode)data, (String)"activityId", (String)activityInstance.getActivityId());
        AsyncHistoryJsonUtil.putIfNotNull((ObjectNode)data, (String)"activityName", (String)activityInstance.getActivityName());
        AsyncHistoryJsonUtil.putIfNotNull((ObjectNode)data, (String)"activityType", (String)activityInstance.getActivityType());
        AsyncHistoryJsonUtil.putIfNotNull((ObjectNode)data, (String)"tenantId", (String)activityInstance.getTenantId());
    }

    protected void addHistoricTaskLogEntryFields(HistoricTaskLogEntryBuilder taskLogEntryBuilder, ObjectNode data) {
        AsyncHistoryJsonUtil.putIfNotNull((ObjectNode)data, (String)"logEntryData", (String)taskLogEntryBuilder.getData());
        AsyncHistoryJsonUtil.putIfNotNull((ObjectNode)data, (String)"processInstanceId", (String)taskLogEntryBuilder.getProcessInstanceId());
        AsyncHistoryJsonUtil.putIfNotNull((ObjectNode)data, (String)"executionId", (String)taskLogEntryBuilder.getExecutionId());
        AsyncHistoryJsonUtil.putIfNotNull((ObjectNode)data, (String)"processDefinitionId", (String)taskLogEntryBuilder.getProcessDefinitionId());
        AsyncHistoryJsonUtil.putIfNotNull((ObjectNode)data, (String)"taskId", (String)taskLogEntryBuilder.getTaskId());
        AsyncHistoryJsonUtil.putIfNotNull((ObjectNode)data, (String)"tenantId", (String)taskLogEntryBuilder.getTenantId());
        AsyncHistoryJsonUtil.putIfNotNull((ObjectNode)data, (String)"createTime", (Date)taskLogEntryBuilder.getTimeStamp());
        AsyncHistoryJsonUtil.putIfNotNull((ObjectNode)data, (String)"userId", (String)taskLogEntryBuilder.getUserId());
        AsyncHistoryJsonUtil.putIfNotNull((ObjectNode)data, (String)"logEntryType", (String)taskLogEntryBuilder.getType());
        AsyncHistoryJsonUtil.putIfNotNull((ObjectNode)data, (String)"scopeId", (String)taskLogEntryBuilder.getScopeId());
        AsyncHistoryJsonUtil.putIfNotNull((ObjectNode)data, (String)"subScopeId", (String)taskLogEntryBuilder.getSubScopeId());
        AsyncHistoryJsonUtil.putIfNotNull((ObjectNode)data, (String)"scopeType", (String)taskLogEntryBuilder.getScopeType());
        AsyncHistoryJsonUtil.putIfNotNull((ObjectNode)data, (String)"scopeDefinitionId", (String)taskLogEntryBuilder.getScopeDefinitionId());
    }
}

