/*
 * Decompiled with CFR 0.152.
 */
package org.flywaydb.core.api;

import java.util.Date;
import org.flywaydb.core.api.MigrationState;
import org.flywaydb.core.api.MigrationVersion;
import org.flywaydb.core.extensibility.MigrationType;

public interface MigrationInfo
extends Comparable<MigrationInfo> {
    public MigrationType getType();

    public Integer getChecksum();

    default public boolean isVersioned() {
        return this.getVersion() != null;
    }

    public MigrationVersion getVersion();

    public String getDescription();

    public String getScript();

    public MigrationState getState();

    public Date getInstalledOn();

    public String getInstalledBy();

    public Integer getInstalledRank();

    public Integer getExecutionTime();

    public String getPhysicalLocation();

    public int compareVersion(MigrationInfo var1);

    default public String getShouldExecuteExpression() {
        return null;
    }

    default public boolean isShouldExecute() {
        return true;
    }

    default public boolean isRepeatable() {
        return this.getVersion() == null;
    }

    default public boolean isChecksumMatching() {
        return this.getResolvedChecksum() == null || this.getAppliedChecksum() == null || this.getResolvedChecksum().equals(this.getAppliedChecksum());
    }

    default public boolean isDescriptionMatching() {
        return this.getResolvedDescription() == null || this.getAppliedDescription() == null || this.getResolvedDescription().equals(this.getAppliedDescription());
    }

    default public Boolean isPlaceholderReplacement() {
        return true;
    }

    default public Integer getResolvedChecksum() {
        return null;
    }

    default public Integer getAppliedChecksum() {
        return null;
    }

    default public String getResolvedDescription() {
        return null;
    }

    default public String getAppliedDescription() {
        return null;
    }
}

