/*
 * Decompiled with CFR 0.152.
 */
package org.flywaydb.core.internal.util;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import lombok.Generated;
import org.flywaydb.core.Flyway;
import org.flywaydb.core.api.FlywayException;
import org.flywaydb.core.api.Location;
import org.flywaydb.core.api.logging.Log;
import org.flywaydb.core.api.logging.LogFactory;
import org.flywaydb.core.internal.scanner.LocationParser;
import org.flywaydb.core.internal.scanner.ReadOnlyLocationHandler;

public class Locations {
    @Generated
    private static final Log LOG = LogFactory.getLog(Locations.class);
    private final List<Location> locations = new ArrayList<Location>();

    public Locations(String ... rawLocations) {
        this.processLocations(Arrays.stream(rawLocations).map(LocationParser::parseLocation).toList());
    }

    public Locations(List<Location> rawLocations) {
        this.processLocations(rawLocations);
    }

    private void processLocations(List<Location> rawLocations) {
        List<ReadOnlyLocationHandler> locationHandlers = Flyway.configure().getPluginRegister().getInstancesOf(ReadOnlyLocationHandler.class);
        ArrayList<Location> sortedLocations = new ArrayList<Location>(rawLocations);
        Collections.sort(sortedLocations);
        for (Location normalizedLocation : sortedLocations) {
            if (this.locations.contains(normalizedLocation)) {
                LOG.warn("Discarding duplicate location '" + String.valueOf(normalizedLocation) + "'");
                continue;
            }
            Location parentLocation = this.getParentLocationIfExists(locationHandlers, normalizedLocation, this.locations);
            if (parentLocation != null) {
                LOG.warn("Discarding location '" + String.valueOf(normalizedLocation) + "' as it is a sub-location of '" + String.valueOf(parentLocation) + "'");
                continue;
            }
            this.locations.add(normalizedLocation);
        }
    }

    private Location getParentLocationIfExists(Collection<? extends ReadOnlyLocationHandler> locationHandlers, Location location, Collection<Location> finalLocations) {
        return finalLocations.stream().filter(fl -> {
            ReadOnlyLocationHandler locationHandler = locationHandlers.stream().filter(x -> x.canHandleLocation((Location)fl)).findFirst().orElseThrow(() -> new FlywayException("Unknown prefix for location: " + fl.getPrefix()));
            return this.isParent(locationHandler, (Location)fl, location);
        }).findFirst().orElse(null);
    }

    private boolean isParent(ReadOnlyLocationHandler locationHandler, Location potentialParent, Location location) {
        if (potentialParent.getPathRegex() != null || location.getPathRegex() != null) {
            return false;
        }
        String pathSeparator = locationHandler.getPathSeparator();
        return (location.getDescriptor() + pathSeparator).startsWith(potentialParent.getDescriptor() + pathSeparator);
    }

    @Generated
    public List<Location> getLocations() {
        return this.locations;
    }
}

