/*
 * Decompiled with CFR 0.152.
 */
package org.flywaydb.core.api.output.errors;

import java.util.Optional;
import org.flywaydb.core.api.ErrorCode;
import org.flywaydb.core.api.FlywayException;
import org.flywaydb.core.api.output.errors.ErrorCause;
import org.flywaydb.core.api.output.errors.ErrorOutputItem;
import org.flywaydb.core.api.output.errors.ExceptionToErrorObjectConverter;

public class FlywayExceptionToErrorObjectConverter
extends ExceptionToErrorObjectConverter<FlywayException, FlywayErrorOutputItem> {
    @Override
    public Class<FlywayException> getSupportedExceptionType() {
        return FlywayException.class;
    }

    @Override
    public FlywayErrorOutputItem convert(FlywayException exception) {
        return new FlywayErrorOutputItem(exception.getErrorCode(), Optional.ofNullable(exception.getMessage()).orElse("Error occurred"), this.getCause(exception).orElse(null));
    }

    public record FlywayErrorOutputItem(ErrorCode errorCode, String message, ErrorCause cause) implements ErrorOutputItem
    {
    }
}

