/*
 * Decompiled with CFR 0.152.
 */
package org.flywaydb.core.internal.logging;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.flywaydb.core.api.logging.Log;
import org.flywaydb.core.api.logging.LogFactory;
import org.flywaydb.core.internal.util.FlywayDbWebsiteLinks;

public class PreviewFeatureWarning {
    private static final Log LOG = LogFactory.getLog(PreviewFeatureWarning.class);
    private static final List<String> LOGGED_FEATURES = new ArrayList<String>();
    public static final String NATIVE_CONNECTORS = "Native Connectors";
    public static final String LEGACY_MONGODB = "MongoDB support";

    public static boolean isPreviewFeatureEnabled(String featureName, String environmentVariable, boolean showHowToEnable) {
        if (System.getenv(environmentVariable) != null) {
            PreviewFeatureWarning.logPreviewFeature(featureName);
            return true;
        }
        if (showHowToEnable) {
            LOG.debug("Preview feature '" + featureName + "' is disabled.");
            LOG.debug("Enable it by setting the environment variable " + environmentVariable + "=true");
        }
        return false;
    }

    public static void logPreviewFeature(String featureName) {
        if (LOGGED_FEATURES.contains(featureName)) {
            return;
        }
        LOG.info("-----------------------------------------------------------------------------");
        LOG.info("You are using a preview feature '" + featureName + "'.");
        if (Objects.equals(featureName, LEGACY_MONGODB)) {
            LOG.info("You are not using Native Connectors - the future of MongoDB support in Flyway.");
            LOG.info("You can enable this with the environment variable FLYWAY_NATIVE_CONNECTORS=true");
            LOG.info("Find out more here https://rd.gt/3CVVLC1");
            LOG.info("Please report any issues you encounter to " + FlywayDbWebsiteLinks.FEEDBACK_SURVEY_LINK);
        } else {
            LOG.info("Please report any issues you encounter to DatabaseDevOps@red-gate.com");
        }
        LOG.info("-----------------------------------------------------------------------------");
        LOGGED_FEATURES.add(featureName);
    }
}

