/*
 * Decompiled with CFR 0.152.
 */
package org.flywaydb.core.experimental;

import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.List;
import org.flywaydb.core.api.FlywayException;
import org.flywaydb.core.api.configuration.Configuration;
import org.flywaydb.core.experimental.AbstractExperimentalDatabase;
import org.flywaydb.core.experimental.ConnectionType;
import org.flywaydb.core.experimental.MetaData;
import org.flywaydb.core.experimental.schemahistory.SchemaHistoryItem;
import org.flywaydb.core.experimental.schemahistory.SchemaHistoryModel;
import org.flywaydb.core.internal.configuration.ConfigUtils;
import org.flywaydb.core.internal.configuration.models.ResolvedEnvironment;
import org.flywaydb.core.internal.jdbc.JdbcUtils;
import org.flywaydb.core.internal.jdbc.Result;
import org.flywaydb.core.internal.util.AsciiTable;

public abstract class ExperimentalJdbc<T>
extends AbstractExperimentalDatabase<T> {
    protected Connection connection;

    @Override
    public void initialize(ResolvedEnvironment environment, Configuration configuration) {
        int connectRetries = environment.getConnectRetries() != null ? environment.getConnectRetries() : 0;
        int connectRetriesInterval = environment.getConnectRetriesInterval() != null ? environment.getConnectRetriesInterval() : 0;
        this.connection = JdbcUtils.openConnection(configuration.getDataSource(), connectRetries, connectRetriesInterval);
        this.initializeConnectionType(environment, configuration);
        this.currentSchema = this.getDefaultSchema(configuration);
        this.metaData = this.getDatabaseMetaData();
    }

    @Override
    public boolean canCreateJdbcDataSource() {
        return true;
    }

    @Override
    public void doExecute(T executionUnit, boolean outputQueryResults) {
        try (Statement statement = this.connection.createStatement();){
            boolean hasResult = statement.execute((String)executionUnit);
            this.parseResults(hasResult, statement, outputQueryResults);
        }
        catch (SQLException e) {
            throw new FlywayException(e);
        }
    }

    @Override
    public void doExecuteBatch() {
        if (this.batch.isEmpty()) {
            return;
        }
        try (Statement statement = this.connection.createStatement();){
            for (String sql : this.batch) {
                statement.addBatch(sql);
            }
            statement.executeBatch();
            this.batch.clear();
        }
        catch (SQLException e) {
            throw new FlywayException(e);
        }
    }

    @Override
    public String getCurrentUser() {
        try {
            return JdbcUtils.getDatabaseMetaData(this.connection).getUserName();
        }
        catch (SQLException e) {
            throw new FlywayException(e);
        }
    }

    @Override
    public final MetaData getDatabaseMetaData() {
        if (this.metaData != null) {
            return this.metaData;
        }
        DatabaseMetaData databaseMetaData = JdbcUtils.getDatabaseMetaData(this.connection);
        String databaseProductName = JdbcUtils.getDatabaseProductName(databaseMetaData);
        String databaseProductVersion = JdbcUtils.getDatabaseProductVersion(databaseMetaData);
        String databaseName = null;
        try {
            databaseName = this.supportsCatalog() ? this.connection.getCatalog() : (this.supportsSchema() ? this.getCurrentSchema() : null);
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        return new MetaData(databaseProductName, databaseProductVersion, this.getConnectionType(), databaseName);
    }

    @Override
    public boolean isClosed() {
        try {
            return this.connection != null && this.connection.isClosed();
        }
        catch (SQLException e) {
            throw new FlywayException(e);
        }
    }

    @Override
    public void close() throws Exception {
        if (!this.isClosed()) {
            this.connection.close();
        }
    }

    protected boolean queryBoolean(String sql) {
        boolean bl;
        block8: {
            Statement statement = this.connection.createStatement();
            try {
                ResultSet resultSet = statement.executeQuery(sql);
                resultSet.next();
                bl = resultSet.getBoolean(1);
                if (statement == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (statement != null) {
                        try {
                            statement.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (SQLException e) {
                    throw new FlywayException(e);
                }
            }
            statement.close();
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<String> queryForStringList(String query) throws SQLException {
        ArrayList<String> result;
        ResultSet resultSet = null;
        try (Statement statement = this.connection.createStatement();){
            resultSet = statement.executeQuery(query);
            result = new ArrayList<String>();
            while (resultSet.next()) {
                result.add(resultSet.getString(1));
            }
        }
        catch (Throwable throwable) {
            JdbcUtils.closeResultSet(resultSet);
            throw throwable;
        }
        JdbcUtils.closeResultSet(resultSet);
        return result;
    }

    private void parseResults(boolean hasResults, Statement statement, boolean outputQueryResult) throws SQLException {
        if (outputQueryResult) {
            while (hasResults || statement.getUpdateCount() != -1) {
                if (hasResults) {
                    ArrayList<List<String>> data;
                    ArrayList<String> columns;
                    try (ResultSet resultSet = statement.getResultSet();){
                        columns = new ArrayList<String>();
                        ResultSetMetaData metadata = resultSet.getMetaData();
                        int columnCount = metadata.getColumnCount();
                        for (int i = 1; i <= columnCount; ++i) {
                            columns.add(metadata.getColumnName(i));
                        }
                        data = new ArrayList<List<String>>();
                        while (resultSet.next()) {
                            ArrayList<String> row = new ArrayList<String>();
                            for (int i = 1; i <= columnCount; ++i) {
                                row.add(resultSet.getString(i));
                            }
                            data.add(row);
                        }
                    }
                    this.outputResult(new Result(-1L, columns, data, ""));
                }
                hasResults = statement.getMoreResults();
            }
        }
    }

    private void outputResult(Result result) {
        if (result.columns() != null && !result.columns().isEmpty()) {
            LOG.info(new AsciiTable(result.columns(), result.data(), true, "", "No rows returned").render());
        }
    }

    @Override
    public SchemaHistoryModel getSchemaHistoryModel(String table) {
        SchemaHistoryModel schemaHistoryModel;
        block9: {
            Statement statement = this.connection.createStatement();
            try {
                String querySql = "SELECT " + this.doQuote("installed_rank") + ", " + this.doQuote("version") + ", " + this.doQuote("description") + ", " + this.doQuote("type") + ", " + this.doQuote("script") + ", " + this.doQuote("checksum") + ", " + this.doQuote("installed_on") + ", " + this.doQuote("installed_by") + ", " + this.doQuote("execution_time") + ", " + this.doQuote("success") + " FROM " + this.getTableNameWithSchema(table) + " WHERE " + this.doQuote("installed_rank") + " >= 0 ORDER BY " + this.doQuote("installed_rank");
                ResultSet resultSet = statement.executeQuery(querySql);
                ArrayList<SchemaHistoryItem> items = new ArrayList<SchemaHistoryItem>();
                while (resultSet.next()) {
                    items.add(SchemaHistoryItem.builder().installedRank(resultSet.getInt("installed_rank")).version(resultSet.getString("version")).description(resultSet.getString("description")).type(resultSet.getString("type")).script(resultSet.getString("script")).checksum(resultSet.getInt("checksum")).installedOn(resultSet.getTimestamp("installed_on").toLocalDateTime()).installedBy(resultSet.getString("installed_by")).executionTime(resultSet.getInt("execution_time")).success(resultSet.getBoolean("success")).build());
                }
                schemaHistoryModel = new SchemaHistoryModel(items);
                if (statement == null) break block9;
            }
            catch (Throwable throwable) {
                try {
                    if (statement != null) {
                        try {
                            statement.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (SQLException e) {
                    return new SchemaHistoryModel();
                }
            }
            statement.close();
        }
        return schemaHistoryModel;
    }

    @Override
    public void createSchemaHistoryTable(String tableName) {
        try (Statement statement = this.connection.createStatement();){
            String createSql = "CREATE TABLE " + this.getTableNameWithSchema(tableName) + " (\n" + this.doQuote("installed_rank") + " INT NOT NULL PRIMARY KEY,\n" + this.doQuote("version") + " VARCHAR(50),\n" + this.doQuote("description") + " VARCHAR(200) NOT NULL,\n" + this.doQuote("type") + " VARCHAR(20) NOT NULL,\n" + this.doQuote("script") + " VARCHAR(1000) NOT NULL,\n" + this.doQuote("checksum") + " INT,\n" + this.doQuote("installed_by") + " VARCHAR(100) NOT NULL,\n" + this.doQuote("installed_on") + " TEXT NOT NULL DEFAULT (strftime('%Y-%m-%d %H:%M:%f','now')),\n" + this.doQuote("execution_time") + " INT NOT NULL,\n" + this.doQuote("success") + " BOOLEAN NOT NULL\n );\n";
            statement.executeUpdate(createSql);
        }
        catch (SQLException e) {
            throw new FlywayException(e);
        }
    }

    @Override
    public void appendSchemaHistoryItem(SchemaHistoryItem item, String tableName) {
        try (Statement statement = this.connection.createStatement();){
            StringBuilder insertSql = new StringBuilder().append("INSERT INTO ").append(this.getTableNameWithSchema(tableName)).append(" (").append(this.doQuote("installed_rank") + ", ").append((String)(item.getVersion() == null ? "" : this.doQuote("version") + ", ")).append(this.doQuote("description") + ", ").append(this.doQuote("type") + ", ").append(this.doQuote("script") + ", ").append(this.doQuote("checksum") + ", ").append(this.doQuote("installed_by") + ", ").append(this.doQuote("execution_time") + ", ").append(this.doQuote("success")).append(")");
            insertSql.append(" VALUES (").append(item.getInstalledRank()).append(", ");
            if (item.getVersion() != null) {
                insertSql.append("'").append(item.getVersion()).append("', ");
            }
            insertSql.append("'").append(item.getDescription()).append("', ").append("'").append(item.getType()).append("', ").append("'").append(item.getScript()).append("', ").append(item.getChecksum()).append(", ").append("'").append(item.getInstalledBy() == null ? "" : item.getInstalledBy()).append("', ").append(item.getExecutionTime()).append(", ").append(this.supportsBoolean() ? Boolean.valueOf(item.isSuccess()) : (item.isSuccess() ? "1" : "0")).append(")");
            statement.execute(insertSql.toString());
        }
        catch (SQLException e) {
            throw new FlywayException(e);
        }
    }

    @Override
    public void removeFailedSchemaHistoryItems(String tableName) {
        try (Statement statement = this.connection.createStatement();){
            statement.execute("DELETE FROM " + this.getTableNameWithSchema(tableName) + " WHERE " + this.doQuote("success") + " = 0");
        }
        catch (SQLException e) {
            throw new FlywayException(e);
        }
    }

    @Override
    public void updateSchemaHistoryItem(SchemaHistoryItem item, String tableName) {
        try {
            String sql = "UPDATE " + this.getTableNameWithSchema(tableName) + " SET " + this.doQuote("description") + "=? , " + this.doQuote("type") + "=? , " + this.doQuote("checksum") + "=?" + " WHERE " + this.doQuote("installed_rank") + "=?";
            try (PreparedStatement statement = this.connection.prepareStatement(sql);){
                statement.setString(1, item.getDescription());
                statement.setString(2, item.getType());
                statement.setInt(3, item.getChecksum());
                statement.setInt(4, item.getInstalledRank());
                statement.execute();
            }
        }
        catch (SQLException e) {
            throw new FlywayException(e);
        }
    }

    @Override
    public final String getDefaultSchema(Configuration configuration) {
        if (!this.supportsSchema()) {
            return this.getSchemaPlaceHolder();
        }
        String schema = ConfigUtils.getCalculatedDefaultSchema(configuration);
        if (schema == null) {
            try {
                return this.connection.getSchema();
            }
            catch (SQLException e) {
                throw new FlywayException(e);
            }
        }
        return schema;
    }

    protected String getTableNameWithSchema(String table) {
        return this.quote(this.getCurrentSchema(), table);
    }

    protected boolean supportsSchema() {
        return true;
    }

    protected String getSchemaPlaceHolder() {
        return null;
    }

    protected boolean supportsBoolean() {
        return true;
    }

    protected boolean supportsCatalog() {
        return true;
    }

    protected void initializeConnectionType(ResolvedEnvironment environment, Configuration configuration) {
        this.connectionType = ConnectionType.JDBC;
    }
}

