/*
 * Decompiled with CFR 0.152.
 */
package org.flywaydb.core.internal.util.booleanexpression;

class ASTNodes {
    private ASTNodes() {
    }

    static enum LogicalOperator {
        AND,
        OR;

    }

    static enum Comparator {
        EQUAL,
        NOT_EQUAL;

    }

    record WordNode(String word) {
    }

    record BooleanNode(boolean value) implements Expression
    {
    }

    record WordExpressionComparisonExpression(WordNode word, Expression expression, Comparator comparator) implements Expression
    {
    }

    record WordComparisonExpression(WordNode leftWord, WordNode rightWord, Comparator comparator) implements Expression
    {
    }

    static class LogicalExpression
    extends InfixExpression<LogicalOperator> {
        LogicalExpression(Expression left, Expression right, LogicalOperator operator) {
            super(left, right, operator);
        }
    }

    static class ComparisonExpression
    extends InfixExpression<Comparator> {
        ComparisonExpression(Expression left, Expression right, Comparator comparator) {
            super(left, right, comparator);
        }
    }

    static class InfixExpression<T>
    implements Expression {
        private final Expression left;
        private final Expression right;
        private final T operator;

        public Expression getLeft() {
            return this.left;
        }

        public Expression getRight() {
            return this.right;
        }

        public T getOperator() {
            return this.operator;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof InfixExpression)) {
                return false;
            }
            InfixExpression other = (InfixExpression)o;
            if (!other.canEqual(this)) {
                return false;
            }
            Expression this$left = this.getLeft();
            Expression other$left = other.getLeft();
            if (this$left == null ? other$left != null : !this$left.equals(other$left)) {
                return false;
            }
            Expression this$right = this.getRight();
            Expression other$right = other.getRight();
            if (this$right == null ? other$right != null : !this$right.equals(other$right)) {
                return false;
            }
            T this$operator = this.getOperator();
            T other$operator = other.getOperator();
            return !(this$operator == null ? other$operator != null : !this$operator.equals(other$operator));
        }

        protected boolean canEqual(Object other) {
            return other instanceof InfixExpression;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Expression $left = this.getLeft();
            result = result * 59 + ($left == null ? 43 : $left.hashCode());
            Expression $right = this.getRight();
            result = result * 59 + ($right == null ? 43 : $right.hashCode());
            T $operator = this.getOperator();
            result = result * 59 + ($operator == null ? 43 : $operator.hashCode());
            return result;
        }

        public String toString() {
            return "ASTNodes.InfixExpression(left=" + String.valueOf(this.getLeft()) + ", right=" + String.valueOf(this.getRight()) + ", operator=" + String.valueOf(this.getOperator()) + ")";
        }

        InfixExpression(Expression left, Expression right, T operator) {
            this.left = left;
            this.right = right;
            this.operator = operator;
        }
    }

    public static interface Expression {
    }
}

