/*
 * Decompiled with CFR 0.152.
 */
package org.flywaydb.core.internal.command;

import java.sql.Connection;
import java.sql.SQLException;
import org.flywaydb.core.api.MigrationVersion;
import org.flywaydb.core.api.callback.FlywayCallback;
import org.flywaydb.core.api.resolver.MigrationResolver;
import org.flywaydb.core.internal.dbsupport.DbSupport;
import org.flywaydb.core.internal.dbsupport.Schema;
import org.flywaydb.core.internal.info.MigrationInfoServiceImpl;
import org.flywaydb.core.internal.metadatatable.MetaDataTable;
import org.flywaydb.core.internal.util.Pair;
import org.flywaydb.core.internal.util.StopWatch;
import org.flywaydb.core.internal.util.TimeFormat;
import org.flywaydb.core.internal.util.jdbc.TransactionCallback;
import org.flywaydb.core.internal.util.jdbc.TransactionTemplate;
import org.flywaydb.core.internal.util.logging.Log;
import org.flywaydb.core.internal.util.logging.LogFactory;

public class DbValidate {
    private static final Log LOG = LogFactory.getLog(DbValidate.class);
    private final MigrationVersion target;
    private final MetaDataTable metaDataTable;
    private final Schema schema;
    private final MigrationResolver migrationResolver;
    private final Connection connection;
    private final boolean outOfOrder;
    private final boolean pending;
    private final boolean future;
    private final FlywayCallback[] callbacks;
    private final DbSupport dbSupport;

    public DbValidate(Connection connection, DbSupport dbSupport, MetaDataTable metaDataTable, Schema schema, MigrationResolver migrationResolver, MigrationVersion target, boolean outOfOrder, boolean pending, boolean future, FlywayCallback[] callbacks) {
        this.connection = connection;
        this.dbSupport = dbSupport;
        this.metaDataTable = metaDataTable;
        this.schema = schema;
        this.migrationResolver = migrationResolver;
        this.target = target;
        this.outOfOrder = outOfOrder;
        this.pending = pending;
        this.future = future;
        this.callbacks = callbacks;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String validate() {
        try {
            for (final FlywayCallback flywayCallback : this.callbacks) {
                new TransactionTemplate(this.connection).execute(new TransactionCallback<Object>(){

                    @Override
                    public Object doInTransaction() throws SQLException {
                        DbValidate.this.dbSupport.changeCurrentSchemaTo(DbValidate.this.schema);
                        flywayCallback.beforeValidate(DbValidate.this.connection);
                        return null;
                    }
                });
            }
            LOG.debug("Validating migrations ...");
            StopWatch stopWatch = new StopWatch();
            stopWatch.start();
            Pair<Integer, String> result = new TransactionTemplate(this.connection).execute(new TransactionCallback<Pair<Integer, String>>(){

                @Override
                public Pair<Integer, String> doInTransaction() {
                    DbValidate.this.dbSupport.changeCurrentSchemaTo(DbValidate.this.schema);
                    MigrationInfoServiceImpl migrationInfoService = new MigrationInfoServiceImpl(DbValidate.this.migrationResolver, DbValidate.this.metaDataTable, DbValidate.this.target, DbValidate.this.outOfOrder, DbValidate.this.pending, DbValidate.this.future);
                    migrationInfoService.refresh();
                    int count = migrationInfoService.all().length;
                    String validationError = migrationInfoService.validate();
                    return Pair.of(count, validationError);
                }
            });
            stopWatch.stop();
            String error = result.getRight();
            if (error == null) {
                int n = result.getLeft();
                if (n == 1) {
                    LOG.info(String.format("Successfully validated 1 migration (execution time %s)", TimeFormat.format(stopWatch.getTotalTimeMillis())));
                } else {
                    LOG.info(String.format("Successfully validated %d migrations (execution time %s)", n, TimeFormat.format(stopWatch.getTotalTimeMillis())));
                }
            }
            for (final FlywayCallback callback : this.callbacks) {
                new TransactionTemplate(this.connection).execute(new TransactionCallback<Object>(){

                    @Override
                    public Object doInTransaction() throws SQLException {
                        DbValidate.this.dbSupport.changeCurrentSchemaTo(DbValidate.this.schema);
                        callback.afterValidate(DbValidate.this.connection);
                        return null;
                    }
                });
            }
            String string = error;
            return string;
        }
        finally {
            this.dbSupport.restoreCurrentSchema();
        }
    }
}

