/*
 * Decompiled with CFR 0.152.
 */
package org.flywaydb.core.internal.dbsupport.saphana;

import java.sql.Connection;
import java.sql.SQLException;
import org.flywaydb.core.internal.dbsupport.DbSupport;
import org.flywaydb.core.internal.dbsupport.JdbcTemplate;
import org.flywaydb.core.internal.dbsupport.Schema;
import org.flywaydb.core.internal.dbsupport.SqlStatementBuilder;
import org.flywaydb.core.internal.dbsupport.saphana.SapHanaSchema;
import org.flywaydb.core.internal.dbsupport.saphana.SapHanaSqlStatementBuilder;

public class SapHanaDbSupport
extends DbSupport {
    public SapHanaDbSupport(Connection connection) {
        super(new JdbcTemplate(connection, 12));
    }

    @Override
    public SqlStatementBuilder createSqlStatementBuilder() {
        return new SapHanaSqlStatementBuilder();
    }

    @Override
    public String getDbName() {
        return "saphana";
    }

    @Override
    protected String doGetCurrentSchemaName() throws SQLException {
        return this.jdbcTemplate.queryForString("SELECT CURRENT_SCHEMA FROM DUMMY", new String[0]);
    }

    @Override
    protected void doChangeCurrentSchemaTo(String schema) throws SQLException {
        this.jdbcTemplate.execute("SET SCHEMA " + schema, new Object[0]);
    }

    @Override
    public String getCurrentUserFunction() {
        return "CURRENT_USER";
    }

    @Override
    public boolean supportsDdlTransactions() {
        return false;
    }

    @Override
    public String getBooleanTrue() {
        return "1";
    }

    @Override
    public String getBooleanFalse() {
        return "0";
    }

    @Override
    public String doQuote(String identifier) {
        return "\"" + identifier + "\"";
    }

    @Override
    public Schema getSchema(String name) {
        return new SapHanaSchema(this.jdbcTemplate, this, name);
    }

    @Override
    public boolean catalogIsSchema() {
        return false;
    }
}

