/*
 * Decompiled with CFR 0.152.
 */
package org.flywaydb.core.internal.dbsupport.h2;

import java.sql.Connection;
import java.sql.SQLException;
import org.flywaydb.core.internal.dbsupport.DbSupport;
import org.flywaydb.core.internal.dbsupport.JdbcTemplate;
import org.flywaydb.core.internal.dbsupport.Schema;
import org.flywaydb.core.internal.dbsupport.SqlStatementBuilder;
import org.flywaydb.core.internal.dbsupport.h2.H2Schema;
import org.flywaydb.core.internal.dbsupport.h2.H2SqlStatementBuilder;

public class H2DbSupport
extends DbSupport {
    public H2DbSupport(Connection connection) {
        super(new JdbcTemplate(connection, 12));
    }

    @Override
    public String getDbName() {
        return "h2";
    }

    @Override
    public String getCurrentUserFunction() {
        return "USER()";
    }

    @Override
    protected String doGetCurrentSchemaName() throws SQLException {
        return this.jdbcTemplate.queryForString("CALL SCHEMA()", new String[0]);
    }

    @Override
    protected void doChangeCurrentSchemaTo(String schema) throws SQLException {
        this.jdbcTemplate.execute("SET SCHEMA " + this.quote(schema), new Object[0]);
    }

    @Override
    public boolean supportsDdlTransactions() {
        return false;
    }

    @Override
    public String getBooleanTrue() {
        return "1";
    }

    @Override
    public String getBooleanFalse() {
        return "0";
    }

    @Override
    public SqlStatementBuilder createSqlStatementBuilder() {
        return new H2SqlStatementBuilder();
    }

    @Override
    public String doQuote(String identifier) {
        return "\"" + identifier + "\"";
    }

    @Override
    public Schema getSchema(String name) {
        return new H2Schema(this.jdbcTemplate, this, name);
    }

    @Override
    public boolean catalogIsSchema() {
        return false;
    }
}

