/*
 * Decompiled with CFR 0.152.
 */
package org.flywaydb.core.internal.database.hsqldb;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import org.flywaydb.core.api.configuration.Configuration;
import org.flywaydb.core.internal.database.base.Schema;
import org.flywaydb.core.internal.database.hsqldb.HSQLDBDatabase;
import org.flywaydb.core.internal.database.hsqldb.HSQLDBSchema;
import org.flywaydb.core.internal.jdbc.JdbcUtils;

public class HSQLDBConnection
extends org.flywaydb.core.internal.database.base.Connection<HSQLDBDatabase> {
    HSQLDBConnection(Configuration configuration, HSQLDBDatabase database, Connection connection, boolean originalAutoCommit) {
        super(configuration, database, connection, originalAutoCommit);
    }

    @Override
    protected String getCurrentSchemaNameOrSearchPath() throws SQLException {
        ResultSet resultSet = null;
        String schema = null;
        try {
            resultSet = ((HSQLDBDatabase)this.database).getJdbcMetaData().getSchemas();
            while (resultSet.next()) {
                if (!resultSet.getBoolean("IS_DEFAULT")) continue;
                schema = resultSet.getString("TABLE_SCHEM");
            }
        }
        catch (Throwable throwable) {
            JdbcUtils.closeResultSet(resultSet);
            throw throwable;
        }
        JdbcUtils.closeResultSet(resultSet);
        return schema;
    }

    @Override
    public void doChangeCurrentSchemaOrSearchPathTo(String schema) throws SQLException {
        this.jdbcTemplate.execute("SET SCHEMA " + ((HSQLDBDatabase)this.database).quote(schema), new Object[0]);
    }

    @Override
    public Schema getSchema(String name) {
        return new HSQLDBSchema(this.jdbcTemplate, (HSQLDBDatabase)this.database, name);
    }
}

