/*
 * Decompiled with CFR 0.152.
 */
package org.flywaydb.core.api.configuration;

import java.io.File;
import java.io.OutputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import javax.sql.DataSource;
import org.flywaydb.core.api.ClassProvider;
import org.flywaydb.core.api.ErrorCode;
import org.flywaydb.core.api.FlywayException;
import org.flywaydb.core.api.Location;
import org.flywaydb.core.api.MigrationPattern;
import org.flywaydb.core.api.MigrationVersion;
import org.flywaydb.core.api.ResourceProvider;
import org.flywaydb.core.api.callback.Callback;
import org.flywaydb.core.api.configuration.Configuration;
import org.flywaydb.core.api.logging.Log;
import org.flywaydb.core.api.logging.LogFactory;
import org.flywaydb.core.api.migration.JavaMigration;
import org.flywaydb.core.api.resolver.MigrationResolver;
import org.flywaydb.core.internal.configuration.ConfigUtils;
import org.flywaydb.core.internal.jdbc.DriverDataSource;
import org.flywaydb.core.internal.license.Edition;
import org.flywaydb.core.internal.license.FlywayTeamsUpgradeRequiredException;
import org.flywaydb.core.internal.scanner.ClasspathClassScanner;
import org.flywaydb.core.internal.util.ClassUtils;
import org.flywaydb.core.internal.util.Locations;
import org.flywaydb.core.internal.util.StringUtils;

public class ClassicConfiguration
implements Configuration {
    private static final Log LOG = LogFactory.getLog(ClassicConfiguration.class);
    private String driver;
    private String url;
    private String user;
    private String password;
    private DataSource dataSource;
    private int connectRetries;
    private String initSql;
    private ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
    private Locations locations = new Locations("db/migration");
    private Charset encoding = StandardCharsets.UTF_8;
    private String defaultSchemaName = null;
    private String[] schemaNames = new String[0];
    private String table = "flyway_schema_history";
    private String tablespace;
    private MigrationVersion target;
    private MigrationPattern[] cherryPick;
    private boolean placeholderReplacement = true;
    private Map<String, String> placeholders = new HashMap<String, String>();
    private String placeholderPrefix = "${";
    private String placeholderSuffix = "}";
    private String sqlMigrationPrefix = "V";
    private String undoSqlMigrationPrefix = "U";
    private ResourceProvider resourceProvider = null;
    private ClassProvider<JavaMigration> javaMigrationClassProvider = null;
    private String repeatableSqlMigrationPrefix = "R";
    private String sqlMigrationSeparator = "__";
    private String[] sqlMigrationSuffixes = new String[]{".sql"};
    private JavaMigration[] javaMigrations = new JavaMigration[0];
    private boolean ignoreMissingMigrations;
    private boolean ignoreIgnoredMigrations;
    private boolean ignorePendingMigrations;
    private boolean ignoreFutureMigrations = true;
    private boolean validateMigrationNaming = false;
    private boolean validateOnMigrate = true;
    private boolean cleanOnValidationError;
    private boolean cleanDisabled;
    private MigrationVersion baselineVersion = MigrationVersion.fromVersion("1");
    private String baselineDescription = "<< Flyway Baseline >>";
    private boolean baselineOnMigrate;
    private boolean outOfOrder;
    private boolean skipExecutingMigrations;
    private final List<Callback> callbacks = new ArrayList<Callback>();
    private boolean skipDefaultCallbacks;
    private MigrationResolver[] resolvers = new MigrationResolver[0];
    private boolean skipDefaultResolvers;
    private boolean mixed;
    private boolean group;
    private String installedBy;
    private boolean createSchemas = true;
    private String[] errorOverrides = new String[0];
    private OutputStream dryRunOutput;
    private boolean stream;
    private boolean batch;
    private boolean outputQueryResults = true;
    private String licenseKey;
    private int lockRetryCount = 50;
    private Map<String, String> jdbcProperties;
    private boolean oracleSqlplus;
    private boolean oracleSqlplusWarn;
    private String oracleKerberosConfigFile = "";
    private String oracleKerberosCacheFile = "";
    private String vaultUrl;
    private String vaultToken;
    private String[] vaultSecrets;
    private final ClasspathClassScanner classScanner;

    public ClassicConfiguration() {
        this.classScanner = new ClasspathClassScanner(this.classLoader);
    }

    public ClassicConfiguration(ClassLoader classLoader) {
        if (classLoader != null) {
            this.classLoader = classLoader;
        }
        this.classScanner = new ClasspathClassScanner(this.classLoader);
    }

    public ClassicConfiguration(Configuration configuration) {
        this(configuration.getClassLoader());
        this.configure(configuration);
    }

    @Override
    public Location[] getLocations() {
        return this.locations.getLocations().toArray(new Location[0]);
    }

    @Override
    public Charset getEncoding() {
        return this.encoding;
    }

    @Override
    public String getDefaultSchema() {
        return this.defaultSchemaName;
    }

    @Override
    public String[] getSchemas() {
        return this.schemaNames;
    }

    @Override
    public String getTable() {
        return this.table;
    }

    @Override
    public String getTablespace() {
        return this.tablespace;
    }

    @Override
    public MigrationVersion getTarget() {
        return this.target;
    }

    @Override
    public MigrationPattern[] getCherryPick() {
        return this.cherryPick;
    }

    @Override
    public boolean isPlaceholderReplacement() {
        return this.placeholderReplacement;
    }

    @Override
    public Map<String, String> getPlaceholders() {
        return this.placeholders;
    }

    @Override
    public String getPlaceholderPrefix() {
        return this.placeholderPrefix;
    }

    @Override
    public String getPlaceholderSuffix() {
        return this.placeholderSuffix;
    }

    @Override
    public String getSqlMigrationPrefix() {
        return this.sqlMigrationPrefix;
    }

    @Override
    public String getRepeatableSqlMigrationPrefix() {
        return this.repeatableSqlMigrationPrefix;
    }

    @Override
    public String getSqlMigrationSeparator() {
        return this.sqlMigrationSeparator;
    }

    @Override
    public String[] getSqlMigrationSuffixes() {
        return this.sqlMigrationSuffixes;
    }

    @Override
    public JavaMigration[] getJavaMigrations() {
        return this.javaMigrations;
    }

    @Override
    public boolean isIgnoreMissingMigrations() {
        return this.ignoreMissingMigrations;
    }

    @Override
    public boolean isIgnoreIgnoredMigrations() {
        return this.ignoreIgnoredMigrations;
    }

    @Override
    public boolean isIgnorePendingMigrations() {
        return this.ignorePendingMigrations;
    }

    @Override
    public boolean isIgnoreFutureMigrations() {
        return this.ignoreFutureMigrations;
    }

    @Override
    public boolean isValidateMigrationNaming() {
        return this.validateMigrationNaming;
    }

    @Override
    public boolean isValidateOnMigrate() {
        return this.validateOnMigrate;
    }

    @Override
    public boolean isCleanOnValidationError() {
        return this.cleanOnValidationError;
    }

    @Override
    public boolean isCleanDisabled() {
        return this.cleanDisabled;
    }

    @Override
    public MigrationVersion getBaselineVersion() {
        return this.baselineVersion;
    }

    @Override
    public String getBaselineDescription() {
        return this.baselineDescription;
    }

    @Override
    public boolean isBaselineOnMigrate() {
        return this.baselineOnMigrate;
    }

    @Override
    public boolean isOutOfOrder() {
        return this.outOfOrder;
    }

    @Override
    public boolean isSkipExecutingMigrations() {
        return this.skipExecutingMigrations;
    }

    @Override
    public MigrationResolver[] getResolvers() {
        return this.resolvers;
    }

    @Override
    public boolean isSkipDefaultResolvers() {
        return this.skipDefaultResolvers;
    }

    @Override
    public String getUrl() {
        return this.url;
    }

    @Override
    public String getUser() {
        return this.user;
    }

    @Override
    public String getPassword() {
        return this.password;
    }

    @Override
    public DataSource getDataSource() {
        if (this.dataSource == null && (StringUtils.hasLength(this.driver) || StringUtils.hasLength(this.user) || StringUtils.hasLength(this.password))) {
            LOG.warn("Discarding INCOMPLETE dataSource configuration! flyway.url must be set.");
        }
        return this.dataSource;
    }

    @Override
    public int getConnectRetries() {
        return this.connectRetries;
    }

    @Override
    public String getInitSql() {
        return this.initSql;
    }

    @Override
    public ClassLoader getClassLoader() {
        return this.classLoader;
    }

    @Override
    public boolean isMixed() {
        return this.mixed;
    }

    @Override
    public String getInstalledBy() {
        return this.installedBy;
    }

    @Override
    public boolean isGroup() {
        return this.group;
    }

    @Override
    public String[] getErrorOverrides() {
        return this.errorOverrides;
    }

    @Override
    public OutputStream getDryRunOutput() {
        return this.dryRunOutput;
    }

    @Override
    public String getLicenseKey() {
        return this.licenseKey;
    }

    @Override
    public int getLockRetryCount() {
        return this.lockRetryCount;
    }

    @Override
    public Map<String, String> getJdbcProperties() {
        return this.jdbcProperties;
    }

    @Override
    public String getVaultUrl() {
        return this.vaultUrl;
    }

    @Override
    public String getVaultToken() {
        return this.vaultToken;
    }

    @Override
    public String[] getVaultSecrets() {
        return this.vaultSecrets;
    }

    @Override
    public boolean outputQueryResults() {
        return this.outputQueryResults;
    }

    @Override
    public ResourceProvider getResourceProvider() {
        return this.resourceProvider;
    }

    @Override
    public ClassProvider<JavaMigration> getJavaMigrationClassProvider() {
        return this.javaMigrationClassProvider;
    }

    @Override
    public boolean getCreateSchemas() {
        return this.createSchemas;
    }

    @Override
    public boolean isStream() {
        return this.stream;
    }

    @Override
    public boolean isBatch() {
        return this.batch;
    }

    @Override
    public String getUndoSqlMigrationPrefix() {
        return this.undoSqlMigrationPrefix;
    }

    @Override
    public Callback[] getCallbacks() {
        return this.callbacks.toArray(new Callback[0]);
    }

    @Override
    public boolean isSkipDefaultCallbacks() {
        return this.skipDefaultCallbacks;
    }

    @Override
    public boolean isOracleSqlplus() {
        return this.oracleSqlplus;
    }

    @Override
    public boolean isOracleSqlplusWarn() {
        return this.oracleSqlplusWarn;
    }

    @Override
    public String getOracleKerberosConfigFile() {
        return this.oracleKerberosConfigFile;
    }

    @Override
    public String getOracleKerberosCacheFile() {
        return this.oracleKerberosCacheFile;
    }

    public void setDryRunOutput(OutputStream dryRunOutput) {
        throw new FlywayTeamsUpgradeRequiredException("dryRunOutput");
    }

    public void setDryRunOutputAsFile(File dryRunOutput) {
        throw new FlywayTeamsUpgradeRequiredException("dryRunOutput");
    }

    public void setDryRunOutputAsFileName(String dryRunOutputFileName) {
        throw new FlywayTeamsUpgradeRequiredException("dryRunOutput");
    }

    public void setErrorOverrides(String ... errorOverrides) {
        throw new FlywayTeamsUpgradeRequiredException("errorOverrides");
    }

    public void setGroup(boolean group) {
        this.group = group;
    }

    public void setInstalledBy(String installedBy) {
        if ("".equals(installedBy)) {
            installedBy = null;
        }
        this.installedBy = installedBy;
    }

    public void setMixed(boolean mixed) {
        this.mixed = mixed;
    }

    public void setIgnoreMissingMigrations(boolean ignoreMissingMigrations) {
        this.ignoreMissingMigrations = ignoreMissingMigrations;
    }

    public void setIgnoreIgnoredMigrations(boolean ignoreIgnoredMigrations) {
        this.ignoreIgnoredMigrations = ignoreIgnoredMigrations;
    }

    public void setIgnorePendingMigrations(boolean ignorePendingMigrations) {
        this.ignorePendingMigrations = ignorePendingMigrations;
    }

    public void setIgnoreFutureMigrations(boolean ignoreFutureMigrations) {
        this.ignoreFutureMigrations = ignoreFutureMigrations;
    }

    public void setValidateMigrationNaming(boolean validateMigrationNaming) {
        this.validateMigrationNaming = validateMigrationNaming;
    }

    public void setValidateOnMigrate(boolean validateOnMigrate) {
        this.validateOnMigrate = validateOnMigrate;
    }

    public void setCleanOnValidationError(boolean cleanOnValidationError) {
        this.cleanOnValidationError = cleanOnValidationError;
    }

    public void setCleanDisabled(boolean cleanDisabled) {
        this.cleanDisabled = cleanDisabled;
    }

    public void setLocationsAsStrings(String ... locations) {
        this.locations = new Locations(locations);
    }

    public void setLocations(Location ... locations) {
        this.locations = new Locations(Arrays.asList(locations));
    }

    public void setEncoding(Charset encoding) {
        this.encoding = encoding;
    }

    public void setEncodingAsString(String encoding) {
        this.encoding = Charset.forName(encoding);
    }

    public void setDefaultSchema(String schema) {
        this.defaultSchemaName = schema;
    }

    public void setSchemas(String ... schemas) {
        this.schemaNames = schemas;
    }

    public void setTable(String table) {
        this.table = table;
    }

    public void setTablespace(String tablespace) {
        this.tablespace = tablespace;
    }

    public void setTarget(MigrationVersion target) {
        this.target = target;
    }

    public void setTargetAsString(String target) {
        this.target = MigrationVersion.fromVersion(target);
    }

    public void setCherryPick(MigrationPattern ... cherryPick) {
        throw new FlywayTeamsUpgradeRequiredException("cherryPick");
    }

    public void setCherryPick(String ... cherryPickAsString) {
        throw new FlywayTeamsUpgradeRequiredException("cherryPick");
    }

    public void setPlaceholderReplacement(boolean placeholderReplacement) {
        this.placeholderReplacement = placeholderReplacement;
    }

    public void setPlaceholders(Map<String, String> placeholders) {
        this.placeholders = placeholders;
    }

    public void setPlaceholderPrefix(String placeholderPrefix) {
        if (!StringUtils.hasLength(placeholderPrefix)) {
            throw new FlywayException("placeholderPrefix cannot be empty!", ErrorCode.CONFIGURATION);
        }
        this.placeholderPrefix = placeholderPrefix;
    }

    public void setPlaceholderSuffix(String placeholderSuffix) {
        if (!StringUtils.hasLength(placeholderSuffix)) {
            throw new FlywayException("placeholderSuffix cannot be empty!", ErrorCode.CONFIGURATION);
        }
        this.placeholderSuffix = placeholderSuffix;
    }

    public void setSqlMigrationPrefix(String sqlMigrationPrefix) {
        this.sqlMigrationPrefix = sqlMigrationPrefix;
    }

    public void setUndoSqlMigrationPrefix(String undoSqlMigrationPrefix) {
        throw new FlywayTeamsUpgradeRequiredException("undoSqlMigrationPrefix");
    }

    public void setJavaMigrations(JavaMigration ... javaMigrations) {
        if (javaMigrations == null) {
            throw new FlywayException("javaMigrations cannot be null", ErrorCode.CONFIGURATION);
        }
        this.javaMigrations = javaMigrations;
    }

    public void setStream(boolean stream) {
        throw new FlywayTeamsUpgradeRequiredException("stream");
    }

    public void setBatch(boolean batch) {
        throw new FlywayTeamsUpgradeRequiredException("batch");
    }

    public void setRepeatableSqlMigrationPrefix(String repeatableSqlMigrationPrefix) {
        this.repeatableSqlMigrationPrefix = repeatableSqlMigrationPrefix;
    }

    public void setSqlMigrationSeparator(String sqlMigrationSeparator) {
        if (!StringUtils.hasLength(sqlMigrationSeparator)) {
            throw new FlywayException("sqlMigrationSeparator cannot be empty!", ErrorCode.CONFIGURATION);
        }
        this.sqlMigrationSeparator = sqlMigrationSeparator;
    }

    public void setSqlMigrationSuffixes(String ... sqlMigrationSuffixes) {
        this.sqlMigrationSuffixes = sqlMigrationSuffixes;
    }

    public void setDataSource(DataSource dataSource) {
        this.driver = null;
        this.url = null;
        this.user = null;
        this.password = null;
        this.dataSource = dataSource;
    }

    public void setDataSource(String url, String user, String password) {
        this.url = url;
        this.user = user;
        this.password = password;
        this.dataSource = new DriverDataSource(this.classLoader, null, url, user, password, this);
    }

    public void setConnectRetries(int connectRetries) {
        if (connectRetries < 0) {
            throw new FlywayException("Invalid number of connectRetries (must be 0 or greater): " + connectRetries, ErrorCode.CONFIGURATION);
        }
        this.connectRetries = connectRetries;
    }

    public void setInitSql(String initSql) {
        this.initSql = initSql;
    }

    public void setBaselineVersion(MigrationVersion baselineVersion) {
        this.baselineVersion = baselineVersion;
    }

    public void setBaselineVersionAsString(String baselineVersion) {
        this.baselineVersion = MigrationVersion.fromVersion(baselineVersion);
    }

    public void setBaselineDescription(String baselineDescription) {
        this.baselineDescription = baselineDescription;
    }

    public void setBaselineOnMigrate(boolean baselineOnMigrate) {
        this.baselineOnMigrate = baselineOnMigrate;
    }

    public void setOutOfOrder(boolean outOfOrder) {
        this.outOfOrder = outOfOrder;
    }

    public void setSkipExecutingMigrations(boolean skipExecutingMigrations) {
        throw new FlywayTeamsUpgradeRequiredException("skipExecutingMigrations");
    }

    public void setCallbacks(Callback ... callbacks) {
        this.callbacks.clear();
        this.callbacks.addAll(Arrays.asList(callbacks));
    }

    public void setCallbacksAsClassNames(String ... callbacks) {
        this.callbacks.clear();
        for (String callback : callbacks) {
            this.loadCallbackPath(callback);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void loadCallbackPath(String callbackPath) {
        Object o = null;
        try {
            o = ClassUtils.instantiate(callbackPath, this.classLoader);
        }
        catch (FlywayException flywayException) {
            // empty catch block
        }
        if (o != null) {
            if (!(o instanceof Callback)) throw new FlywayException("Invalid callback: " + callbackPath + " (must implement org.flywaydb.core.api.callback.Callback)", ErrorCode.CONFIGURATION);
            this.callbacks.add(o);
            return;
        } else {
            this.loadCallbackLocation(callbackPath, true);
        }
    }

    public void loadCallbackLocation(String path, boolean errorOnNotFound) {
        List<String> callbackClasses = this.classScanner.scanForType(path, Callback.class, errorOnNotFound);
        for (String callback : callbackClasses) {
            Callback callbackObj = (Callback)ClassUtils.instantiate(callback, this.classLoader);
            this.callbacks.add(callbackObj);
        }
    }

    public void setSkipDefaultCallbacks(boolean skipDefaultCallbacks) {
        this.skipDefaultCallbacks = skipDefaultCallbacks;
    }

    public void setResolvers(MigrationResolver ... resolvers) {
        this.resolvers = resolvers;
    }

    public void setResolversAsClassNames(String ... resolvers) {
        List<MigrationResolver> resolverList = ClassUtils.instantiateAll(resolvers, this.classLoader);
        this.setResolvers(resolverList.toArray(new MigrationResolver[resolvers.length]));
    }

    public void setSkipDefaultResolvers(boolean skipDefaultResolvers) {
        this.skipDefaultResolvers = skipDefaultResolvers;
    }

    public void setOracleSqlplus(boolean oracleSqlplus) {
        throw new FlywayTeamsUpgradeRequiredException("oracle.sqlplus");
    }

    public void setOracleSqlplusWarn(boolean oracleSqlplusWarn) {
        throw new FlywayTeamsUpgradeRequiredException("oracle.sqlplusWarn");
    }

    public void setOracleKerberosConfigFile(String oracleKerberosConfigFile) {
        throw new FlywayTeamsUpgradeRequiredException("oracle.kerberosConfigFile");
    }

    public void setOracleKerberosCacheFile(String oracleKerberosCacheFile) {
        throw new FlywayTeamsUpgradeRequiredException("oracle.kerberosCacheFile");
    }

    public void setShouldCreateSchemas(boolean createSchemas) {
        this.createSchemas = createSchemas;
    }

    public void setLicenseKey(String licenseKey) {
        LOG.warn((Object)((Object)Edition.ENTERPRISE) + " upgrade required: " + licenseKey + " is not supported by " + (Object)((Object)Edition.COMMUNITY) + ".");
    }

    public void setOutputQueryResults(boolean outputQueryResults) {
        throw new FlywayTeamsUpgradeRequiredException("outputQueryResults");
    }

    public void setJdbcProperties(Map<String, String> jdbcProperties) {
        throw new FlywayTeamsUpgradeRequiredException("jdbcProperties");
    }

    public void setResourceProvider(ResourceProvider resourceProvider) {
        this.resourceProvider = resourceProvider;
    }

    public void setJavaMigrationClassProvider(ClassProvider<JavaMigration> javaMigrationClassProvider) {
        this.javaMigrationClassProvider = javaMigrationClassProvider;
    }

    public void setLockRetryCount(int lockRetryCount) {
        this.lockRetryCount = lockRetryCount;
    }

    public void setVaultUrl(String vaultUrl) {
        throw new FlywayTeamsUpgradeRequiredException("vaultUrl");
    }

    public void setVaultToken(String vaultToken) {
        throw new FlywayTeamsUpgradeRequiredException("vaultToken");
    }

    public void setVaultSecrets(String ... vaultSecrets) {
        throw new FlywayTeamsUpgradeRequiredException("vaultSecrets");
    }

    public void configure(Configuration configuration) {
        this.setBaselineDescription(configuration.getBaselineDescription());
        this.setBaselineOnMigrate(configuration.isBaselineOnMigrate());
        this.setBaselineVersion(configuration.getBaselineVersion());
        this.setCallbacks(configuration.getCallbacks());
        this.setCleanDisabled(configuration.isCleanDisabled());
        this.setCleanOnValidationError(configuration.isCleanOnValidationError());
        this.setDataSource(configuration.getDataSource());
        this.setConnectRetries(configuration.getConnectRetries());
        this.setInitSql(configuration.getInitSql());
        this.setEncoding(configuration.getEncoding());
        this.setGroup(configuration.isGroup());
        this.setValidateMigrationNaming(configuration.isValidateMigrationNaming());
        this.setIgnoreFutureMigrations(configuration.isIgnoreFutureMigrations());
        this.setIgnoreMissingMigrations(configuration.isIgnoreMissingMigrations());
        this.setIgnoreIgnoredMigrations(configuration.isIgnoreIgnoredMigrations());
        this.setIgnorePendingMigrations(configuration.isIgnorePendingMigrations());
        this.setInstalledBy(configuration.getInstalledBy());
        this.setJavaMigrations(configuration.getJavaMigrations());
        this.setLocations(configuration.getLocations());
        this.setMixed(configuration.isMixed());
        this.setOutOfOrder(configuration.isOutOfOrder());
        this.setPlaceholderPrefix(configuration.getPlaceholderPrefix());
        this.setPlaceholderReplacement(configuration.isPlaceholderReplacement());
        this.setPlaceholders(configuration.getPlaceholders());
        this.setPlaceholderSuffix(configuration.getPlaceholderSuffix());
        this.setRepeatableSqlMigrationPrefix(configuration.getRepeatableSqlMigrationPrefix());
        this.setResolvers(configuration.getResolvers());
        this.setDefaultSchema(configuration.getDefaultSchema());
        this.setSchemas(configuration.getSchemas());
        this.setSkipDefaultCallbacks(configuration.isSkipDefaultCallbacks());
        this.setSkipDefaultResolvers(configuration.isSkipDefaultResolvers());
        this.setSqlMigrationPrefix(configuration.getSqlMigrationPrefix());
        this.setSqlMigrationSeparator(configuration.getSqlMigrationSeparator());
        this.setSqlMigrationSuffixes(configuration.getSqlMigrationSuffixes());
        this.setTable(configuration.getTable());
        this.setTablespace(configuration.getTablespace());
        this.setTarget(configuration.getTarget());
        this.setValidateOnMigrate(configuration.isValidateOnMigrate());
        this.setResourceProvider(configuration.getResourceProvider());
        this.setJavaMigrationClassProvider(configuration.getJavaMigrationClassProvider());
        this.setShouldCreateSchemas(configuration.getCreateSchemas());
        this.setLockRetryCount(configuration.getLockRetryCount());
        this.url = configuration.getUrl();
        this.user = configuration.getUser();
        this.password = configuration.getPassword();
    }

    public void configure(Properties properties) {
        this.configure(ConfigUtils.propertiesToMap(properties));
    }

    public void configure(Map<String, String> props) {
        String licenseKeyProp;
        Boolean createSchemasProp;
        Boolean oracleSqlplusWarnProp;
        Boolean oracleSqlplusProp;
        Boolean batchProp;
        Boolean streamProp;
        String errorOverridesProp;
        String dryRunOutputProp;
        String installedByProp;
        Boolean groupProp;
        Boolean skipDefaultCallbacksProp;
        String callbacksProp;
        Boolean skipDefaultResolversProp;
        String resolversProp;
        Boolean outputQueryResultsProp;
        Boolean skipExecutingMigrationsProp;
        Boolean outOfOrderProp;
        Integer lockRetryCount;
        String cherryPickProp;
        String targetProp;
        Boolean validateMigrationNamingProp;
        Boolean ignoreFutureMigrationsProp;
        Boolean ignorePendingMigrationsProp;
        Boolean ignoreIgnoredMigrationsProp;
        Boolean ignoreMissingMigrationsProp;
        Boolean baselineOnMigrateProp;
        String baselineDescriptionProp;
        String baselineVersionProp;
        Boolean validateOnMigrateProp;
        Boolean cleanDisabledProp;
        Boolean cleanOnValidationErrorProp;
        String tablespaceProp;
        String tableProp;
        String schemasProp;
        String defaultSchemaProp;
        String encodingProp;
        String sqlMigrationSuffixesProp;
        String sqlMigrationSeparatorProp;
        String repeatableSqlMigrationPrefixProp;
        String undoSqlMigrationPrefixProp;
        String sqlMigrationPrefixProp;
        String placeholderSuffixProp;
        String placeholderPrefixProp;
        Boolean placeholderReplacementProp;
        String locationsProp;
        String initSqlProp;
        Integer connectRetriesProp;
        String passwordProp;
        String userProp;
        String urlProp;
        String driverProp = (props = new HashMap<String, String>(props)).remove("flyway.driver");
        if (driverProp != null) {
            this.dataSource = null;
            this.driver = driverProp;
        }
        if ((urlProp = props.remove("flyway.url")) != null) {
            this.dataSource = null;
            this.url = urlProp;
        }
        if ((userProp = props.remove("flyway.user")) != null) {
            this.dataSource = null;
            this.user = userProp;
        }
        if ((passwordProp = props.remove("flyway.password")) != null) {
            this.dataSource = null;
            this.password = passwordProp;
        }
        if ((connectRetriesProp = ConfigUtils.removeInteger(props, "flyway.connectRetries")) != null) {
            this.setConnectRetries(connectRetriesProp);
        }
        if ((initSqlProp = props.remove("flyway.initSql")) != null) {
            this.setInitSql(initSqlProp);
        }
        if ((locationsProp = props.remove("flyway.locations")) != null) {
            this.setLocationsAsStrings(StringUtils.tokenizeToStringArray(locationsProp, ","));
        }
        if ((placeholderReplacementProp = ConfigUtils.removeBoolean(props, "flyway.placeholderReplacement")) != null) {
            this.setPlaceholderReplacement(placeholderReplacementProp);
        }
        if ((placeholderPrefixProp = props.remove("flyway.placeholderPrefix")) != null) {
            this.setPlaceholderPrefix(placeholderPrefixProp);
        }
        if ((placeholderSuffixProp = props.remove("flyway.placeholderSuffix")) != null) {
            this.setPlaceholderSuffix(placeholderSuffixProp);
        }
        if ((sqlMigrationPrefixProp = props.remove("flyway.sqlMigrationPrefix")) != null) {
            this.setSqlMigrationPrefix(sqlMigrationPrefixProp);
        }
        if ((undoSqlMigrationPrefixProp = props.remove("flyway.undoSqlMigrationPrefix")) != null) {
            this.setUndoSqlMigrationPrefix(undoSqlMigrationPrefixProp);
        }
        if ((repeatableSqlMigrationPrefixProp = props.remove("flyway.repeatableSqlMigrationPrefix")) != null) {
            this.setRepeatableSqlMigrationPrefix(repeatableSqlMigrationPrefixProp);
        }
        if ((sqlMigrationSeparatorProp = props.remove("flyway.sqlMigrationSeparator")) != null) {
            this.setSqlMigrationSeparator(sqlMigrationSeparatorProp);
        }
        if ((sqlMigrationSuffixesProp = props.remove("flyway.sqlMigrationSuffixes")) != null) {
            this.setSqlMigrationSuffixes(StringUtils.tokenizeToStringArray(sqlMigrationSuffixesProp, ","));
        }
        if ((encodingProp = props.remove("flyway.encoding")) != null) {
            this.setEncodingAsString(encodingProp);
        }
        if ((defaultSchemaProp = props.remove("flyway.defaultSchema")) != null) {
            this.setDefaultSchema(defaultSchemaProp);
        }
        if ((schemasProp = props.remove("flyway.schemas")) != null) {
            this.setSchemas(StringUtils.tokenizeToStringArray(schemasProp, ","));
        }
        if ((tableProp = props.remove("flyway.table")) != null) {
            this.setTable(tableProp);
        }
        if ((tablespaceProp = props.remove("flyway.tablespace")) != null) {
            this.setTablespace(tablespaceProp);
        }
        if ((cleanOnValidationErrorProp = ConfigUtils.removeBoolean(props, "flyway.cleanOnValidationError")) != null) {
            this.setCleanOnValidationError(cleanOnValidationErrorProp);
        }
        if ((cleanDisabledProp = ConfigUtils.removeBoolean(props, "flyway.cleanDisabled")) != null) {
            this.setCleanDisabled(cleanDisabledProp);
        }
        if ((validateOnMigrateProp = ConfigUtils.removeBoolean(props, "flyway.validateOnMigrate")) != null) {
            this.setValidateOnMigrate(validateOnMigrateProp);
        }
        if ((baselineVersionProp = props.remove("flyway.baselineVersion")) != null) {
            this.setBaselineVersion(MigrationVersion.fromVersion(baselineVersionProp));
        }
        if ((baselineDescriptionProp = props.remove("flyway.baselineDescription")) != null) {
            this.setBaselineDescription(baselineDescriptionProp);
        }
        if ((baselineOnMigrateProp = ConfigUtils.removeBoolean(props, "flyway.baselineOnMigrate")) != null) {
            this.setBaselineOnMigrate(baselineOnMigrateProp);
        }
        if ((ignoreMissingMigrationsProp = ConfigUtils.removeBoolean(props, "flyway.ignoreMissingMigrations")) != null) {
            this.setIgnoreMissingMigrations(ignoreMissingMigrationsProp);
        }
        if ((ignoreIgnoredMigrationsProp = ConfigUtils.removeBoolean(props, "flyway.ignoreIgnoredMigrations")) != null) {
            this.setIgnoreIgnoredMigrations(ignoreIgnoredMigrationsProp);
        }
        if ((ignorePendingMigrationsProp = ConfigUtils.removeBoolean(props, "flyway.ignorePendingMigrations")) != null) {
            this.setIgnorePendingMigrations(ignorePendingMigrationsProp);
        }
        if ((ignoreFutureMigrationsProp = ConfigUtils.removeBoolean(props, "flyway.ignoreFutureMigrations")) != null) {
            this.setIgnoreFutureMigrations(ignoreFutureMigrationsProp);
        }
        if ((validateMigrationNamingProp = ConfigUtils.removeBoolean(props, "flyway.validateMigrationNaming")) != null) {
            this.setValidateMigrationNaming(validateMigrationNamingProp);
        }
        if ((targetProp = props.remove("flyway.target")) != null) {
            this.setTarget(MigrationVersion.fromVersion(targetProp));
        }
        if ((cherryPickProp = props.remove("flyway.cherryPick")) != null) {
            this.setCherryPick(StringUtils.tokenizeToStringArray(cherryPickProp, ","));
        }
        if ((lockRetryCount = ConfigUtils.removeInteger(props, "flyway.lockRetryCount")) != null) {
            this.setLockRetryCount(lockRetryCount);
        }
        if ((outOfOrderProp = ConfigUtils.removeBoolean(props, "flyway.outOfOrder")) != null) {
            this.setOutOfOrder(outOfOrderProp);
        }
        if ((skipExecutingMigrationsProp = ConfigUtils.removeBoolean(props, "flyway.skipExecutingMigrations")) != null) {
            this.setSkipExecutingMigrations(skipExecutingMigrationsProp);
        }
        if ((outputQueryResultsProp = ConfigUtils.removeBoolean(props, "flyway.outputQueryResults")) != null) {
            this.setOutputQueryResults(outputQueryResultsProp);
        }
        if (StringUtils.hasLength(resolversProp = props.remove("flyway.resolvers"))) {
            this.setResolversAsClassNames(StringUtils.tokenizeToStringArray(resolversProp, ","));
        }
        if ((skipDefaultResolversProp = ConfigUtils.removeBoolean(props, "flyway.skipDefaultResolvers")) != null) {
            this.setSkipDefaultResolvers(skipDefaultResolversProp);
        }
        if (StringUtils.hasLength(callbacksProp = props.remove("flyway.callbacks"))) {
            this.setCallbacksAsClassNames(StringUtils.tokenizeToStringArray(callbacksProp, ","));
        }
        if ((skipDefaultCallbacksProp = ConfigUtils.removeBoolean(props, "flyway.skipDefaultCallbacks")) != null) {
            this.setSkipDefaultCallbacks(skipDefaultCallbacksProp);
        }
        Map<String, String> placeholdersFromProps = this.getPropertiesUnderNamespace(props, this.getPlaceholders(), "flyway.placeholders.");
        this.setPlaceholders(placeholdersFromProps);
        Boolean mixedProp = ConfigUtils.removeBoolean(props, "flyway.mixed");
        if (mixedProp != null) {
            this.setMixed(mixedProp);
        }
        if ((groupProp = ConfigUtils.removeBoolean(props, "flyway.group")) != null) {
            this.setGroup(groupProp);
        }
        if ((installedByProp = props.remove("flyway.installedBy")) != null) {
            this.setInstalledBy(installedByProp);
        }
        if ((dryRunOutputProp = props.remove("flyway.dryRunOutput")) != null) {
            this.setDryRunOutputAsFileName(dryRunOutputProp);
        }
        if ((errorOverridesProp = props.remove("flyway.errorOverrides")) != null) {
            this.setErrorOverrides(StringUtils.tokenizeToStringArray(errorOverridesProp, ","));
        }
        if ((streamProp = ConfigUtils.removeBoolean(props, "flyway.stream")) != null) {
            this.setStream(streamProp);
        }
        if ((batchProp = ConfigUtils.removeBoolean(props, "flyway.batch")) != null) {
            this.setBatch(batchProp);
        }
        if ((oracleSqlplusProp = ConfigUtils.removeBoolean(props, "flyway.oracle.sqlplus")) != null) {
            this.setOracleSqlplus(oracleSqlplusProp);
        }
        if ((oracleSqlplusWarnProp = ConfigUtils.removeBoolean(props, "flyway.oracle.sqlplusWarn")) != null) {
            this.setOracleSqlplusWarn(oracleSqlplusWarnProp);
        }
        if ((createSchemasProp = ConfigUtils.removeBoolean(props, "flyway.createSchemas")) != null) {
            this.setShouldCreateSchemas(createSchemasProp);
        }
        if ((licenseKeyProp = props.remove("flyway.licenseKey")) != null) {
            this.setLicenseKey(licenseKeyProp);
        }
        if (StringUtils.hasText(this.url) && (StringUtils.hasText(urlProp) || StringUtils.hasText(driverProp) || StringUtils.hasText(userProp) || StringUtils.hasText(passwordProp))) {
            Map<String, String> jdbcPropertiesFromProps = this.getPropertiesUnderNamespace(props, this.getPlaceholders(), "flyway.jdbcProperties.");
            this.setDataSource(new DriverDataSource(this.classLoader, this.driver, this.url, this.user, this.password, this, jdbcPropertiesFromProps));
        }
        ConfigUtils.checkConfigurationForUnrecognisedProperties(props, "flyway.");
    }

    private Map<String, String> getPropertiesUnderNamespace(Map<String, String> properties, Map<String, String> current, String namespace) {
        HashMap<String, String> placeholdersFromProps = new HashMap<String, String>(current);
        Iterator<Map.Entry<String, String>> iterator = properties.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry<String, String> entry = iterator.next();
            String propertyName = entry.getKey();
            if (!propertyName.startsWith(namespace) || propertyName.length() <= namespace.length()) continue;
            String placeholderName = propertyName.substring(namespace.length());
            String placeholderValue = entry.getValue();
            placeholdersFromProps.put(placeholderName, placeholderValue);
            iterator.remove();
        }
        return placeholdersFromProps;
    }

    public void configureUsingEnvVars() {
        this.configure(ConfigUtils.environmentVariablesToPropertyMap());
    }
}

