/*
 * Decompiled with CFR 0.152.
 */
package org.flywaydb.core.internal.database.cockroachdb;

import java.sql.Connection;
import java.sql.SQLException;
import org.flywaydb.core.api.FlywayException;
import org.flywaydb.core.internal.database.base.Schema;
import org.flywaydb.core.internal.database.cockroachdb.CockroachDBDatabase;
import org.flywaydb.core.internal.database.cockroachdb.CockroachDBSchema;
import org.flywaydb.core.internal.exception.FlywaySqlException;
import org.flywaydb.core.internal.util.StringUtils;

public class CockroachDBConnection
extends org.flywaydb.core.internal.database.base.Connection<CockroachDBDatabase> {
    CockroachDBConnection(CockroachDBDatabase database, Connection connection) {
        super(database, connection);
    }

    @Override
    public Schema getSchema(String name) {
        return new CockroachDBSchema(this.jdbcTemplate, (CockroachDBDatabase)this.database, name);
    }

    @Override
    public Schema doGetCurrentSchema() throws SQLException {
        if (((CockroachDBDatabase)this.database).supportsSchemas()) {
            String currentSchema = this.jdbcTemplate.queryForString("SELECT current_schema", new String[0]);
            if (StringUtils.hasText(currentSchema)) {
                return this.getSchema(currentSchema);
            }
            String searchPath = this.getCurrentSchemaNameOrSearchPath();
            if (!StringUtils.hasText(searchPath)) {
                throw new FlywayException("Unable to determine current schema as search_path is empty. Set the current schema in currentSchema parameter of the JDBC URL or in Flyway's schemas property.");
            }
        }
        return super.doGetCurrentSchema();
    }

    @Override
    protected String getCurrentSchemaNameOrSearchPath() throws SQLException {
        if (((CockroachDBDatabase)this.database).supportsSchemas()) {
            return this.jdbcTemplate.queryForString("SHOW search_path", new String[0]);
        }
        return this.jdbcTemplate.queryForString("SHOW database", new String[0]);
    }

    @Override
    public void changeCurrentSchemaTo(Schema schema) {
        try {
            if (schema.getName().equals(this.originalSchemaNameOrSearchPath) || !schema.exists()) {
                return;
            }
            this.doChangeCurrentSchemaOrSearchPathTo(schema.getName());
        }
        catch (SQLException e) {
            throw new FlywaySqlException("Error setting current schema to " + schema, e);
        }
    }

    @Override
    public void doChangeCurrentSchemaOrSearchPathTo(String schema) throws SQLException {
        if (((CockroachDBDatabase)this.database).supportsSchemas()) {
            if (!StringUtils.hasLength(schema)) {
                schema = "public";
            }
            this.jdbcTemplate.execute("SET search_path = " + schema, new Object[0]);
        } else {
            if (!StringUtils.hasLength(schema)) {
                schema = "DEFAULT";
            }
            this.jdbcTemplate.execute("SET database = " + schema, new Object[0]);
        }
    }
}

