/*
 * Decompiled with CFR 0.152.
 */
package org.flywaydb.core.extensibility;

import java.util.UUID;
import org.flywaydb.core.api.configuration.Configuration;
import org.flywaydb.core.extensibility.LicenseInfo;
import org.flywaydb.core.extensibility.RgDomainChecker;

public class LicenseRgDomainChecker
implements RgDomainChecker {
    @Override
    public boolean isInDomain(Configuration config) {
        String licenseKey = config.getLicenseKey();
        if (licenseKey == null) {
            return false;
        }
        String licensedTo = LicenseInfo.extractLicenseInfo(licenseKey).getLicensedTo();
        return licensedTo.toLowerCase().contains("red") && licensedTo.toLowerCase().contains("gate") || LicenseRgDomainChecker.isUuid(licensedTo);
    }

    static boolean isUuid(String text) {
        try {
            UUID.fromString(text);
            return true;
        }
        catch (IllegalArgumentException e) {
            return false;
        }
    }
}

