/*
 * Decompiled with CFR 0.152.
 */
package org.flywaydb.database.informix;

import java.sql.SQLException;
import java.util.List;
import org.flywaydb.core.internal.database.base.Database;
import org.flywaydb.core.internal.database.base.Schema;
import org.flywaydb.core.internal.database.base.Table;
import org.flywaydb.core.internal.jdbc.JdbcTemplate;
import org.flywaydb.database.informix.InformixDatabase;
import org.flywaydb.database.informix.InformixTable;

public class InformixSchema
extends Schema<InformixDatabase, InformixTable> {
    InformixSchema(JdbcTemplate jdbcTemplate, InformixDatabase database, String name) {
        super(jdbcTemplate, (Database)database, name);
    }

    protected boolean doExists() throws SQLException {
        return this.jdbcTemplate.queryForInt("SELECT COUNT(*) FROM systables where owner = ? and tabid > 99", new String[]{this.name}) > 0;
    }

    protected boolean doEmpty() throws SQLException {
        return this.doAllTables().length == 0;
    }

    protected void doCreate() {
    }

    protected void doDrop() throws SQLException {
        this.clean();
    }

    protected void doClean() throws SQLException {
        List procedures = this.jdbcTemplate.queryForStringList("SELECT t.procname FROM \"informix\".sysprocedures AS t WHERE t.owner=? AND t.mode='O' AND t.externalname IS NULL AND t.procname NOT IN ( 'tscontainerusage', 'tscontainertotalused', 'tscontainertotalpages', 'tscontainernelems', 'tscontainerpctused', 'tsl_flushstatus', 'tsmakenullstamp')", new String[]{this.name});
        for (String procedure : procedures) {
            this.jdbcTemplate.execute("DROP PROCEDURE " + procedure, new Object[0]);
        }
        for (InformixTable table : (InformixTable[])this.allTables()) {
            table.drop();
        }
        List sequences = this.jdbcTemplate.queryForStringList("SELECT t.tabname FROM \"informix\".systables AS t WHERE owner=? AND t.tabid > 99 AND t.tabtype='Q' AND t.tabname NOT IN ('iot_data_seq')", new String[]{this.name});
        for (String sequence : sequences) {
            this.jdbcTemplate.execute("DROP SEQUENCE " + sequence, new Object[0]);
        }
    }

    private InformixTable[] findTables(String sqlQuery, String ... params) throws SQLException {
        List tableNames = this.jdbcTemplate.queryForStringList(sqlQuery, params);
        InformixTable[] tables = new InformixTable[tableNames.size()];
        for (int i = 0; i < tableNames.size(); ++i) {
            tables[i] = new InformixTable(this.jdbcTemplate, (InformixDatabase)this.database, this, (String)tableNames.get(i));
        }
        return tables;
    }

    protected InformixTable[] doAllTables() throws SQLException {
        return this.findTables("SELECT t.tabname FROM \"informix\".systables AS t WHERE owner=? AND t.tabid > 99 AND t.tabtype='T' AND t.tabname NOT IN ( 'calendarpatterns', 'calendartable', 'tscontainertable', 'tscontainerwindowtable', 'tsinstancetable',  'tscontainerusageactivewindowvti', 'tscontainerusagedormantwindowvti')", this.name);
    }

    public Table getTable(String tableName) {
        return new InformixTable(this.jdbcTemplate, (InformixDatabase)this.database, this, tableName);
    }
}

