/*
 * Decompiled with CFR 0.152.
 */
package org.flywaydb.database.nc.couchbase;

import com.couchbase.client.core.env.SecurityConfig;
import com.couchbase.client.java.Bucket;
import com.couchbase.client.java.Cluster;
import com.couchbase.client.java.ClusterOptions;
import com.couchbase.client.java.Scope;
import com.couchbase.client.java.env.ClusterEnvironment;
import com.couchbase.client.java.json.JsonObject;
import com.couchbase.client.java.query.QueryOptions;
import com.couchbase.client.java.query.QueryResult;
import com.couchbase.client.java.query.QueryScanConsistency;
import com.couchbase.client.java.transactions.TransactionQueryOptions;
import java.nio.charset.Charset;
import java.sql.Timestamp;
import java.time.Instant;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.function.BiFunction;
import org.flywaydb.core.api.FlywayException;
import org.flywaydb.core.api.configuration.Configuration;
import org.flywaydb.core.internal.configuration.ConfigUtils;
import org.flywaydb.core.internal.configuration.models.ResolvedEnvironment;
import org.flywaydb.core.internal.logging.PreviewFeatureWarning;
import org.flywaydb.core.internal.nc.ConnectionType;
import org.flywaydb.core.internal.nc.DatabaseSupport;
import org.flywaydb.core.internal.nc.DatabaseVersion;
import org.flywaydb.core.internal.nc.DatabaseVersionImpl;
import org.flywaydb.core.internal.nc.MetaData;
import org.flywaydb.core.internal.nc.schemahistory.SchemaHistoryItem;
import org.flywaydb.core.internal.nc.schemahistory.SchemaHistoryModel;
import org.flywaydb.core.internal.parser.Parser;
import org.flywaydb.core.internal.parser.ParsingContext;
import org.flywaydb.nc.NativeConnectorsNonJdbc;
import org.flywaydb.nc.executors.NonJdbcExecutorExecutionUnit;

public class CouchbaseDatabase
extends NativeConnectorsNonJdbc {
    private static final String URL_PREFIX = "couchbases:";
    private static final String DEFAULT_SCOPE = "_default";
    private Cluster cluster;
    private Bucket bucket;
    private Scope scope;
    private String currentFQCNPrefix;

    public boolean isOnByDefault(Configuration configuration) {
        return true;
    }

    protected String getDefaultSchema(Configuration configuration) {
        String defaultSchema = ConfigUtils.getCalculatedDefaultSchema((Configuration)configuration);
        if (defaultSchema == null) {
            throw new FlywayException("Couchbase connection failed: schema configuration is missing");
        }
        return defaultSchema;
    }

    public DatabaseSupport supportsUrl(String url) {
        if (url.startsWith(URL_PREFIX)) {
            return new DatabaseSupport(true, 1);
        }
        return new DatabaseSupport(false, 0);
    }

    public List<String> supportedVerbs() {
        return List.of("info", "migrate", "clean", "undo", "baseline", "validate", "repair", "testConnection");
    }

    public boolean supportsTransactions() {
        return true;
    }

    public void initialize(ResolvedEnvironment environment, Configuration configuration) {
        PreviewFeatureWarning.logPreviewFeature((String)(this.getDatabaseType() + " Support"));
        this.initializeConnectionType(configuration);
        ClusterEnvironment env = ((ClusterEnvironment.Builder)ClusterEnvironment.builder().securityConfig(SecurityConfig.enableTls((boolean)true))).build();
        this.cluster = Cluster.connect((String)environment.getUrl(), (ClusterOptions)ClusterOptions.clusterOptions((String)environment.getUser(), (String)environment.getPassword()).environment(env));
        this.isClosed = false;
        this.initializeBucketAndScope(this.getDefaultSchema(configuration));
    }

    private void initializeBucketAndScope(String defaultSchema) {
        this.currentSchema = defaultSchema;
        this.bucket = this.cluster.bucket(this.getBucketFromSchema(defaultSchema));
        this.scope = this.bucket.scope(this.getScopeFromSchema(defaultSchema));
        this.currentFQCNPrefix = "`" + this.bucket.name() + "`.`" + this.scope.name() + "`";
    }

    private void initializeConnectionType(Configuration configuration) {
        this.connectionType = ConnectionType.API;
    }

    public void doExecute(NonJdbcExecutorExecutionUnit executionUnit, boolean outputQueryResults) {
        try {
            this.scope.query(executionUnit.getScript(), QueryOptions.queryOptions().scanConsistency(QueryScanConsistency.REQUEST_PLUS));
            Thread.sleep(300L);
        }
        catch (Exception e) {
            throw new FlywayException((Throwable)e);
        }
    }

    public String getDatabaseType() {
        return "Couchbase";
    }

    public MetaData getDatabaseMetaData() {
        if (this.metaData != null) {
            return this.metaData;
        }
        QueryResult result = this.cluster.query("SELECT VERSION() AS version;");
        String serverVersion = ((JsonObject)result.rowsAsObject().get(0)).getString("version");
        this.metaData = new MetaData(this.getDatabaseType(), "Couchbase", (DatabaseVersion)new DatabaseVersionImpl(serverVersion), serverVersion, this.getCurrentSchema(), this.connectionType);
        return this.metaData;
    }

    public void createSchemaHistoryTable(Configuration configuration) {
        try {
            String fqcn = String.format("%s.%s", this.currentFQCNPrefix, configuration.getTable());
            this.scope.query("CREATE COLLECTION " + fqcn);
            Thread.sleep(300L);
            this.scope.query("CREATE PRIMARY INDEX ON " + fqcn);
        }
        catch (Exception e) {
            throw new FlywayException((Throwable)e);
        }
    }

    public boolean schemaHistoryTableExists(String tableName) {
        String sql = "SELECT * FROM system:keyspaces  WHERE `bucket` = $bucket AND `scope` = $scope AND `name` = $collection";
        QueryResult result = this.cluster.query(sql, QueryOptions.queryOptions().scanConsistency(QueryScanConsistency.REQUEST_PLUS).parameters(JsonObject.create().put("bucket", this.bucket.name()).put("scope", this.scope.name()).put("collection", tableName)));
        return !result.rowsAsObject().isEmpty();
    }

    public SchemaHistoryModel getSchemaHistoryModel(String tableName) {
        String fqcn = String.format("%s.%s", this.currentFQCNPrefix, tableName);
        String query = "SELECT installed_rank, version, description, type, script, checksum, installed_on, installed_by, execution_time, success FROM " + fqcn;
        ArrayList<SchemaHistoryItem> items = new ArrayList<SchemaHistoryItem>();
        try {
            QueryResult result = this.cluster.query(query, QueryOptions.queryOptions().scanConsistency(QueryScanConsistency.REQUEST_PLUS));
            for (JsonObject row : result.rowsAsObject()) {
                items.add(SchemaHistoryItem.builder().installedRank(row.getInt("installed_rank").intValue()).version(row.getString("version")).description(row.getString("description")).type(row.getString("type")).script(row.getString("script")).checksum(row.getInt("checksum")).installedOn(this.fromTimestampString(row.getString("installed_on"))).installedBy(row.getString("installed_by")).executionTime(row.getInt("execution_time").intValue()).success(row.getBoolean("success").booleanValue()).build());
            }
            return new SchemaHistoryModel(items);
        }
        catch (Exception ignored) {
            return new SchemaHistoryModel();
        }
    }

    private LocalDateTime fromTimestampString(String timestamp) {
        Object pattern = "yyyy-MM-dd HH:mm:ss.";
        pattern = (String)pattern + "S".repeat(timestamp.length() - ((String)pattern).length());
        return LocalDateTime.parse(timestamp, DateTimeFormatter.ofPattern((String)pattern, Locale.ENGLISH));
    }

    public void appendSchemaHistoryItem(SchemaHistoryItem item, String tableName) {
        String fqcn = String.format("%s.%s", this.currentFQCNPrefix, tableName);
        JsonObject params = JsonObject.create().put("installed_rank", item.getInstalledRank()).put("version", item.getVersion()).put("description", item.getDescription()).put("type", item.getType()).put("script", item.getScript()).put("checksum", (Number)item.getChecksum()).put("installed_on", Timestamp.from(Instant.now()).toString()).put("installed_by", item.getInstalledBy()).put("execution_time", item.getExecutionTime()).put("success", item.isSuccess());
        String query = "INSERT INTO " + fqcn + " (KEY, VALUE) VALUES (UUID(), " + params.toString() + ");";
        try {
            if (this.batch.isEmpty()) {
                this.scope.query(query, QueryOptions.queryOptions().scanConsistency(QueryScanConsistency.REQUEST_PLUS));
            } else {
                this.batch.add(new NonJdbcExecutorExecutionUnit(query, "", Charset.defaultCharset()));
            }
        }
        catch (Exception e) {
            throw new FlywayException((Throwable)e);
        }
    }

    public boolean isSchemaEmpty(String schema) {
        String bucket = this.getBucketFromSchema(schema);
        String scope = this.getScopeFromSchema(schema);
        String sql = "SELECT * FROM system:keyspaces  WHERE `bucket` = $bucket AND `scope` = $scope";
        QueryResult result = this.cluster.query(sql, QueryOptions.queryOptions().scanConsistency(QueryScanConsistency.REQUEST_PLUS).parameters(JsonObject.create().put("bucket", bucket).put("scope", scope)));
        return result.rowsAsObject().isEmpty();
    }

    public boolean isSchemaExists(String schema) {
        String bucket = this.getBucketFromSchema(schema);
        String scope = this.getScopeFromSchema(schema);
        String sql = "SELECT * FROM system:scopes  WHERE `bucket` = $bucket";
        QueryResult result = this.cluster.query(sql, QueryOptions.queryOptions().scanConsistency(QueryScanConsistency.REQUEST_PLUS).parameters(JsonObject.create().put("bucket", bucket)));
        if (result.rowsAsObject().isEmpty()) {
            return false;
        }
        if (DEFAULT_SCOPE.equals(scope)) {
            return true;
        }
        return result.rowsAsObject().stream().anyMatch(row -> scope.equals(row.getObject("scopes").getString("name")));
    }

    public void createSchemas(String ... schemas) {
        for (String schema : schemas) {
            String bucket = this.getBucketFromSchema(schema);
            String scope = this.getScopeFromSchema(schema);
            try {
                if (!this.isSchemaExists(bucket)) {
                    throw new FlywayException("Bucket creation is currently not supported");
                }
                if (DEFAULT_SCOPE.equals(scope)) continue;
                String fullScope = String.format("`%s`.`%s`", bucket, scope);
                this.cluster.query("CREATE SCOPE " + fullScope, QueryOptions.queryOptions().scanConsistency(QueryScanConsistency.REQUEST_PLUS));
            }
            catch (Exception e) {
                throw new FlywayException((Throwable)e);
            }
        }
    }

    public BiFunction<Configuration, ParsingContext, Parser> getParser() {
        return null;
    }

    public void doExecuteBatch() {
        if (this.batch.isEmpty()) {
            return;
        }
        try {
            this.cluster.transactions().run(ctx -> {
                for (NonJdbcExecutorExecutionUnit executionUnit : this.batch) {
                    ctx.query(this.scope, executionUnit.getScript(), TransactionQueryOptions.queryOptions().scanConsistency(QueryScanConsistency.REQUEST_PLUS));
                }
            });
        }
        catch (Exception e) {
            throw new FlywayException((Throwable)e);
        }
        finally {
            this.batch.clear();
        }
    }

    public boolean transactionAsBatch() {
        return true;
    }

    public String getCurrentUser() {
        return null;
    }

    public void startTransaction() {
        this.batch.clear();
    }

    public void commitTransaction() {
        this.batch.clear();
    }

    public void rollbackTransaction() {
        this.batch.clear();
    }

    public void doCleanSchema(String schema) {
        String bucket = this.getBucketFromSchema(schema);
        String scope = this.getScopeFromSchema(schema);
        try {
            String sql = "SELECT * FROM system:keyspaces  WHERE `bucket` = $bucket AND `scope` = $scope";
            QueryResult result = this.cluster.query(sql, QueryOptions.queryOptions().scanConsistency(QueryScanConsistency.REQUEST_PLUS).parameters(JsonObject.create().put("bucket", bucket).put("scope", scope)));
            for (JsonObject row : result.rowsAsObject()) {
                String collectionName = row.getObject("keyspaces").getString("name");
                String fqcn = String.format("`%s`.`%s`.%s", bucket, scope, collectionName);
                this.cluster.query("DROP COLLECTION " + fqcn);
            }
        }
        catch (Exception e) {
            throw new FlywayException((Throwable)e);
        }
    }

    public void doDropSchema(String schema) {
        String bucket = this.getBucketFromSchema(schema);
        String scope = this.getScopeFromSchema(schema);
        try {
            if (!DEFAULT_SCOPE.equals(scope)) {
                String fullScope = String.format("`%s`.`%s`", bucket, scope);
                this.cluster.query("DROP SCOPE " + fullScope, QueryOptions.queryOptions().scanConsistency(QueryScanConsistency.REQUEST_PLUS));
            }
        }
        catch (Exception e) {
            throw new FlywayException((Throwable)e);
        }
    }

    public void removeFailedSchemaHistoryItems(String tableName) {
        try {
            String fqcn = String.format("%s.%s", this.currentFQCNPrefix, tableName);
            this.scope.query("DELETE FROM " + fqcn + " WHERE success = false", QueryOptions.queryOptions().scanConsistency(QueryScanConsistency.REQUEST_PLUS));
        }
        catch (Exception e) {
            throw new FlywayException((Throwable)e);
        }
    }

    public void updateSchemaHistoryItem(SchemaHistoryItem item, String tableName) {
        try {
            String fqcn = String.format("%s.%s", this.currentFQCNPrefix, tableName);
            String sql = "UPDATE " + fqcn + " SET checksum = $checksum, description = $description, type = $type WHERE installed_rank = $installed_rank LIMIT 1";
            JsonObject params = JsonObject.create().put("installed_rank", item.getInstalledRank()).put("checksum", (Number)item.getChecksum()).put("description", item.getDescription()).put("type", item.getType());
            this.scope.query(sql, QueryOptions.queryOptions().scanConsistency(QueryScanConsistency.REQUEST_PLUS).parameters(params));
        }
        catch (Exception e) {
            throw new FlywayException((Throwable)e);
        }
    }

    public void close() {
        if (this.cluster != null) {
            this.cluster.close();
            super.close();
        }
    }

    private String getBucketFromSchema(String schema) {
        int index = schema.indexOf(".");
        if (index != -1) {
            return schema.substring(0, index);
        }
        return schema;
    }

    private String getScopeFromSchema(String schema) {
        int index = schema.indexOf(".");
        if (index != -1) {
            return schema.substring(index + 1);
        }
        return DEFAULT_SCOPE;
    }
}

