/*
 * Decompiled with CFR 0.152.
 */
package org.flywaydb.database.sybasease;

import java.sql.Connection;
import java.sql.SQLException;
import java.util.List;
import org.flywaydb.core.api.FlywayException;
import org.flywaydb.core.api.configuration.Configuration;
import org.flywaydb.core.api.logging.Log;
import org.flywaydb.core.api.logging.LogFactory;
import org.flywaydb.core.extensibility.Tier;
import org.flywaydb.core.internal.database.base.Database;
import org.flywaydb.core.internal.database.base.Table;
import org.flywaydb.core.internal.jdbc.JdbcConnectionFactory;
import org.flywaydb.core.internal.jdbc.Result;
import org.flywaydb.core.internal.jdbc.Results;
import org.flywaydb.core.internal.jdbc.StatementInterceptor;
import org.flywaydb.core.internal.sqlscript.Delimiter;
import org.flywaydb.database.sybasease.SybaseASEConnection;

public class SybaseASEDatabase
extends Database<SybaseASEConnection> {
    private static final Log LOG = LogFactory.getLog(SybaseASEDatabase.class);
    private String databaseName = null;
    private boolean supportsMultiStatementTransactions = false;

    public SybaseASEDatabase(Configuration configuration, JdbcConnectionFactory jdbcConnectionFactory, StatementInterceptor statementInterceptor) {
        super(configuration, jdbcConnectionFactory, statementInterceptor);
    }

    protected SybaseASEConnection doGetConnection(Connection connection) {
        return new SybaseASEConnection(this, connection);
    }

    public void ensureSupported(Configuration configuration) {
        this.ensureDatabaseIsRecentEnough("15.7");
        this.ensureDatabaseNotOlderThanOtherwiseRecommendUpgradeToFlywayEdition("16.3", Tier.PREMIUM, configuration);
        this.recommendFlywayUpgradeIfNecessary("16.3");
    }

    public String getRawCreateScript(Table table, boolean baseline) {
        return "CREATE TABLE " + table.getName() + " (\n    installed_rank INT NOT NULL,\n    version VARCHAR(50) NULL,\n    description VARCHAR(200) NOT NULL,\n    type VARCHAR(20) NOT NULL,\n    script VARCHAR(1000) NOT NULL,\n    checksum INT NULL,\n    installed_by VARCHAR(100) NOT NULL,\n    installed_on datetime DEFAULT getDate() NOT NULL,\n    execution_time INT NOT NULL,\n    success decimal NOT NULL,\n    PRIMARY KEY (installed_rank)\n)\nlock datarows on 'default'\n" + (String)(baseline ? this.getBaselineStatement(table) + "\n" : "") + "go\nCREATE INDEX " + table.getName() + "_s_idx ON " + table.getName() + " (success)\ngo\n";
    }

    public boolean supportsEmptyMigrationDescription() {
        return false;
    }

    public Delimiter getDefaultDelimiter() {
        return Delimiter.GO;
    }

    protected String doGetCurrentUser() throws SQLException {
        return ((SybaseASEConnection)this.getMainConnection()).getJdbcTemplate().queryForString("SELECT user_name()", new String[0]);
    }

    public boolean supportsDdlTransactions() {
        return false;
    }

    public String getBooleanTrue() {
        return "1";
    }

    public String getBooleanFalse() {
        return "0";
    }

    public String getOpenQuote() {
        return "";
    }

    public String getCloseQuote() {
        return "";
    }

    public boolean catalogIsSchema() {
        return false;
    }

    public boolean supportsMultiStatementTransactions() {
        if (this.supportsMultiStatementTransactions) {
            LOG.debug("ddl in tran was found to be true at some point during execution.Therefore multi statement transaction support is assumed.");
            return true;
        }
        boolean ddlInTran = this.getDdlInTranOption();
        if (ddlInTran) {
            LOG.debug("ddl in tran is true. Multi statement transaction support is now assumed.");
            this.supportsMultiStatementTransactions = true;
        }
        return this.supportsMultiStatementTransactions;
    }

    boolean getDdlInTranOption() {
        try {
            String databaseName = this.getDatabaseName();
            String getDatabaseMetadataQuery = "sp_helpdb " + databaseName + " -- ";
            Results results = ((SybaseASEConnection)this.getMainConnection()).getJdbcTemplate().executeStatement(getDatabaseMetadataQuery);
            for (int resultsIndex = 0; resultsIndex < results.getResults().size(); ++resultsIndex) {
                int statusIndex;
                List columns = ((Result)results.getResults().get(resultsIndex)).columns();
                if (columns == null || (statusIndex = this.getStatusIndex(columns)) <= -1) continue;
                String options = (String)((List)((Result)results.getResults().get(resultsIndex)).data().get(0)).get(statusIndex);
                return options.contains("ddl in tran");
            }
            return false;
        }
        catch (Exception e) {
            throw new FlywayException((Throwable)e);
        }
    }

    private int getStatusIndex(List<String> columns) {
        for (int statusIndex = 0; statusIndex < columns.size(); ++statusIndex) {
            if (!"status".equals(columns.get(statusIndex))) continue;
            return statusIndex;
        }
        return -1;
    }

    String getDatabaseName() throws SQLException {
        if (this.databaseName == null) {
            this.databaseName = ((SybaseASEConnection)this.getMainConnection()).getJdbcTemplate().queryForString("select db_name()", new String[0]);
        }
        return this.databaseName;
    }
}

