/*
 * Decompiled with CFR 0.152.
 */
package org.flywaydb.community.database.timeplus;

import java.sql.SQLException;
import java.util.List;
import java.util.Optional;
import org.flywaydb.community.database.timeplus.TimeplusConnection;
import org.flywaydb.community.database.timeplus.TimeplusDatabase;
import org.flywaydb.community.database.timeplus.TimeplusTable;
import org.flywaydb.core.internal.database.base.Database;
import org.flywaydb.core.internal.database.base.Schema;
import org.flywaydb.core.internal.jdbc.JdbcTemplate;
import org.flywaydb.core.internal.util.StringUtils;

public class TimeplusSchema
extends Schema<TimeplusDatabase, TimeplusTable> {
    private static final String DEFAULT_SCHEMA = "default";

    public TimeplusSchema(JdbcTemplate jdbcTemplate, TimeplusDatabase database, String name) {
        super(jdbcTemplate, (Database)database, name);
    }

    protected boolean doExists() throws SQLException {
        TimeplusConnection systemConnection = ((TimeplusDatabase)this.database).getSystemConnection();
        int i = systemConnection.getJdbcTemplate().queryForInt("SELECT COUNT() FROM system.databases WHERE name = ?", new String[]{this.name});
        return i > 0;
    }

    protected boolean doEmpty() throws SQLException {
        TimeplusConnection systemConnection = ((TimeplusDatabase)this.database).getSystemConnection();
        int objectCount = systemConnection.getJdbcTemplate().queryForInt("SELECT COUNT() FROM system.tables WHERE database = ?", new String[]{this.name}) + this.getObjectCount("FUNCTION") + this.getObjectCount("FORMAT SCHEMA");
        return objectCount == 0;
    }

    protected void doCreate() throws SQLException {
        TimeplusConnection systemConnection = ((TimeplusDatabase)this.database).getSystemConnection();
        String clusterName = ((TimeplusDatabase)this.database).getClusterName();
        boolean isClustered = StringUtils.hasText((String)clusterName);
        systemConnection.getJdbcTemplate().executeStatement("CREATE DATABASE " + ((TimeplusDatabase)this.database).quote(new String[]{this.name}));
    }

    protected void doDrop() throws SQLException {
        if (((TimeplusConnection)((TimeplusDatabase)this.database).getMainConnection()).getCurrentSchemaNameOrSearchPath().equals(this.name)) {
            ((TimeplusConnection)((TimeplusDatabase)this.database).getMainConnection()).doChangeCurrentSchemaOrSearchPathTo(Optional.ofNullable(((TimeplusDatabase)this.database).getConfiguration().getDefaultSchema()).orElse(DEFAULT_SCHEMA));
        }
        String clusterName = ((TimeplusDatabase)this.database).getClusterName();
        boolean isClustered = StringUtils.hasText((String)clusterName);
        this.jdbcTemplate.executeStatement("DROP DATABASE " + ((TimeplusDatabase)this.database).quote(new String[]{this.name}) + (String)(isClustered ? " ON CLUSTER " + clusterName : ""));
    }

    protected void doClean() throws SQLException {
        for (TimeplusTable table : (TimeplusTable[])this.allTables()) {
            table.drop();
        }
        for (String dropStatement : this.generateDropStatements("FORMAT SCHEMA")) {
            this.jdbcTemplate.execute(dropStatement, new Object[0]);
        }
        for (String dropStatement : this.generateDropStatements("FUNCTION")) {
            this.jdbcTemplate.execute(dropStatement, new Object[0]);
        }
    }

    protected TimeplusTable[] doAllTables() throws SQLException {
        TimeplusConnection systemConnection = ((TimeplusDatabase)this.database).getSystemConnection();
        return (TimeplusTable[])systemConnection.getJdbcTemplate().queryForStringList("SELECT name FROM system.tables WHERE database = ?", new String[]{this.name}).stream().map(this::getTable).toArray(TimeplusTable[]::new);
    }

    public TimeplusTable getTable(String tableName) {
        return new TimeplusTable(this.jdbcTemplate, (TimeplusDatabase)this.database, this, tableName);
    }

    private int getObjectCount(String objectType) throws SQLException {
        return this.jdbcTemplate.query("SHOW " + objectType + "S", rs -> 1, new Object[0]).size();
    }

    private List<String> generateDropStatements(String objectType) throws SQLException {
        return this.jdbcTemplate.query("SHOW " + objectType + "S", rs -> {
            String resName = rs.getString("name");
            return "DROP " + objectType + " " + ((TimeplusDatabase)this.database).quote(new String[]{resName});
        }, new Object[0]);
    }
}

