/*
 * Decompiled with CFR 0.152.
 */
package org.flywaydb.database.firebird;

import java.sql.Connection;
import java.util.Properties;
import org.flywaydb.core.api.ResourceProvider;
import org.flywaydb.core.api.configuration.Configuration;
import org.flywaydb.core.internal.database.base.BaseDatabaseType;
import org.flywaydb.core.internal.database.base.Database;
import org.flywaydb.core.internal.jdbc.JdbcConnectionFactory;
import org.flywaydb.core.internal.jdbc.StatementInterceptor;
import org.flywaydb.core.internal.parser.Parser;
import org.flywaydb.core.internal.parser.ParsingContext;
import org.flywaydb.database.firebird.FirebirdDatabase;
import org.flywaydb.database.firebird.FirebirdParser;

public class FirebirdDatabaseType
extends BaseDatabaseType {
    public String getName() {
        return "Firebird";
    }

    public int getNullType() {
        return 0;
    }

    public boolean handlesJDBCUrl(String url) {
        return url.startsWith("jdbc:firebird:") || url.startsWith("jdbc:firebirdsql:") || url.startsWith("jdbc:p6spy:firebird:") || url.startsWith("jdbc:p6spy:firebirdsql:");
    }

    public String getDriverClass(String url, ClassLoader classLoader) {
        if (url.startsWith("jdbc:p6spy:firebird:") || url.startsWith("jdbc:p6spy:firebirdsql:")) {
            return "com.p6spy.engine.spy.P6SpyDriver";
        }
        return "org.firebirdsql.jdbc.FBDriver";
    }

    public boolean handlesDatabaseProductNameAndVersion(String databaseProductName, String databaseProductVersion, Connection connection) {
        return databaseProductName.startsWith("Firebird");
    }

    public Database createDatabase(Configuration configuration, JdbcConnectionFactory jdbcConnectionFactory, StatementInterceptor statementInterceptor) {
        return new FirebirdDatabase(configuration, jdbcConnectionFactory, statementInterceptor);
    }

    public Parser createParser(Configuration configuration, ResourceProvider resourceProvider, ParsingContext parsingContext) {
        return new FirebirdParser(configuration, parsingContext);
    }

    public void setDefaultConnectionProps(String url, Properties props, ClassLoader classLoader) {
        props.put("processName", "Flyway by Redgate");
    }
}

