/*
 * Decompiled with CFR 0.152.
 */
package org.flywaydb.database.spanner;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import org.flywaydb.core.internal.database.InsertRowLock;
import org.flywaydb.core.internal.database.base.Database;
import org.flywaydb.core.internal.database.base.Schema;
import org.flywaydb.core.internal.database.base.Table;
import org.flywaydb.core.internal.jdbc.JdbcTemplate;
import org.flywaydb.database.spanner.SpannerDatabase;
import org.flywaydb.database.spanner.SpannerSchema;

public class SpannerTable
extends Table<SpannerDatabase, SpannerSchema> {
    private final InsertRowLock insertRowLock;

    public SpannerTable(JdbcTemplate jdbcTemplate, SpannerDatabase database, SpannerSchema schema, String name) {
        super(jdbcTemplate, (Database)database, (Schema)schema, name);
        this.insertRowLock = new InsertRowLock(jdbcTemplate);
    }

    protected boolean doExists() throws SQLException {
        try (Connection c = ((SpannerDatabase)this.database).getNewRawConnection();){
            boolean bl;
            block12: {
                Statement s = c.createStatement();
                s.close();
                ResultSet tables = c.getMetaData().getTables("", "", this.name, null);
                try {
                    bl = tables.next();
                    if (tables == null) break block12;
                }
                catch (Throwable throwable) {
                    if (tables != null) {
                        try {
                            tables.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                tables.close();
            }
            return bl;
        }
    }

    protected void doLock() throws SQLException {
        String updateLockStatement = "UPDATE " + this.name + " SET installed_on = CURRENT_TIMESTAMP() WHERE version = '?' AND DESCRIPTION = 'flyway-lock'";
        String deleteExpiredLockStatement = " DELETE FROM " + this.name + " WHERE DESCRIPTION = 'flyway-lock' AND installed_on < TIMESTAMP_ADD(CURRENT_TIMESTAMP(), INTERVAL -10 MINUTE)";
        if (this.lockDepth == 0) {
            this.insertRowLock.doLock(((SpannerDatabase)this.database).getInsertStatement(this), updateLockStatement, deleteExpiredLockStatement, ((SpannerDatabase)this.database).getBooleanTrue());
        }
    }

    protected void doUnlock() throws SQLException {
        if (this.lockDepth == 1) {
            this.insertRowLock.doUnlock(this.getDeleteLockTemplate());
        }
    }

    private String getDeleteLockTemplate() {
        return "DELETE FROM " + this.name + " WHERE version = '?' AND DESCRIPTION = 'flyway-lock'";
    }

    protected void doDrop() throws SQLException {
        try (Statement statement = this.jdbcTemplate.getConnection().createStatement();){
            statement.execute("DROP TABLE " + ((SpannerDatabase)this.database).quote(new String[]{this.name}));
        }
    }

    public String toString() {
        return ((SpannerDatabase)this.database).quote(new String[]{this.name});
    }
}

