/*
 * Decompiled with CFR 0.152.
 */
package org.flywaydb.nc.executors;

import org.flywaydb.core.api.FlywayException;
import org.flywaydb.core.api.configuration.Configuration;
import org.flywaydb.core.internal.nc.ConnectionType;
import org.flywaydb.core.internal.nc.Executor;
import org.flywaydb.nc.NativeConnectorsNonJdbc;
import org.flywaydb.nc.executors.NonJdbcExecutorExecutionUnit;

public class ApiExecutor
implements Executor<NonJdbcExecutorExecutionUnit, NativeConnectorsNonJdbc> {
    public void execute(NativeConnectorsNonJdbc experimentalDatabase, NonJdbcExecutorExecutionUnit executionUnit, Configuration configuration) {
        if (configuration.isBatch() && !experimentalDatabase.supportsBatch()) {
            throw new FlywayException("The Batch feature is not supported for " + experimentalDatabase.getDatabaseType());
        }
        if (configuration.isBatch() || experimentalDatabase.transactionAsBatch() && executionUnit.isExecuteInTransaction()) {
            experimentalDatabase.addToBatch(executionUnit);
        } else {
            if (experimentalDatabase.transactionAsBatch()) {
                experimentalDatabase.doExecuteBatch();
            }
            experimentalDatabase.doExecute(executionUnit, configuration.isOutputQueryResults());
        }
    }

    public void finishExecution(NativeConnectorsNonJdbc experimentalDatabase, Configuration configuration) {
        if (configuration.isBatch() || experimentalDatabase.transactionAsBatch()) {
            experimentalDatabase.doExecuteBatch();
        }
    }

    public boolean canExecute(ConnectionType connectionType) {
        return connectionType == ConnectionType.API;
    }

    public void appendErrorMessage(NonJdbcExecutorExecutionUnit executionUnit, StringBuilder messageBuilder, boolean isDebugEnabled) {
    }
}

