/*
 * Decompiled with CFR 0.152.
 */
package org.flywaydb.nc.preparation;

import java.sql.SQLException;
import java.util.Arrays;
import java.util.Collection;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import lombok.Generated;
import org.flywaydb.core.api.FlywayException;
import org.flywaydb.core.api.MigrationInfo;
import org.flywaydb.core.api.callback.Event;
import org.flywaydb.core.api.configuration.Configuration;
import org.flywaydb.core.api.resource.LoadableResourceMetadata;
import org.flywaydb.core.extensibility.Plugin;
import org.flywaydb.core.internal.nc.NativeConnectorsDatabase;
import org.flywaydb.core.internal.nc.schemahistory.SchemaHistoryModel;
import org.flywaydb.core.internal.parser.ParsingContext;
import org.flywaydb.core.internal.util.TelemetryUtils;
import org.flywaydb.nc.callbacks.CallbackManager;
import org.flywaydb.nc.utils.NativeConnectorsUtils;
import org.flywaydb.nc.utils.VerbUtils;

public final class PreparationContext
implements Plugin {
    private NativeConnectorsDatabase database;
    private SchemaHistoryModel schemaHistoryModel;
    private Collection<LoadableResourceMetadata> resources;
    private Collection<LoadableResourceMetadata> callbackResources;
    private MigrationInfo[] migrations;
    private ParsingContext parsingContext;
    private boolean isInitialized;
    private String cacheString;

    public void initialize(Configuration configuration) {
        try {
            this.database = VerbUtils.getExperimentalDatabase(configuration);
            this.parsingContext = new ParsingContext();
            this.parsingContext.populate(this.database, configuration);
            CompletableFuture<Collection> resourcesFuture = CompletableFuture.supplyAsync(() -> VerbUtils.scanForResources(configuration, this.parsingContext, configuration.getLocations()));
            this.resources = (Collection)this.getFromFuture(resourcesFuture);
            if (configuration.getCallbackLocations().length > 0) {
                CompletableFuture<Collection> callbackResourcesFuture = CompletableFuture.supplyAsync(() -> VerbUtils.scanForResources(configuration, this.parsingContext, configuration.getCallbackLocations()));
                this.callbackResources = (Collection)this.getFromFuture(callbackResourcesFuture);
            } else {
                this.callbackResources = this.resources;
            }
            if (configuration.getInitSql() != null) {
                throw new FlywayException("InitSql is not supported in Native Connectors. Please use the afterConnect callback instead");
            }
            CallbackManager callbackManager = new CallbackManager(configuration, this.callbackResources);
            callbackManager.handleEvent(Event.AFTER_CONNECT, this.database, configuration, this.parsingContext);
            CompletableFuture<SchemaHistoryModel> schemaHistoryModelFuture = CompletableFuture.supplyAsync(() -> VerbUtils.getSchemaHistoryModel(configuration, this.database));
            this.schemaHistoryModel = (SchemaHistoryModel)this.getFromFuture(schemaHistoryModelFuture);
            CompletableFuture.runAsync(() -> NativeConnectorsUtils.logExperimentalDataTelemetry(TelemetryUtils.getTelemetryManager((Configuration)configuration), this.database.getDatabaseMetaData()));
            this.cacheString = this.getCacheString(configuration);
            this.migrations = VerbUtils.getMigrations(this.schemaHistoryModel, (LoadableResourceMetadata[])this.resources.toArray(LoadableResourceMetadata[]::new), configuration);
            this.isInitialized = true;
        }
        catch (SQLException sqlException) {
            throw new FlywayException((Throwable)sqlException);
        }
    }

    private String getCacheString(Configuration configuration) {
        return String.join((CharSequence)",", (CharSequence[])Arrays.stream(configuration.getLocations()).map(Object::toString).toArray(String[]::new)) + configuration.getPlaceholders().entrySet().stream().map(x -> "[" + (String)x.getKey() + "=" + (String)x.getValue() + "]").reduce("", String::concat);
    }

    public void refresh(Configuration configuration) {
        if (this.database.isClosed()) {
            try {
                this.database = VerbUtils.getExperimentalDatabase(configuration);
            }
            catch (SQLException sqlException) {
                throw new FlywayException((Throwable)sqlException);
            }
        }
        this.schemaHistoryModel = VerbUtils.getSchemaHistoryModel(configuration, this.database);
        this.migrations = VerbUtils.getMigrations(this.schemaHistoryModel, (LoadableResourceMetadata[])this.resources.toArray(LoadableResourceMetadata[]::new), configuration);
    }

    public static PreparationContext get(Configuration configuration, boolean cached) {
        PreparationContext preparationContext = (PreparationContext)configuration.getPluginRegister().getExact(PreparationContext.class);
        if (cached) {
            preparationContext.refresh(configuration);
        } else {
            preparationContext.initialize(configuration);
        }
        return preparationContext;
    }

    private Object getFromFuture(Future<?> future) {
        try {
            return future.get();
        }
        catch (InterruptedException | ExecutionException e) {
            if (e.getCause() != null) {
                throw new FlywayException(e.getCause());
            }
            throw new FlywayException((Throwable)e);
        }
    }

    @Generated
    public NativeConnectorsDatabase getDatabase() {
        return this.database;
    }

    @Generated
    public SchemaHistoryModel getSchemaHistoryModel() {
        return this.schemaHistoryModel;
    }

    @Generated
    public Collection<LoadableResourceMetadata> getResources() {
        return this.resources;
    }

    @Generated
    public Collection<LoadableResourceMetadata> getCallbackResources() {
        return this.callbackResources;
    }

    @Generated
    public MigrationInfo[] getMigrations() {
        return this.migrations;
    }

    @Generated
    public ParsingContext getParsingContext() {
        return this.parsingContext;
    }

    @Generated
    public boolean isInitialized() {
        return this.isInitialized;
    }

    @Generated
    public String getCacheString() {
        return this.cacheString;
    }
}

